/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion.testify;

import com.goide.completion.GoCompletionUtil;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoStatement;
import com.goide.psi.GoType;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoReference;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.util.GoStdlibUtil;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTestifyCompletionInsertHandler
implements InsertHandler<LookupElement> {
    private static final String TESTIFY_IMPORT_PATH = "github.com/stretchr/testify";
    private static final Set<String> TESTIFY_PACKAGES = Set.of("github.com/stretchr/testify/assert", "github.com/stretchr/testify/require", "github.com/stretchr/testify/mock", "github.com/stretchr/testify/suite");
    private static final String TESTING_T_TYPE_NAME = "TestingT";
    private static final String TESTING_SUITE_INTERFACE_NAME = "TestingSuite";

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        GoArgumentList argumentList;
        String testingTExpression;
        PsiElement element;
        if (context == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(1);
        }
        if ((element = item.getPsiElement()) == null || !GoTestifyCompletionInsertHandler.isTestifyAssertLikeFunction(element, context)) {
            return;
        }
        assert (element instanceof GoFunctionOrMethodDeclaration && ((GoSignatureOwner)element).getSignature() != null);
        PsiElement elementAtCaret = GoCompletionUtil.commitAndGetElementAtCaret(context);
        String string = testingTExpression = elementAtCaret != null ? GoTestifyCompletionInsertHandler.findSingleTestingTExpression(elementAtCaret, (GoNamedSignatureOwner)element) : null;
        if (testingTExpression == null) {
            return;
        }
        GoCallExpr call = (GoCallExpr)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, GoCallExpr.class, (boolean)false, (Class[])new Class[]{GoStatement.class});
        GoArgumentList goArgumentList = argumentList = call != null ? call.getArgumentList() : null;
        if (argumentList == null || !argumentList.getExpressionList().isEmpty() || argumentList.getRparen() == null) {
            return;
        }
        int parametersNumber = ((GoSignatureOwner)element).getSignature().getParameters().getDefinitionList().size();
        Object insertionText = parametersNumber == 1 ? testingTExpression : testingTExpression + ", ";
        int leftParenOffset = argumentList.getLparen().getTextOffset();
        context.getDocument().insertString(leftParenOffset + 1, (CharSequence)insertionText);
        int newCaretOffset = leftParenOffset + 1 + ((String)insertionText).length();
        if (parametersNumber == 1) {
            ++newCaretOffset;
        }
        context.getEditor().getCaretModel().moveToOffset(newCaretOffset);
    }

    private static boolean isTestifyAssertLikeFunction(@NotNull PsiElement element, @NotNull InsertionContext context) {
        if (element == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(3);
        }
        if (!(element instanceof GoFunctionOrMethodDeclaration)) {
            return false;
        }
        String importPath = GoUtil.getImportPath(element, (PsiElement)context.getFile());
        if (importPath == null || !TESTIFY_PACKAGES.contains(importPath)) {
            return false;
        }
        GoType firstParameterType = Optional.of((GoSignatureOwner)element).map(f -> f.getSignature()).map(s -> s.getParameters().getTypeByIndex(0)).orElse(null);
        return firstParameterType != null && (GoTypeUtil.isKnownType(firstParameterType, (PsiElement)context.getFile(), importPath, TESTING_T_TYPE_NAME, false) || GoStdlibUtil.isTestingT(firstParameterType, (PsiElement)context.getFile()));
    }

    @Nullable
    private static String findSingleTestingTExpression(@NotNull PsiElement context, @NotNull GoNamedSignatureOwner testifyFunction) {
        GoSignatureOwner scope;
        if (context == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(4);
        }
        if (testifyFunction == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(5);
        }
        if ((scope = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)context, GoSignatureOwner.class, (boolean)true)) == null) {
            return null;
        }
        Ref resultExpression = Ref.create();
        NullableLazyValue testifyTestingSuite = NullableLazyValue.lazyNullable(() -> Optional.ofNullable(GoTestifyCompletionInsertHandler.findTestifyPackage(testifyFunction, context)).map(pkg -> GoTestifyCompletionInsertHandler.getDirectoriesScope(pkg, context.getProject())).map(pkgScope -> GoTypeUtil.findInterface(context.getProject(), pkgScope, TESTING_SUITE_INTERFACE_NAME)).orElse(null));
        GoReference.processResolvableVariants(context, scope, (PairProcessor<? super String, ? super PsiElement>)((PairProcessor)(name, element) -> {
            if (!(element instanceof GoParamDefinition || element instanceof GoVarDefinition || element instanceof GoReceiver)) {
                return true;
            }
            String testingTExpression = GoTestifyCompletionInsertHandler.calculateTestingTExpression((GoNamedElement)element, context, (NullableLazyValue<GoInterfaceType>)testifyTestingSuite);
            if (testingTExpression == null) {
                return true;
            }
            if (resultExpression.isNull()) {
                resultExpression.set((Object)testingTExpression);
                return true;
            }
            resultExpression.set(null);
            return false;
        }));
        return StringUtil.nullize((String)((String)resultExpression.get()));
    }

    @Nullable
    private static GoPackage findTestifyPackage(@NotNull GoNamedSignatureOwner testifyFunction, @NotNull PsiElement context) {
        PsiDirectory containingDirectory;
        PsiDirectory testifyDirectory;
        if (testifyFunction == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(6);
        }
        if (context == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(7);
        }
        GoPackage testifyPackage = (testifyDirectory = (PsiDirectory)PsiTreeUtil.findFirstParent((PsiElement)(containingDirectory = testifyFunction.getContainingFile().getContainingDirectory()), p -> p instanceof PsiDirectory && ((PsiDirectory)p).getName().startsWith("testify"))) != null ? GoPackage.in(testifyDirectory, "testify") : null;
        return testifyPackage != null && TESTIFY_IMPORT_PATH.equals(GoTestifyCompletionInsertHandler.getImportPath(testifyPackage, context)) ? testifyPackage : null;
    }

    @Nullable
    private static String getImportPath(@NotNull GoPackage pkg, @NotNull PsiElement context) {
        if (pkg == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(8);
        }
        if (context == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(9);
        }
        return pkg.getImportPath(GoVendoringUtil.isVendoringEnabled(context));
    }

    @NotNull
    private static GlobalSearchScope getDirectoriesScope(@NotNull GoPackage pkg, @NotNull Project project) {
        if (pkg == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(10);
        }
        if (project == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(11);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopes.directoriesScope((Project)project, (boolean)true, (VirtualFile[])pkg.getDirectories().toArray(VirtualFile.EMPTY_ARRAY));
        if (globalSearchScope == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    @Nullable
    private static String calculateTestingTExpression(@NotNull GoNamedElement element, @NotNull PsiElement context, @NotNull NullableLazyValue<GoInterfaceType> testifyTestingSuite) {
        GoType type2;
        if (element == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(13);
        }
        if (context == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(14);
        }
        if (testifyTestingSuite == null) {
            GoTestifyCompletionInsertHandler.$$$reportNull$$$0(15);
        }
        if ((type2 = element.getGoType(null)) == null) {
            return null;
        }
        if (GoStdlibUtil.isStdLibType(type2, context, "testing", "T")) {
            return StringUtil.notNullize((String)element.getName());
        }
        GoType unwrappedType = GoTypeUtil.unwrapPointerAndParTypes(type2);
        if (GoTypeUtil.isNamedType(unwrappedType) && !GoPsiImplUtil.builtin(unwrappedType.resolve(context)) && testifyTestingSuite.getValue() != null && GoTypeUtil.isImplementsInterface((GoType)testifyTestingSuite.getValue(), type2, true, context)) {
            String variableName = element.getName();
            return variableName != null ? variableName + ".T()" : "";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testifyFunction";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/completion/testify/GoTestifyCompletionInsertHandler";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testifyTestingSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/completion/testify/GoTestifyCompletionInsertHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTestifyAssertLikeFunction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSingleTestingTExpression";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findTestifyPackage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getImportPath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesScope";
                break;
            }
            case 12: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calculateTestingTExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

