/*
 * Decompiled with CFR 0.152.
 */
package com.goide.comments;

import com.goide.comments.GoCommentLine;
import com.goide.comments.GoCommentSpanType;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoCommentSpan {
    private final List<GoCommentLine> myLines = new ArrayList<GoCommentLine>();
    private GoCommentSpanType myType = GoCommentSpanType.TEXT;
    private boolean myIsBlankLinesSpan = true;
    @Nullable
    private Integer myMinCommonIndent;
    private boolean myHasLinesWithIncreasedIndent;
    private boolean myHasLinesWithTabIndent = false;
    private boolean myAllLinesWithTabIndent = true;
    private TextRange myRangeInDocument = TextRange.EMPTY_RANGE;

    void addLine(@NotNull GoCommentLine line) {
        if (line == null) {
            GoCommentSpan.$$$reportNull$$$0(0);
        }
        this.myLines.add(line);
        TextRange lineRangeInDocument = line.getRangeInDocument();
        this.myRangeInDocument = this.myRangeInDocument == TextRange.EMPTY_RANGE ? lineRangeInDocument : TextRange.create((int)this.myRangeInDocument.getStartOffset(), (int)lineRangeInDocument.getEndOffset());
        if (!line.isBlank()) {
            this.myMinCommonIndent = this.myMinCommonIndent != null ? Math.min(this.myMinCommonIndent, line.getIndent()) : line.getIndent();
            this.myHasLinesWithIncreasedIndent |= line.getIndent() > this.myMinCommonIndent;
            this.myHasLinesWithTabIndent |= line.isIndentedWithTab();
            this.myAllLinesWithTabIndent &= line.isIndentedWithTab();
        }
        this.myIsBlankLinesSpan = this.myIsBlankLinesSpan && line.isBlank();
    }

    @NotNull
    public List<GoCommentLine> getLines() {
        List<GoCommentLine> list = this.myLines;
        if (list == null) {
            GoCommentSpan.$$$reportNull$$$0(1);
        }
        return list;
    }

    boolean hasLinesWithIncreasedIndent() {
        return this.myHasLinesWithIncreasedIndent || this.myHasLinesWithTabIndent && !this.myAllLinesWithTabIndent;
    }

    public int getMinCommonIndent() {
        return this.myMinCommonIndent != null ? this.myMinCommonIndent : 0;
    }

    public boolean isBlank() {
        return !this.myLines.isEmpty() && this.myIsBlankLinesSpan;
    }

    boolean isIndented(int commonBlockIndent) {
        return this.myMinCommonIndent != null && this.myMinCommonIndent > commonBlockIndent;
    }

    boolean isIndentedWithTab() {
        return !this.myLines.isEmpty() && !this.isBlank() && ContainerUtil.all(this.myLines, it -> it.isBlank() || it.isIndentedWithTab());
    }

    @NotNull
    public GoCommentSpanType getType() {
        GoCommentSpanType goCommentSpanType = this.myType;
        if (goCommentSpanType == null) {
            GoCommentSpan.$$$reportNull$$$0(2);
        }
        return goCommentSpanType;
    }

    public void setType(@NotNull GoCommentSpanType type2) {
        if (type2 == null) {
            GoCommentSpan.$$$reportNull$$$0(3);
        }
        this.myType = type2;
    }

    @NotNull
    TextRange getRangeInDocument() {
        TextRange textRange = this.myRangeInDocument;
        if (textRange == null) {
            GoCommentSpan.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    public String toString() {
        GoCommentLine firstLine = (GoCommentLine)ContainerUtil.getFirstItem(this.myLines);
        String firstLineText = firstLine != null ? firstLine.getLineText().trim() : null;
        return "{" + (String)(firstLineText != null ? "'" + firstLineText + "', " : "") + "line count: " + this.myLines.size() + ", indent: " + this.myMinCommonIndent + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/comments/GoCommentSpan";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/comments/GoCommentSpan";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLine";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }
}

