/*
 * Decompiled with CFR 0.152.
 */
package com.goide.actions.tool;

import com.goide.GoFileType;
import com.goide.psi.GoFile;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoExecutor;
import com.goide.util.GoUtil;
import com.intellij.history.LocalHistory;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoExternalToolsAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GoExternalToolsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GoExternalToolsAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && !this.getFiles(e, project).isEmpty());
    }

    @NotNull
    private List<VirtualFile> getFiles(@NotNull AnActionEvent e, @NotNull Project project) {
        VirtualFile[] files;
        if (e == null) {
            GoExternalToolsAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GoExternalToolsAction.$$$reportNull$$$0(3);
        }
        List<VirtualFile> list = (files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) != null ? this.filterAcceptableFiles(project, List.of(files)) : Collections.emptyList();
        if (list == null) {
            GoExternalToolsAction.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> filterAcceptableFiles(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            GoExternalToolsAction.$$$reportNull$$$0(5);
        }
        if (files == null) {
            GoExternalToolsAction.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.filter(files, file -> {
            if (file == null || !file.isInLocalFileSystem() || !this.isAvailableOnFile(project, (VirtualFile)file)) {
                return false;
            }
            return GoSdkService.getInstance(project).isGoModule(GoExternalToolsAction.findModuleForFile(project, file));
        });
        if (list == null) {
            GoExternalToolsAction.$$$reportNull$$$0(7);
        }
        return list;
    }

    protected boolean showOutput() {
        return false;
    }

    protected boolean isAvailableOnFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            GoExternalToolsAction.$$$reportNull$$$0(8);
        }
        if (file == null) {
            GoExternalToolsAction.$$$reportNull$$$0(9);
        }
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)GoFileType.INSTANCE) || PsiManager.getInstance((Project)project).findFile(file) instanceof GoFile;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GoExternalToolsAction.$$$reportNull$$$0(10);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        List<VirtualFile> files = this.getFiles(e, project);
        MultiMap byModule = ContainerUtil.groupBy(files, file -> GoExternalToolsAction.findModuleForFile(project, file));
        for (Map.Entry entry : byModule.entrySet()) {
            this.doSomething((Collection)entry.getValue(), (Module)entry.getKey(), project, StringUtil.notNullize((String)e.getPresentation().getText()));
        }
    }

    protected boolean isUndoTransparentAction() {
        return false;
    }

    protected boolean doSomething(@NotNull Collection<VirtualFile> files, @Nullable Module module, @NotNull Project project, @NotNull @NlsContexts.NotificationTitle String title) {
        if (files == null) {
            GoExternalToolsAction.$$$reportNull$$$0(11);
        }
        if (project == null) {
            GoExternalToolsAction.$$$reportNull$$$0(12);
        }
        if (title == null) {
            GoExternalToolsAction.$$$reportNull$$$0(13);
        }
        return this.doSomething(files, module, project, title, true, (Consumer<? super GoExecutor.ExecutionResult>)EmptyConsumer.getInstance());
    }

    protected boolean doSomething(@NotNull Collection<VirtualFile> files, @Nullable Module module, @NotNull Project project, @NotNull @NlsContexts.NotificationTitle String title, boolean startInBackground, @NotNull Consumer<? super GoExecutor.ExecutionResult> consumer) {
        if (files == null) {
            GoExternalToolsAction.$$$reportNull$$$0(14);
        }
        if (project == null) {
            GoExternalToolsAction.$$$reportNull$$$0(15);
        }
        if (title == null) {
            GoExternalToolsAction.$$$reportNull$$$0(16);
        }
        if (consumer == null) {
            GoExternalToolsAction.$$$reportNull$$$0(17);
        }
        boolean saveAllDocuments = false;
        HashSet<VirtualFile> modifiedFiles = new HashSet<VirtualFile>();
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        for (VirtualFile file : files) {
            if (!documentManager.isFileModified(file)) continue;
            modifiedFiles.add(file);
            Document document = documentManager.getDocument(file);
            if (document != null) {
                documentManager.saveDocument(document);
                continue;
            }
            saveAllDocuments = true;
        }
        if (saveAllDocuments) {
            documentManager.saveAllDocuments();
        }
        GoExecutor executor = this.createExecutor(project, module, title, files);
        if (ContainerUtil.find(files, f -> ScratchUtil.isScratch((VirtualFile)f)) != null) {
            executor.withExtraEnvironment(Collections.singletonMap("GO111MODULE", "off"));
        }
        Consumer callback = result -> {
            consumer.consume(result);
            for (VirtualFile file : files) {
                if (!file.isDirectory() && this.isUndoTransparentAction()) {
                    this.updateDocumentText(file, project, modifiedFiles.contains(file));
                    continue;
                }
                if (modifiedFiles.contains(file)) {
                    VfsImplUtil.forceSyncRefresh((VirtualFile)file);
                    continue;
                }
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file});
            }
            LocalHistory.getInstance().putSystemLabel(project, title);
        };
        if (this.showOutput()) {
            executor.executeWithOutput((Consumer<? super GoExecutor.ExecutionResult>)callback);
        } else {
            executor.executeWithProgress(startInBackground, true, (Consumer<? super GoExecutor.ExecutionResult>)callback);
        }
        return true;
    }

    protected GoExecutor createExecutor(@NotNull Project project, @Nullable Module module, @NotNull @NlsContexts.NotificationTitle String title, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            GoExternalToolsAction.$$$reportNull$$$0(18);
        }
        if (title == null) {
            GoExternalToolsAction.$$$reportNull$$$0(19);
        }
        if (files == null) {
            GoExternalToolsAction.$$$reportNull$$$0(20);
        }
        String[] filePaths = ArrayUtil.toStringArray((Collection)ContainerUtil.mapNotNull(files, VirtualFile::getCanonicalPath));
        return this.createExecutor(project, module, files, title, filePaths).withRerun(() -> {
            if (project.isDisposed() || module != null && module.isDisposed()) {
                return;
            }
            List validFiles = ContainerUtil.filter((Collection)files, VirtualFile::isValid);
            if (!validFiles.isEmpty()) {
                this.doSomething(validFiles, module, project, title);
            }
        }, false);
    }

    private void updateDocumentText(@NotNull VirtualFile file, @Nullable Project project, boolean forceRefresh) {
        boolean undoInProgress;
        if (file == null) {
            GoExternalToolsAction.$$$reportNull$$$0(21);
        }
        if (file.isDirectory()) {
            return;
        }
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(file));
        UndoManager undoManager = project != null ? UndoManager.getInstance((Project)project) : null;
        boolean bl = undoInProgress = undoManager != null && (undoManager.isUndoInProgress() || undoManager.isRedoInProgress());
        if (document != null && !undoInProgress && document.isWritable()) {
            UndoUtil.forceUndoIn((VirtualFile)file, () -> CommandProcessor.getInstance().executeCommand(project, () -> {
                if (forceRefresh) {
                    VfsImplUtil.forceSyncRefresh((VirtualFile)file);
                } else {
                    file.refresh(false, false);
                }
                WriteAction.run(() -> {
                    document.setText(LoadTextUtil.loadText((VirtualFile)file));
                    FileDocumentManager.getInstance().saveDocument(document);
                });
            }, this.getTemplatePresentation().getText(), null, document));
        }
    }

    @NotNull
    protected abstract GoExecutor createExecutor(@NotNull Project var1, @Nullable Module var2, @NotNull Collection<VirtualFile> var3, @NotNull String var4, String ... var5);

    @Nullable
    private static Module findModuleForFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            GoExternalToolsAction.$$$reportNull$$$0(22);
        }
        if (file == null) {
            return null;
        }
        if (ScratchUtil.isScratch((VirtualFile)file)) {
            return (Module)ContainerUtil.getFirstItem(GoSdkUtil.getGoModules(project));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            psiFile = PsiManager.getInstance((Project)project).findDirectory(file);
        }
        return GoUtil.module((PsiElement)psiFile);
    }

    @Nullable
    protected static String getFirstParentPath(@NotNull Collection<VirtualFile> files) {
        VirtualFile firstFile;
        if (files == null) {
            GoExternalToolsAction.$$$reportNull$$$0(23);
        }
        VirtualFile workDirectory = (firstFile = (VirtualFile)ContainerUtil.getFirstItem(files)) != null ? firstFile.getParent() : null;
        return workDirectory != null ? workDirectory.getPath() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/actions/tool/GoExternalToolsAction";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 15: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/actions/tool/GoExternalToolsAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAcceptableFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterAcceptableFiles";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doSomething";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateDocumentText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFirstParentPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23 -> new IllegalArgumentException(string);
        };
    }
}

