/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwt;

import java.text.DateFormat;
import java.util.Date;
import org.jose4j.lang.Maths;

public class NumericDate {
    private long value;
    private static final long CONVERSION = 1000L;

    private NumericDate(long value2) {
        this.setValue(value2);
    }

    public static NumericDate now() {
        return NumericDate.fromMilliseconds(System.currentTimeMillis());
    }

    public static NumericDate fromSeconds(long secondsFromEpoch) {
        return new NumericDate(secondsFromEpoch);
    }

    public static NumericDate fromMilliseconds(long millisecondsFromEpoch) {
        return NumericDate.fromSeconds(millisecondsFromEpoch / 1000L);
    }

    public void addSeconds(long seconds2) {
        this.setValue(Maths.add(this.value, seconds2));
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value2) {
        this.value = value2;
    }

    public long getValueInMillis() {
        long secs = this.getValue();
        long millis = secs * 1000L;
        if (!this.canConvertToMillis()) {
            throw new ArithmeticException("converting " + secs + " seconds to milliseconds (x1000) resulted in long integer overflow (" + millis + ")");
        }
        return millis;
    }

    private boolean canConvertToMillis() {
        long secs = this.getValue();
        long millis = secs * 1000L;
        return !(secs > 0L && millis < secs || secs < 0L && millis > secs || secs == 0L && millis != 0L);
    }

    public boolean isBefore(NumericDate when) {
        return this.value < when.getValue();
    }

    public boolean isOnOrAfter(NumericDate when) {
        return !this.isBefore(when);
    }

    public boolean isAfter(NumericDate when) {
        return this.value > when.getValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NumericDate").append("{").append(this.getValue());
        if (this.canConvertToMillis()) {
            DateFormat df = DateFormat.getDateTimeInstance(2, 1);
            Date date = new Date(this.getValueInMillis());
            sb.append(" -> ").append(df.format(date));
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof NumericDate && this.value == ((NumericDate)other).value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }
}

