/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.taints;

import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeSpec;
import io.kubernetes.client.openapi.models.V1Taint;
import java.util.Iterator;

public class Taints {
    public static V1Taint findTaint(V1Node node, String key2, Effect effect) {
        for (V1Taint taint : node.getSpec().getTaints()) {
            if (!taint.getKey().equals(key2) || !taint.getEffect().equals(effect.toString())) continue;
            return taint;
        }
        return null;
    }

    public static TaintsBuilder taints(V1Node node) {
        return new TaintsBuilder(node);
    }

    public static enum Effect {
        NO_SCHEDULE{

            public String toString() {
                return "NoSchedule";
            }
        }
        ,
        PREFER_NO_SCHEDULE{

            public String toString() {
                return "PreferNoSchedule";
            }
        }
        ,
        NO_EXECUTE{

            public String toString() {
                return "NoExecute";
            }
        };

    }

    public static class TaintsBuilder {
        private V1Node node;

        TaintsBuilder(V1Node node) {
            this.node = node;
        }

        public TaintsBuilder addTaint(String key2, Effect effect) {
            return this.addTaint(key2, null, effect);
        }

        public TaintsBuilder addTaint(String key2, String value2, Effect effect) {
            V1Taint taint = new V1Taint();
            taint.setKey(key2);
            taint.setValue(value2);
            taint.setEffect(effect.toString());
            if (this.node.getSpec() == null) {
                this.node.setSpec(new V1NodeSpec());
            }
            this.node.getSpec().addTaintsItem(taint);
            return this;
        }

        public TaintsBuilder updateTaint(String key2, String value2, Effect effect) {
            V1Taint taint = Taints.findTaint(this.node, key2, effect);
            taint.setValue(value2);
            return this;
        }

        public TaintsBuilder removeTaint(String key2) {
            if (this.node.getSpec() == null) {
                return this;
            }
            Iterator<V1Taint> taints = this.node.getSpec().getTaints().iterator();
            while (taints.hasNext()) {
                V1Taint taint = taints.next();
                if (!taint.getKey().equals(key2)) continue;
                taints.remove();
            }
            return this;
        }

        public TaintsBuilder removeTaint(String key2, Effect effect) {
            if (this.node.getSpec() == null) {
                return this;
            }
            Iterator<V1Taint> taints = this.node.getSpec().getTaints().iterator();
            while (taints.hasNext()) {
                V1Taint taint = taints.next();
                if (!taint.getKey().equals(key2) || !taint.getEffect().equals(effect.toString())) continue;
                taints.remove();
            }
            return this;
        }
    }
}

