/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.KubeConfig;
import io.kubernetes.client.util.credentials.AccessTokenAuthentication;
import io.kubernetes.client.util.credentials.UsernamePasswordAuthentication;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    public static final String SERVICEACCOUNT_ROOT = "/var/run/secrets/kubernetes.io/serviceaccount";
    public static final String SERVICEACCOUNT_CA_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    public static final String SERVICEACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    public static final String SERVICEACCOUNT_NAMESPACE_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    public static final String ENV_KUBECONFIG = "KUBECONFIG";
    public static final String ENV_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    public static final String ENV_SERVICE_PORT = "KUBERNETES_SERVICE_PORT";
    public static final String DEFAULT_FALLBACK_HOST = "http://localhost:8080";

    public static ApiClient fromCluster() throws IOException {
        return ClientBuilder.cluster().build();
    }

    public static ApiClient fromUrl(String url) {
        return Config.fromUrl(url, true);
    }

    public static ApiClient fromUrl(String url, boolean validateSSL) {
        return new ApiClient().setBasePath(url).setVerifyingSsl(validateSSL);
    }

    public static ApiClient fromUserPassword(String url, String user, String password) {
        return Config.fromUserPassword(url, user, password, true);
    }

    public static ApiClient fromUserPassword(String url, String user, String password, boolean validateSSL) {
        return new ClientBuilder().setBasePath(url).setAuthentication(new UsernamePasswordAuthentication(user, password)).setVerifyingSsl(validateSSL).build();
    }

    public static ApiClient fromToken(String url, String token) {
        return Config.fromToken(url, token, true);
    }

    public static ApiClient fromToken(String url, String token, boolean validateSSL) {
        return new ClientBuilder().setBasePath(url).setAuthentication(new AccessTokenAuthentication(token)).setVerifyingSsl(validateSSL).build();
    }

    public static ApiClient fromConfig(String fileName) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), StandardCharsets.UTF_8.name()));){
            KubeConfig config2 = KubeConfig.loadKubeConfig(bufferedReader);
            config2.setFile(new File(fileName));
            ApiClient apiClient = Config.fromConfig(config2);
            return apiClient;
        }
    }

    public static ApiClient fromConfig(InputStream stream) throws IOException {
        return Config.fromConfig(new InputStreamReader(stream, StandardCharsets.UTF_8.name()));
    }

    public static ApiClient fromConfig(Reader input) throws IOException {
        return Config.fromConfig(KubeConfig.loadKubeConfig(input));
    }

    public static ApiClient fromConfig(KubeConfig config2) throws IOException {
        return ClientBuilder.kubeconfig(config2).build();
    }

    public static ApiClient defaultClient() throws IOException {
        return ClientBuilder.standard().build();
    }
}

