/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1Condition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PodDisruptionBudgetStatus represents information about the status of a PodDisruptionBudget. Status may trail the actual state of a system.")
public class V1PodDisruptionBudgetStatus {
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1Condition> conditions = null;
    public static final String SERIALIZED_NAME_CURRENT_HEALTHY = "currentHealthy";
    @SerializedName(value="currentHealthy")
    private Integer currentHealthy;
    public static final String SERIALIZED_NAME_DESIRED_HEALTHY = "desiredHealthy";
    @SerializedName(value="desiredHealthy")
    private Integer desiredHealthy;
    public static final String SERIALIZED_NAME_DISRUPTED_PODS = "disruptedPods";
    @SerializedName(value="disruptedPods")
    private Map<String, OffsetDateTime> disruptedPods = null;
    public static final String SERIALIZED_NAME_DISRUPTIONS_ALLOWED = "disruptionsAllowed";
    @SerializedName(value="disruptionsAllowed")
    private Integer disruptionsAllowed;
    public static final String SERIALIZED_NAME_EXPECTED_PODS = "expectedPods";
    @SerializedName(value="expectedPods")
    private Integer expectedPods;
    public static final String SERIALIZED_NAME_OBSERVED_GENERATION = "observedGeneration";
    @SerializedName(value="observedGeneration")
    private Long observedGeneration;

    public V1PodDisruptionBudgetStatus conditions(List<V1Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1PodDisruptionBudgetStatus addConditionsItem(V1Condition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1Condition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Conditions contain conditions for PDB. The disruption controller sets the DisruptionAllowed condition. The following are known values for the reason field (additional reasons could be added in the future): - SyncFailed: The controller encountered an error and wasn't able to compute               the number of allowed disruptions. Therefore no disruptions are               allowed and the status of the condition will be False. - InsufficientPods: The number of pods are either at or below the number                     required by the PodDisruptionBudget. No disruptions are                     allowed and the status of the condition will be False. - SufficientPods: There are more pods than required by the PodDisruptionBudget.                   The condition will be True, and the number of allowed                   disruptions are provided by the disruptionsAllowed property.")
    public List<V1Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1Condition> conditions) {
        this.conditions = conditions;
    }

    public V1PodDisruptionBudgetStatus currentHealthy(Integer currentHealthy) {
        this.currentHealthy = currentHealthy;
        return this;
    }

    @ApiModelProperty(required=true, value="current number of healthy pods")
    public Integer getCurrentHealthy() {
        return this.currentHealthy;
    }

    public void setCurrentHealthy(Integer currentHealthy) {
        this.currentHealthy = currentHealthy;
    }

    public V1PodDisruptionBudgetStatus desiredHealthy(Integer desiredHealthy) {
        this.desiredHealthy = desiredHealthy;
        return this;
    }

    @ApiModelProperty(required=true, value="minimum desired number of healthy pods")
    public Integer getDesiredHealthy() {
        return this.desiredHealthy;
    }

    public void setDesiredHealthy(Integer desiredHealthy) {
        this.desiredHealthy = desiredHealthy;
    }

    public V1PodDisruptionBudgetStatus disruptedPods(Map<String, OffsetDateTime> disruptedPods) {
        this.disruptedPods = disruptedPods;
        return this;
    }

    public V1PodDisruptionBudgetStatus putDisruptedPodsItem(String key2, OffsetDateTime disruptedPodsItem) {
        if (this.disruptedPods == null) {
            this.disruptedPods = new HashMap<String, OffsetDateTime>();
        }
        this.disruptedPods.put(key2, disruptedPodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DisruptedPods contains information about pods whose eviction was processed by the API server eviction subresource handler but has not yet been observed by the PodDisruptionBudget controller. A pod will be in this map from the time when the API server processed the eviction request to the time when the pod is seen by PDB controller as having been marked for deletion (or after a timeout). The key in the map is the name of the pod and the value is the time when the API server processed the eviction request. If the deletion didn't occur and a pod is still there it will be removed from the list automatically by PodDisruptionBudget controller after some time. If everything goes smooth this map should be empty for the most of the time. Large number of entries in the map may indicate problems with pod deletions.")
    public Map<String, OffsetDateTime> getDisruptedPods() {
        return this.disruptedPods;
    }

    public void setDisruptedPods(Map<String, OffsetDateTime> disruptedPods) {
        this.disruptedPods = disruptedPods;
    }

    public V1PodDisruptionBudgetStatus disruptionsAllowed(Integer disruptionsAllowed) {
        this.disruptionsAllowed = disruptionsAllowed;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of pod disruptions that are currently allowed.")
    public Integer getDisruptionsAllowed() {
        return this.disruptionsAllowed;
    }

    public void setDisruptionsAllowed(Integer disruptionsAllowed) {
        this.disruptionsAllowed = disruptionsAllowed;
    }

    public V1PodDisruptionBudgetStatus expectedPods(Integer expectedPods) {
        this.expectedPods = expectedPods;
        return this;
    }

    @ApiModelProperty(required=true, value="total number of pods counted by this disruption budget")
    public Integer getExpectedPods() {
        return this.expectedPods;
    }

    public void setExpectedPods(Integer expectedPods) {
        this.expectedPods = expectedPods;
    }

    public V1PodDisruptionBudgetStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Most recent generation observed when updating this PDB status. DisruptionsAllowed and other status information is valid only if observedGeneration equals to PDB's object generation.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodDisruptionBudgetStatus v1PodDisruptionBudgetStatus = (V1PodDisruptionBudgetStatus)o;
        return Objects.equals(this.conditions, v1PodDisruptionBudgetStatus.conditions) && Objects.equals(this.currentHealthy, v1PodDisruptionBudgetStatus.currentHealthy) && Objects.equals(this.desiredHealthy, v1PodDisruptionBudgetStatus.desiredHealthy) && Objects.equals(this.disruptedPods, v1PodDisruptionBudgetStatus.disruptedPods) && Objects.equals(this.disruptionsAllowed, v1PodDisruptionBudgetStatus.disruptionsAllowed) && Objects.equals(this.expectedPods, v1PodDisruptionBudgetStatus.expectedPods) && Objects.equals(this.observedGeneration, v1PodDisruptionBudgetStatus.observedGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.currentHealthy, this.desiredHealthy, this.disruptedPods, this.disruptionsAllowed, this.expectedPods, this.observedGeneration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodDisruptionBudgetStatus {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    currentHealthy: ").append(this.toIndentedString(this.currentHealthy)).append("\n");
        sb.append("    desiredHealthy: ").append(this.toIndentedString(this.desiredHealthy)).append("\n");
        sb.append("    disruptedPods: ").append(this.toIndentedString(this.disruptedPods)).append("\n");
        sb.append("    disruptionsAllowed: ").append(this.toIndentedString(this.disruptionsAllowed)).append("\n");
        sb.append("    expectedPods: ").append(this.toIndentedString(this.expectedPods)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

