/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.Quantity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LimitRangeItem defines a min/max usage limit for any resource that matches on kind.")
public class V1LimitRangeItem {
    public static final String SERIALIZED_NAME_DEFAULT = "default";
    @SerializedName(value="default")
    private Map<String, Quantity> _default = null;
    public static final String SERIALIZED_NAME_DEFAULT_REQUEST = "defaultRequest";
    @SerializedName(value="defaultRequest")
    private Map<String, Quantity> defaultRequest = null;
    public static final String SERIALIZED_NAME_MAX = "max";
    @SerializedName(value="max")
    private Map<String, Quantity> max = null;
    public static final String SERIALIZED_NAME_MAX_LIMIT_REQUEST_RATIO = "maxLimitRequestRatio";
    @SerializedName(value="maxLimitRequestRatio")
    private Map<String, Quantity> maxLimitRequestRatio = null;
    public static final String SERIALIZED_NAME_MIN = "min";
    @SerializedName(value="min")
    private Map<String, Quantity> min = null;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public V1LimitRangeItem _default(Map<String, Quantity> _default) {
        this._default = _default;
        return this;
    }

    public V1LimitRangeItem putDefaultItem(String key2, Quantity _defaultItem) {
        if (this._default == null) {
            this._default = new HashMap<String, Quantity>();
        }
        this._default.put(key2, _defaultItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Default resource requirement limit value by resource name if resource limit is omitted.")
    public Map<String, Quantity> getDefault() {
        return this._default;
    }

    public void setDefault(Map<String, Quantity> _default) {
        this._default = _default;
    }

    public V1LimitRangeItem defaultRequest(Map<String, Quantity> defaultRequest) {
        this.defaultRequest = defaultRequest;
        return this;
    }

    public V1LimitRangeItem putDefaultRequestItem(String key2, Quantity defaultRequestItem) {
        if (this.defaultRequest == null) {
            this.defaultRequest = new HashMap<String, Quantity>();
        }
        this.defaultRequest.put(key2, defaultRequestItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.")
    public Map<String, Quantity> getDefaultRequest() {
        return this.defaultRequest;
    }

    public void setDefaultRequest(Map<String, Quantity> defaultRequest) {
        this.defaultRequest = defaultRequest;
    }

    public V1LimitRangeItem max(Map<String, Quantity> max) {
        this.max = max;
        return this;
    }

    public V1LimitRangeItem putMaxItem(String key2, Quantity maxItem) {
        if (this.max == null) {
            this.max = new HashMap<String, Quantity>();
        }
        this.max.put(key2, maxItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Max usage constraints on this kind by resource name.")
    public Map<String, Quantity> getMax() {
        return this.max;
    }

    public void setMax(Map<String, Quantity> max) {
        this.max = max;
    }

    public V1LimitRangeItem maxLimitRequestRatio(Map<String, Quantity> maxLimitRequestRatio) {
        this.maxLimitRequestRatio = maxLimitRequestRatio;
        return this;
    }

    public V1LimitRangeItem putMaxLimitRequestRatioItem(String key2, Quantity maxLimitRequestRatioItem) {
        if (this.maxLimitRequestRatio == null) {
            this.maxLimitRequestRatio = new HashMap<String, Quantity>();
        }
        this.maxLimitRequestRatio.put(key2, maxLimitRequestRatioItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.")
    public Map<String, Quantity> getMaxLimitRequestRatio() {
        return this.maxLimitRequestRatio;
    }

    public void setMaxLimitRequestRatio(Map<String, Quantity> maxLimitRequestRatio) {
        this.maxLimitRequestRatio = maxLimitRequestRatio;
    }

    public V1LimitRangeItem min(Map<String, Quantity> min) {
        this.min = min;
        return this;
    }

    public V1LimitRangeItem putMinItem(String key2, Quantity minItem) {
        if (this.min == null) {
            this.min = new HashMap<String, Quantity>();
        }
        this.min.put(key2, minItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Min usage constraints on this kind by resource name.")
    public Map<String, Quantity> getMin() {
        return this.min;
    }

    public void setMin(Map<String, Quantity> min) {
        this.min = min;
    }

    public V1LimitRangeItem type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of resource that this limit applies to.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LimitRangeItem v1LimitRangeItem = (V1LimitRangeItem)o;
        return Objects.equals(this._default, v1LimitRangeItem._default) && Objects.equals(this.defaultRequest, v1LimitRangeItem.defaultRequest) && Objects.equals(this.max, v1LimitRangeItem.max) && Objects.equals(this.maxLimitRequestRatio, v1LimitRangeItem.maxLimitRequestRatio) && Objects.equals(this.min, v1LimitRangeItem.min) && Objects.equals(this.type, v1LimitRangeItem.type);
    }

    public int hashCode() {
        return Objects.hash(this._default, this.defaultRequest, this.max, this.maxLimitRequestRatio, this.min, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LimitRangeItem {\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    defaultRequest: ").append(this.toIndentedString(this.defaultRequest)).append("\n");
        sb.append("    max: ").append(this.toIndentedString(this.max)).append("\n");
        sb.append("    maxLimitRequestRatio: ").append(this.toIndentedString(this.maxLimitRequestRatio)).append("\n");
        sb.append("    min: ").append(this.toIndentedString(this.min)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

