/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1SecretReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents storage that is managed by an external CSI volume driver (Beta feature)")
public class V1CSIPersistentVolumeSource {
    public static final String SERIALIZED_NAME_CONTROLLER_EXPAND_SECRET_REF = "controllerExpandSecretRef";
    @SerializedName(value="controllerExpandSecretRef")
    private V1SecretReference controllerExpandSecretRef;
    public static final String SERIALIZED_NAME_CONTROLLER_PUBLISH_SECRET_REF = "controllerPublishSecretRef";
    @SerializedName(value="controllerPublishSecretRef")
    private V1SecretReference controllerPublishSecretRef;
    public static final String SERIALIZED_NAME_DRIVER = "driver";
    @SerializedName(value="driver")
    private String driver;
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_NODE_EXPAND_SECRET_REF = "nodeExpandSecretRef";
    @SerializedName(value="nodeExpandSecretRef")
    private V1SecretReference nodeExpandSecretRef;
    public static final String SERIALIZED_NAME_NODE_PUBLISH_SECRET_REF = "nodePublishSecretRef";
    @SerializedName(value="nodePublishSecretRef")
    private V1SecretReference nodePublishSecretRef;
    public static final String SERIALIZED_NAME_NODE_STAGE_SECRET_REF = "nodeStageSecretRef";
    @SerializedName(value="nodeStageSecretRef")
    private V1SecretReference nodeStageSecretRef;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_VOLUME_ATTRIBUTES = "volumeAttributes";
    @SerializedName(value="volumeAttributes")
    private Map<String, String> volumeAttributes = null;
    public static final String SERIALIZED_NAME_VOLUME_HANDLE = "volumeHandle";
    @SerializedName(value="volumeHandle")
    private String volumeHandle;

    public V1CSIPersistentVolumeSource controllerExpandSecretRef(V1SecretReference controllerExpandSecretRef) {
        this.controllerExpandSecretRef = controllerExpandSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretReference getControllerExpandSecretRef() {
        return this.controllerExpandSecretRef;
    }

    public void setControllerExpandSecretRef(V1SecretReference controllerExpandSecretRef) {
        this.controllerExpandSecretRef = controllerExpandSecretRef;
    }

    public V1CSIPersistentVolumeSource controllerPublishSecretRef(V1SecretReference controllerPublishSecretRef) {
        this.controllerPublishSecretRef = controllerPublishSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretReference getControllerPublishSecretRef() {
        return this.controllerPublishSecretRef;
    }

    public void setControllerPublishSecretRef(V1SecretReference controllerPublishSecretRef) {
        this.controllerPublishSecretRef = controllerPublishSecretRef;
    }

    public V1CSIPersistentVolumeSource driver(String driver) {
        this.driver = driver;
        return this;
    }

    @ApiModelProperty(required=true, value="driver is the name of the driver to use for this volume. Required.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public V1CSIPersistentVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fsType to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\".")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1CSIPersistentVolumeSource nodeExpandSecretRef(V1SecretReference nodeExpandSecretRef) {
        this.nodeExpandSecretRef = nodeExpandSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretReference getNodeExpandSecretRef() {
        return this.nodeExpandSecretRef;
    }

    public void setNodeExpandSecretRef(V1SecretReference nodeExpandSecretRef) {
        this.nodeExpandSecretRef = nodeExpandSecretRef;
    }

    public V1CSIPersistentVolumeSource nodePublishSecretRef(V1SecretReference nodePublishSecretRef) {
        this.nodePublishSecretRef = nodePublishSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretReference getNodePublishSecretRef() {
        return this.nodePublishSecretRef;
    }

    public void setNodePublishSecretRef(V1SecretReference nodePublishSecretRef) {
        this.nodePublishSecretRef = nodePublishSecretRef;
    }

    public V1CSIPersistentVolumeSource nodeStageSecretRef(V1SecretReference nodeStageSecretRef) {
        this.nodeStageSecretRef = nodeStageSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretReference getNodeStageSecretRef() {
        return this.nodeStageSecretRef;
    }

    public void setNodeStageSecretRef(V1SecretReference nodeStageSecretRef) {
        this.nodeStageSecretRef = nodeStageSecretRef;
    }

    public V1CSIPersistentVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readOnly value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write).")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1CSIPersistentVolumeSource volumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes;
        return this;
    }

    public V1CSIPersistentVolumeSource putVolumeAttributesItem(String key2, String volumeAttributesItem) {
        if (this.volumeAttributes == null) {
            this.volumeAttributes = new HashMap<String, String>();
        }
        this.volumeAttributes.put(key2, volumeAttributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeAttributes of the volume to publish.")
    public Map<String, String> getVolumeAttributes() {
        return this.volumeAttributes;
    }

    public void setVolumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes;
    }

    public V1CSIPersistentVolumeSource volumeHandle(String volumeHandle) {
        this.volumeHandle = volumeHandle;
        return this;
    }

    @ApiModelProperty(required=true, value="volumeHandle is the unique volume name returned by the CSI volume plugin\u2019s CreateVolume to refer to the volume on all subsequent calls. Required.")
    public String getVolumeHandle() {
        return this.volumeHandle;
    }

    public void setVolumeHandle(String volumeHandle) {
        this.volumeHandle = volumeHandle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CSIPersistentVolumeSource v1CSIPersistentVolumeSource = (V1CSIPersistentVolumeSource)o;
        return Objects.equals(this.controllerExpandSecretRef, v1CSIPersistentVolumeSource.controllerExpandSecretRef) && Objects.equals(this.controllerPublishSecretRef, v1CSIPersistentVolumeSource.controllerPublishSecretRef) && Objects.equals(this.driver, v1CSIPersistentVolumeSource.driver) && Objects.equals(this.fsType, v1CSIPersistentVolumeSource.fsType) && Objects.equals(this.nodeExpandSecretRef, v1CSIPersistentVolumeSource.nodeExpandSecretRef) && Objects.equals(this.nodePublishSecretRef, v1CSIPersistentVolumeSource.nodePublishSecretRef) && Objects.equals(this.nodeStageSecretRef, v1CSIPersistentVolumeSource.nodeStageSecretRef) && Objects.equals(this.readOnly, v1CSIPersistentVolumeSource.readOnly) && Objects.equals(this.volumeAttributes, v1CSIPersistentVolumeSource.volumeAttributes) && Objects.equals(this.volumeHandle, v1CSIPersistentVolumeSource.volumeHandle);
    }

    public int hashCode() {
        return Objects.hash(this.controllerExpandSecretRef, this.controllerPublishSecretRef, this.driver, this.fsType, this.nodeExpandSecretRef, this.nodePublishSecretRef, this.nodeStageSecretRef, this.readOnly, this.volumeAttributes, this.volumeHandle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CSIPersistentVolumeSource {\n");
        sb.append("    controllerExpandSecretRef: ").append(this.toIndentedString(this.controllerExpandSecretRef)).append("\n");
        sb.append("    controllerPublishSecretRef: ").append(this.toIndentedString(this.controllerPublishSecretRef)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    nodeExpandSecretRef: ").append(this.toIndentedString(this.nodeExpandSecretRef)).append("\n");
        sb.append("    nodePublishSecretRef: ").append(this.toIndentedString(this.nodePublishSecretRef)).append("\n");
        sb.append("    nodeStageSecretRef: ").append(this.toIndentedString(this.nodeStageSecretRef)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    volumeAttributes: ").append(this.toIndentedString(this.volumeAttributes)).append("\n");
        sb.append("    volumeHandle: ").append(this.toIndentedString(this.volumeHandle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

