/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequest;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Status;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CertificatesV1Api {
    private ApiClient localVarApiClient;

    public CertificatesV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public CertificatesV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createCertificateSigningRequestCall(V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1CertificateSigningRequest localVarPostBody = body;
        String localVarPath = "/apis/certificates.k8s.io/v1/certificatesigningrequests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCertificateSigningRequestValidateBeforeCall(V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createCertificateSigningRequest(Async)");
        }
        Call localVarCall = this.createCertificateSigningRequestCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1CertificateSigningRequest createCertificateSigningRequest(V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1CertificateSigningRequest> localVarResp = this.createCertificateSigningRequestWithHttpInfo(body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1CertificateSigningRequest> createCertificateSigningRequestWithHttpInfo(V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.createCertificateSigningRequestValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCertificateSigningRequestAsync(V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1CertificateSigningRequest> _callback) throws ApiException {
        Call localVarCall = this.createCertificateSigningRequestValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCertificateSigningRequestCall(String name2, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/certificates.k8s.io/v1/certificatesigningrequests/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name2.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCertificateSigningRequestValidateBeforeCall(String name2, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name2 == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteCertificateSigningRequest(Async)");
        }
        Call localVarCall = this.deleteCertificateSigningRequestCall(name2, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
        return localVarCall;
    }

    public V1Status deleteCertificateSigningRequest(String name2, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1Status> localVarResp = this.deleteCertificateSigningRequestWithHttpInfo(name2, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1Status> deleteCertificateSigningRequestWithHttpInfo(String name2, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCertificateSigningRequestValidateBeforeCall(name2, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCertificateSigningRequestAsync(String name2, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCertificateSigningRequestValidateBeforeCall(name2, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCollectionCertificateSigningRequestCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/certificates.k8s.io/v1/certificatesigningrequests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionCertificateSigningRequestValidateBeforeCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionCertificateSigningRequestCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        return localVarCall;
    }

    public V1Status deleteCollectionCertificateSigningRequest(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1Status> localVarResp = this.deleteCollectionCertificateSigningRequestWithHttpInfo(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1Status> deleteCollectionCertificateSigningRequestWithHttpInfo(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionCertificateSigningRequestValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCollectionCertificateSigningRequestAsync(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionCertificateSigningRequestValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIResourcesCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/certificates.k8s.io/v1/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesCall(_callback);
        return localVarCall;
    }

    public V1APIResourceList getAPIResources() throws ApiException {
        ApiResponse<V1APIResourceList> localVarResp = this.getAPIResourcesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIResourcesAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCertificateSigningRequestCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch2, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/certificates.k8s.io/v1/certificatesigningrequests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch2 != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch2));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCertificateSigningRequestValidateBeforeCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch2, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCertificateSigningRequestCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch2, _callback);
        return localVarCall;
    }

    public V1CertificateSigningRequestList listCertificateSigningRequest(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch2) throws ApiException {
        ApiResponse<V1CertificateSigningRequestList> localVarResp = this.listCertificateSigningRequestWithHttpInfo(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch2);
        return localVarResp.getData();
    }

    public ApiResponse<V1CertificateSigningRequestList> listCertificateSigningRequestWithHttpInfo(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch2) throws ApiException {
        Call localVarCall = this.listCertificateSigningRequestValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch2, null);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequestList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCertificateSigningRequestAsync(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch2, ApiCallback<V1CertificateSigningRequestList> _callback) throws ApiException {
        Call localVarCall = this.listCertificateSigningRequestValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch2, _callback);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequestList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchCertificateSigningRequestCall(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/certificates.k8s.io/v1/certificatesigningrequests/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name2.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/merge-patch+json", "application/strategic-merge-patch+json", "application/apply-patch+yaml"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchCertificateSigningRequestValidateBeforeCall(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name2 == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchCertificateSigningRequest(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchCertificateSigningRequest(Async)");
        }
        Call localVarCall = this.patchCertificateSigningRequestCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public V1CertificateSigningRequest patchCertificateSigningRequest(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<V1CertificateSigningRequest> localVarResp = this.patchCertificateSigningRequestWithHttpInfo(name2, body, pretty, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<V1CertificateSigningRequest> patchCertificateSigningRequestWithHttpInfo(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchCertificateSigningRequestValidateBeforeCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchCertificateSigningRequestAsync(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1CertificateSigningRequest> _callback) throws ApiException {
        Call localVarCall = this.patchCertificateSigningRequestValidateBeforeCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchCertificateSigningRequestApprovalCall(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/certificates.k8s.io/v1/certificatesigningrequests/{name}/approval".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name2.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/merge-patch+json", "application/strategic-merge-patch+json", "application/apply-patch+yaml"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchCertificateSigningRequestApprovalValidateBeforeCall(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name2 == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchCertificateSigningRequestApproval(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchCertificateSigningRequestApproval(Async)");
        }
        Call localVarCall = this.patchCertificateSigningRequestApprovalCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public V1CertificateSigningRequest patchCertificateSigningRequestApproval(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<V1CertificateSigningRequest> localVarResp = this.patchCertificateSigningRequestApprovalWithHttpInfo(name2, body, pretty, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<V1CertificateSigningRequest> patchCertificateSigningRequestApprovalWithHttpInfo(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchCertificateSigningRequestApprovalValidateBeforeCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchCertificateSigningRequestApprovalAsync(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1CertificateSigningRequest> _callback) throws ApiException {
        Call localVarCall = this.patchCertificateSigningRequestApprovalValidateBeforeCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchCertificateSigningRequestStatusCall(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/certificates.k8s.io/v1/certificatesigningrequests/{name}/status".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name2.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/merge-patch+json", "application/strategic-merge-patch+json", "application/apply-patch+yaml"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchCertificateSigningRequestStatusValidateBeforeCall(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name2 == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchCertificateSigningRequestStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchCertificateSigningRequestStatus(Async)");
        }
        Call localVarCall = this.patchCertificateSigningRequestStatusCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public V1CertificateSigningRequest patchCertificateSigningRequestStatus(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<V1CertificateSigningRequest> localVarResp = this.patchCertificateSigningRequestStatusWithHttpInfo(name2, body, pretty, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<V1CertificateSigningRequest> patchCertificateSigningRequestStatusWithHttpInfo(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchCertificateSigningRequestStatusValidateBeforeCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchCertificateSigningRequestStatusAsync(String name2, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1CertificateSigningRequest> _callback) throws ApiException {
        Call localVarCall = this.patchCertificateSigningRequestStatusValidateBeforeCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readCertificateSigningRequestCall(String name2, String pretty, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/certificates.k8s.io/v1/certificatesigningrequests/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name2.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readCertificateSigningRequestValidateBeforeCall(String name2, String pretty, ApiCallback _callback) throws ApiException {
        if (name2 == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readCertificateSigningRequest(Async)");
        }
        Call localVarCall = this.readCertificateSigningRequestCall(name2, pretty, _callback);
        return localVarCall;
    }

    public V1CertificateSigningRequest readCertificateSigningRequest(String name2, String pretty) throws ApiException {
        ApiResponse<V1CertificateSigningRequest> localVarResp = this.readCertificateSigningRequestWithHttpInfo(name2, pretty);
        return localVarResp.getData();
    }

    public ApiResponse<V1CertificateSigningRequest> readCertificateSigningRequestWithHttpInfo(String name2, String pretty) throws ApiException {
        Call localVarCall = this.readCertificateSigningRequestValidateBeforeCall(name2, pretty, null);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readCertificateSigningRequestAsync(String name2, String pretty, ApiCallback<V1CertificateSigningRequest> _callback) throws ApiException {
        Call localVarCall = this.readCertificateSigningRequestValidateBeforeCall(name2, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readCertificateSigningRequestApprovalCall(String name2, String pretty, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/certificates.k8s.io/v1/certificatesigningrequests/{name}/approval".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name2.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readCertificateSigningRequestApprovalValidateBeforeCall(String name2, String pretty, ApiCallback _callback) throws ApiException {
        if (name2 == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readCertificateSigningRequestApproval(Async)");
        }
        Call localVarCall = this.readCertificateSigningRequestApprovalCall(name2, pretty, _callback);
        return localVarCall;
    }

    public V1CertificateSigningRequest readCertificateSigningRequestApproval(String name2, String pretty) throws ApiException {
        ApiResponse<V1CertificateSigningRequest> localVarResp = this.readCertificateSigningRequestApprovalWithHttpInfo(name2, pretty);
        return localVarResp.getData();
    }

    public ApiResponse<V1CertificateSigningRequest> readCertificateSigningRequestApprovalWithHttpInfo(String name2, String pretty) throws ApiException {
        Call localVarCall = this.readCertificateSigningRequestApprovalValidateBeforeCall(name2, pretty, null);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readCertificateSigningRequestApprovalAsync(String name2, String pretty, ApiCallback<V1CertificateSigningRequest> _callback) throws ApiException {
        Call localVarCall = this.readCertificateSigningRequestApprovalValidateBeforeCall(name2, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readCertificateSigningRequestStatusCall(String name2, String pretty, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/certificates.k8s.io/v1/certificatesigningrequests/{name}/status".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name2.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readCertificateSigningRequestStatusValidateBeforeCall(String name2, String pretty, ApiCallback _callback) throws ApiException {
        if (name2 == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readCertificateSigningRequestStatus(Async)");
        }
        Call localVarCall = this.readCertificateSigningRequestStatusCall(name2, pretty, _callback);
        return localVarCall;
    }

    public V1CertificateSigningRequest readCertificateSigningRequestStatus(String name2, String pretty) throws ApiException {
        ApiResponse<V1CertificateSigningRequest> localVarResp = this.readCertificateSigningRequestStatusWithHttpInfo(name2, pretty);
        return localVarResp.getData();
    }

    public ApiResponse<V1CertificateSigningRequest> readCertificateSigningRequestStatusWithHttpInfo(String name2, String pretty) throws ApiException {
        Call localVarCall = this.readCertificateSigningRequestStatusValidateBeforeCall(name2, pretty, null);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readCertificateSigningRequestStatusAsync(String name2, String pretty, ApiCallback<V1CertificateSigningRequest> _callback) throws ApiException {
        Call localVarCall = this.readCertificateSigningRequestStatusValidateBeforeCall(name2, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceCertificateSigningRequestCall(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1CertificateSigningRequest localVarPostBody = body;
        String localVarPath = "/apis/certificates.k8s.io/v1/certificatesigningrequests/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name2.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceCertificateSigningRequestValidateBeforeCall(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name2 == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceCertificateSigningRequest(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceCertificateSigningRequest(Async)");
        }
        Call localVarCall = this.replaceCertificateSigningRequestCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1CertificateSigningRequest replaceCertificateSigningRequest(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1CertificateSigningRequest> localVarResp = this.replaceCertificateSigningRequestWithHttpInfo(name2, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1CertificateSigningRequest> replaceCertificateSigningRequestWithHttpInfo(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceCertificateSigningRequestValidateBeforeCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceCertificateSigningRequestAsync(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1CertificateSigningRequest> _callback) throws ApiException {
        Call localVarCall = this.replaceCertificateSigningRequestValidateBeforeCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceCertificateSigningRequestApprovalCall(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1CertificateSigningRequest localVarPostBody = body;
        String localVarPath = "/apis/certificates.k8s.io/v1/certificatesigningrequests/{name}/approval".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name2.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceCertificateSigningRequestApprovalValidateBeforeCall(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name2 == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceCertificateSigningRequestApproval(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceCertificateSigningRequestApproval(Async)");
        }
        Call localVarCall = this.replaceCertificateSigningRequestApprovalCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1CertificateSigningRequest replaceCertificateSigningRequestApproval(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1CertificateSigningRequest> localVarResp = this.replaceCertificateSigningRequestApprovalWithHttpInfo(name2, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1CertificateSigningRequest> replaceCertificateSigningRequestApprovalWithHttpInfo(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceCertificateSigningRequestApprovalValidateBeforeCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceCertificateSigningRequestApprovalAsync(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1CertificateSigningRequest> _callback) throws ApiException {
        Call localVarCall = this.replaceCertificateSigningRequestApprovalValidateBeforeCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceCertificateSigningRequestStatusCall(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1CertificateSigningRequest localVarPostBody = body;
        String localVarPath = "/apis/certificates.k8s.io/v1/certificatesigningrequests/{name}/status".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name2.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceCertificateSigningRequestStatusValidateBeforeCall(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name2 == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceCertificateSigningRequestStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceCertificateSigningRequestStatus(Async)");
        }
        Call localVarCall = this.replaceCertificateSigningRequestStatusCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1CertificateSigningRequest replaceCertificateSigningRequestStatus(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1CertificateSigningRequest> localVarResp = this.replaceCertificateSigningRequestStatusWithHttpInfo(name2, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1CertificateSigningRequest> replaceCertificateSigningRequestStatusWithHttpInfo(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceCertificateSigningRequestStatusValidateBeforeCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceCertificateSigningRequestStatusAsync(String name2, V1CertificateSigningRequest body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1CertificateSigningRequest> _callback) throws ApiException {
        Call localVarCall = this.replaceCertificateSigningRequestStatusValidateBeforeCall(name2, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1CertificateSigningRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

