/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.apimachinery;

import io.kubernetes.client.util.Preconditions;
import java.util.Objects;

public class NamespaceName {
    private final String namespace;
    private final String name;

    public NamespaceName(String namespace, String name2) {
        this.namespace = Preconditions.precondition(namespace, Objects::isNull, () -> "namespace must not be null");
        this.name = Preconditions.precondition(name2, Objects::isNull, () -> "name must not be null");
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespaceName that = (NamespaceName)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.name);
    }
}

