/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.wsl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WslPath;
import com.intellij.kubernetes.wsl.WslOrNativePath;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016J)\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000e\u001a\u0002H\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kubernetes/wsl/MyWslPath;", "Lcom/intellij/kubernetes/wsl/WslOrNativePath;", "wslPath", "Lcom/intellij/execution/wsl/WslPath;", "path", "", "(Lcom/intellij/execution/wsl/WslPath;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "getPathForFile", "filePath", "patchCommand", "T", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "command", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/intellij/openapi/project/Project;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "toCommandPath", "intellij.clouds.kubernetes"})
final class MyWslPath
extends WslOrNativePath {
    @NotNull
    private final WslPath wslPath;
    @NotNull
    private final String path;

    public MyWslPath(@NotNull WslPath wslPath, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)wslPath, (String)"wslPath");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.wslPath = wslPath;
        this.path = path;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public String getPathForFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String string = this.wslPath.getDistribution().getWslPath(filePath);
        if (string == null) {
            string = filePath;
        }
        return string;
    }

    @Override
    @NotNull
    public String toCommandPath() {
        return this.wslPath.getLinuxPath();
    }

    @Override
    @NotNull
    public <T extends GeneralCommandLine> T patchCommand(@NotNull T command, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        WSLCommandLineOptions wSLCommandLineOptions = new WSLCommandLineOptions().setLaunchWithWslExe(true).setExecuteCommandInShell(false).setPassEnvVarsUsingInterop(true);
        Intrinsics.checkNotNullExpressionValue((Object)wSLCommandLineOptions, (String)"setPassEnvVarsUsingInterop(...)");
        WSLCommandLineOptions wslOptions = wSLCommandLineOptions;
        GeneralCommandLine generalCommandLine = this.wslPath.getDistribution().patchCommandLine(command, project2, wslOptions);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"patchCommandLine(...)");
        return (T)generalCommandLine;
    }
}

