/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.vfs;

import com.intellij.kubernetes.view.vfs.UtilsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/view/vfs/KubernetesVirtualFileBaseContentProvider;", "Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getBaseRevision", "Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider$BaseContent;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isSupported", "", "intellij.clouds.kubernetes"})
public final class KubernetesVirtualFileBaseContentProvider
implements VcsBaseContentProvider {
    @NotNull
    private final Project project;

    public KubernetesVirtualFileBaseContentProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    public boolean isSupported(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return UtilsKt.isKubernetesFile(file2, this.project);
    }

    @NotNull
    public VcsBaseContentProvider.BaseContent getBaseRevision(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return new VcsBaseContentProvider.BaseContent(file2){
            @NotNull
            private final TextRevisionNumber revisionNumber;
            final /* synthetic */ VirtualFile $file;
            {
                this.$file = $file;
                this.revisionNumber = new TextRevisionNumber(String.valueOf($file.getModificationStamp()));
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                return (VcsRevisionNumber)this.revisionNumber;
            }

            @NotNull
            public String loadContent() {
                String string = VfsUtilCore.loadText((VirtualFile)this.$file);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
                return string;
            }
        };
    }
}

