/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.vfs;

import com.intellij.kubernetes.view.vfs.KubernetesVirtualFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.UtilKt;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0000H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u000bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bH\u0016J\u001a\u0010\"\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010#\u001a\u00020$H\u0007R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/kubernetes/view/vfs/KubernetesVirtualDirectory;", "Lcom/intellij/testFramework/LightVirtualFileBase;", "name", "", "parent", "(Ljava/lang/String;Lcom/intellij/kubernetes/view/vfs/KubernetesVirtualDirectory;)V", "children", "Ljava/util/concurrent/ConcurrentHashMap;", "contentsToByteArray", "", "equals", "", "other", "", "getChildren", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getInputStream", "Ljava/io/InputStream;", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "newModificationStamp", "", "newTimeStamp", "getParent", "hashCode", "", "isDirectory", "mkdir", "setWritable", "", "writable", "touch", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "intellij.clouds.kubernetes"})
public final class KubernetesVirtualDirectory
extends LightVirtualFileBase {
    @Nullable
    private final KubernetesVirtualDirectory parent;
    @NotNull
    private final ConcurrentHashMap<String, LightVirtualFileBase> children;

    public KubernetesVirtualDirectory(@NotNull String name2, @Nullable KubernetesVirtualDirectory parent) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(name2, UnknownFileType.INSTANCE, LocalTimeCounter.currentTime());
        this.parent = parent;
        this.children = new ConcurrentHashMap(1);
        super.setWritable(false);
    }

    @Nullable
    public KubernetesVirtualDirectory getParent() {
        return this.parent;
    }

    @NotNull
    public VirtualFile[] getChildren() {
        Collection<LightVirtualFileBase> collection = this.children.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Intrinsics.checkNotNullExpressionValue((Object)VirtualFile.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return (VirtualFile[])UtilKt.toArray(collection, (Object[])VirtualFile.EMPTY_ARRAY);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof KubernetesVirtualDirectory && Intrinsics.areEqual((Object)this.getName(), (Object)((KubernetesVirtualDirectory)((Object)other)).getName()) && Intrinsics.areEqual((Object)((Object)this.parent), (Object)((Object)((KubernetesVirtualDirectory)((Object)other)).parent));
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getName(), this.parent};
        return Objects.hash(objectArray);
    }

    public boolean isDirectory() {
        return true;
    }

    public void setWritable(boolean writable) {
        if (writable) {
            throw new UnsupportedOperationException();
        }
    }

    @NotNull
    public OutputStream getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public byte[] contentsToByteArray() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    @RequiresWriteLock
    @NotNull
    public final KubernetesVirtualDirectory mkdir(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        LightVirtualFileBase lightVirtualFileBase = this.children.computeIfAbsent(name2, arg_0 -> KubernetesVirtualDirectory.mkdir$lambda$0((Function1)new Function1<String, LightVirtualFileBase>(this){
            final /* synthetic */ KubernetesVirtualDirectory this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final LightVirtualFileBase invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new KubernetesVirtualDirectory(it, this.this$0);
            }
        }, arg_0));
        KubernetesVirtualDirectory kubernetesVirtualDirectory = lightVirtualFileBase instanceof KubernetesVirtualDirectory ? (KubernetesVirtualDirectory)lightVirtualFileBase : null;
        if (kubernetesVirtualDirectory == null) {
            throw new IllegalArgumentException(name2 + ": File exists");
        }
        return kubernetesVirtualDirectory;
    }

    @RequiresWriteLock
    @NotNull
    public final LightVirtualFileBase touch(@NotNull String name2, @NotNull LanguageFileType fileType) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        LightVirtualFileBase lightVirtualFileBase = this.children.computeIfAbsent(name2, arg_0 -> KubernetesVirtualDirectory.touch$lambda$1((Function1)new Function1<String, LightVirtualFileBase>(this, fileType){
            final /* synthetic */ KubernetesVirtualDirectory this$0;
            final /* synthetic */ LanguageFileType $fileType;
            {
                this.this$0 = $receiver;
                this.$fileType = $fileType;
                super(1);
            }

            @NotNull
            public final LightVirtualFileBase invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (LightVirtualFileBase)new KubernetesVirtualFile(this.this$0, it, (FileType)this.$fileType);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)lightVirtualFileBase, (String)"computeIfAbsent(...)");
        return lightVirtualFileBase;
    }

    public static /* synthetic */ LightVirtualFileBase touch$default(KubernetesVirtualDirectory kubernetesVirtualDirectory, String string, LanguageFileType languageFileType, int n, Object object) {
        if ((n & 2) != 0) {
            YAMLFileType yAMLFileType = YAMLFileType.YML;
            Intrinsics.checkNotNullExpressionValue((Object)yAMLFileType, (String)"YML");
            languageFileType = (LanguageFileType)yAMLFileType;
        }
        return kubernetesVirtualDirectory.touch(string, languageFileType);
    }

    private static final LightVirtualFileBase mkdir$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LightVirtualFileBase)$tmp0.invoke(p0);
    }

    private static final LightVirtualFileBase touch$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LightVirtualFileBase)$tmp0.invoke(p0);
    }
}

