/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.ide.actions.NonTrivialActionGroup;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.config.KubernetesProjectSettings;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareToggleAction;
import com.intellij.kubernetes.view.ui.actions.KubernetesSetCurrentContextAction;
import com.intellij.kubernetes.view.ui.actions.KubernetesSetCurrentContextAction$Group$updateChildren$;
import com.intellij.kubernetes.view.vfs.UtilsKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesSetCurrentContextAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesModelBasedDumbAwareToggleAction;", "currentContext", "Lcom/intellij/kubernetes/api/Context;", "(Lcom/intellij/kubernetes/api/Context;)V", "getApiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "", "state", "update", "Group", "intellij.clouds.kubernetes"})
public final class KubernetesSetCurrentContextAction
extends KubernetesModelBasedDumbAwareToggleAction {
    @NotNull
    private final Context currentContext;

    public KubernetesSetCurrentContextAction(@NotNull Context currentContext) {
        Intrinsics.checkNotNullParameter((Object)currentContext, (String)"currentContext");
        this.currentContext = currentContext;
    }

    @Override
    @Nullable
    protected KubernetesApiModel getApiModel(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        Intrinsics.checkNotNull((Object)project2);
        return KubernetesApiProvider.Companion.getInstance(project2).findModel$intellij_clouds_kubernetes(this.currentContext);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Supplier<String> supplier;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        String currentContextName = this.currentContext.getName();
        if (Toggleable.isSelected((Presentation)presentation2)) {
            var6_4 = new Object[]{currentContextName};
            supplier = KubernetesBundle.messagePointer("action.Kubernetes.SetCurrentContext.selected.text", var6_4);
        } else {
            var6_4 = new Object[]{currentContextName};
            supplier = KubernetesBundle.messagePointer("action.Kubernetes.SetCurrentContext.not.selected.text", var6_4);
        }
        Supplier<String> supplier2 = supplier;
        Intrinsics.checkNotNull(supplier2);
        Supplier<String> text = supplier2;
        presentation2.setText(text);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesApiModel kubernetesApiModel = this.getApiModel(e);
        Intrinsics.checkNotNull((Object)kubernetesApiModel);
        KubernetesApiProvider $this$isSelected_u24lambda_u240 = kubernetesApiModel.getApiProvider$intellij_clouds_kubernetes();
        boolean bl = false;
        return Intrinsics.areEqual((Object)$this$isSelected_u24lambda_u240.getContext(KubernetesProjectSettings.Companion.getInstance($this$isSelected_u24lambda_u240.getProject$intellij_clouds_kubernetes())), (Object)this.currentContext);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        EventId1<String> eventId1 = KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT();
        Project project2 = e.getProject();
        Intrinsics.checkNotNull((Object)project2);
        eventId1.log(project2, (Object)"change-context");
        Context contextToSet = state ? this.currentContext : null;
        KubernetesApiModel kubernetesApiModel = this.getApiModel(e);
        Intrinsics.checkNotNull((Object)kubernetesApiModel);
        KubernetesApiModel apiModel2 = kubernetesApiModel;
        KubernetesApiProvider $this$setSelected_u24lambda_u241 = apiModel2.getApiProvider$intellij_clouds_kubernetes();
        boolean bl = false;
        $this$setSelected_u24lambda_u241.setContext(KubernetesProjectSettings.Companion.getInstance($this$setSelected_u24lambda_u241.getProject$intellij_clouds_kubernetes()), contextToSet);
    }

    public static final /* synthetic */ Context access$getCurrentContext$p(KubernetesSetCurrentContextAction $this) {
        return $this.currentContext;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesSetCurrentContextAction$Group;", "Lcom/intellij/ide/actions/NonTrivialActionGroup;", "()V", "disable", "", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateChildren", "contexts", "Ljava/util/SortedSet;", "Lcom/intellij/kubernetes/api/Context;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesSetCurrentContextAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSetCurrentContextAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesSetCurrentContextAction$Group\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 actionUtils.kt\ncom/intellij/kubernetes/view/ui/actions/ActionUtilsKt\n*L\n1#1,96:1\n473#2:97\n1549#3:98\n1620#3,3:99\n59#4:102\n25#5:103\n*S KotlinDebug\n*F\n+ 1 KubernetesSetCurrentContextAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesSetCurrentContextAction$Group\n*L\n65#1:97\n72#1:98\n72#1:99,3\n79#1:102\n80#1:103\n*E\n"})
    public static final class Group
    extends NonTrivialActionGroup {
        /*
         * WARNING - void declaration
         */
        private final synchronized void updateChildren(SortedSet<Context> contexts2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AnAction[] anActionArray = this.getChildActionsOrStubs();
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildActionsOrStubs(...)");
            Object $this$filterIsInstance$iv = ArraysKt.asSequence((Object[])anActionArray);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Group$updateChildren$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            SortedSet actionContexts2 = SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)sequence2, (Function1)updateChildren.actionContexts.1.INSTANCE));
            if (Intrinsics.areEqual((Object)actionContexts2, contexts2)) {
                return;
            }
            this.removeAll();
            $this$filterIsInstance$iv = contexts2;
            Group group2 = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Context context = (Context)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(new KubernetesSetCurrentContextAction((Context)it));
            }
            group2.addAll((List)destination$iv$iv);
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            Presentation presentation2 = presentation;
            Project project2 = e.getProject();
            if (project2 == null) {
                this.disable(presentation2);
                return;
            }
            Project project3 = project2;
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project3;
            boolean $i$f$serviceIfCreated = false;
            KubernetesApiProvider kubernetesApiProvider = (KubernetesApiProvider)((Object)$this$serviceIfCreated$iv.getServiceIfCreated(KubernetesApiProvider.class));
            if (kubernetesApiProvider == null) {
                this.disable(presentation2);
                return;
            }
            KubernetesApiProvider apiProvider = kubernetesApiProvider;
            AnActionEvent $this$virtualFile$iv = e;
            boolean $i$f$getVirtualFile = false;
            VirtualFile virtualFile = (VirtualFile)$this$virtualFile$iv.getData(CommonDataKeys.VIRTUAL_FILE);
            if (virtualFile == null) {
                this.disable(presentation2);
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            presentation2.setEnabledAndVisible(UtilsKt.isKubernetesFile(virtualFile2, project3));
            if (!presentation2.isVisible()) {
                return;
            }
            this.updateChildren(CollectionsKt.toSortedSet((Iterable)apiProvider.getExistingContexts()));
            super.update(e);
        }

        private final void disable(Presentation presentation) {
            presentation.setEnabledAndVisible(false);
        }
    }
}

