/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesClusterConnectionManager;
import com.intellij.kubernetes.api.KubernetesClusterConnectionManagerKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.ui.actions.KubernetesConnectClusterDumpAwareActionKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareActionKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.AnimatedIcon;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesConnectClusterDumpAwareAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getApiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "update", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesConnectClusterDumpAwareAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesConnectClusterDumpAwareAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesConnectClusterDumpAwareAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,73:1\n13#2:74\n*S KotlinDebug\n*F\n+ 1 KubernetesConnectClusterDumpAwareAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesConnectClusterDumpAwareAction\n*L\n49#1:74\n*E\n"})
public final class KubernetesConnectClusterDumpAwareAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final KubernetesApiModel getApiModel(AnActionEvent e) {
        return KubernetesModelBasedDumbAwareActionKt.getApiModel(e);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = this.getApiModel(e);
        if (object == null || (object = object.getClusterStatus$intellij_clouds_kubernetes()) == null || (object = (KubernetesApiModel.ClusterStatus)object.getValue()) == null) {
            return;
        }
        Object status = object;
        Object object2 = status;
        if (Intrinsics.areEqual(object2, (Object)KubernetesApiModel.Connected.INSTANCE)) {
            e.getPresentation().setIcon(AllIcons.Actions.Suspend);
            e.getPresentation().setText(KubernetesBundle.message("action.disconnect.text", new Object[0]));
        } else if (Intrinsics.areEqual(object2, (Object)KubernetesApiModel.FailedToConnect.INSTANCE)) {
            e.getPresentation().setIcon(AllIcons.Actions.Execute);
        } else if (Intrinsics.areEqual(object2, (Object)KubernetesApiModel.NotConnected.INSTANCE)) {
            e.getPresentation().setIcon(AllIcons.Actions.Execute);
        } else if (object2 instanceof KubernetesApiModel.Connecting) {
            e.getPresentation().setIcon((Icon)AnimatedIcon.Default.INSTANCE);
            e.getPresentation().setText(KubernetesBundle.message("action.connecting.text", new Object[0]));
        }
        super.update(e);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesApiModel kubernetesApiModel = KubernetesModelBasedDumbAwareActionKt.getApiModel(e);
        if (kubernetesApiModel == null) {
            return;
        }
        KubernetesApiModel apiModel2 = kubernetesApiModel;
        if (apiModel2.isConnected() && apiModel2.getProxy$intellij_clouds_kubernetes().getProxyIsRunning()) {
            KubernetesClusterConnectionManagerKt.disconnectCluster(apiModel2, KubernetesApiModel.NotConnected.INSTANCE);
        } else if (apiModel2.isConnected() && !apiModel2.getProxy$intellij_clouds_kubernetes().getProxyIsRunning()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(KubernetesClusterConnectionManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("When cluster connected proxy have to be running");
        } else {
            if (apiModel2.getClusterStatus$intellij_clouds_kubernetes().getValue() instanceof KubernetesApiModel.Connecting) {
                return;
            }
            BuildersKt.launch$default((CoroutineScope)apiModel2.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(apiModel2, null){
                int label;
                final /* synthetic */ KubernetesApiModel $apiModel;
                {
                    this.$apiModel = $apiModel;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = KubernetesClusterConnectionManager.INSTANCE.tryConnectToCluster(this.$apiModel, (Continuation<? super Unit>)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if (this.$apiModel.isConnected()) {
                                KubernetesConnectClusterDumpAwareActionKt.saveClusterConnectionToSetting(this.$apiModel);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }
}

