/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import com.intellij.icons.AllIcons;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.ui.KubernetesRowBasedTableCellRenderer;
import com.intellij.kubernetes.view.ui.KubernetesTable;
import com.intellij.kubernetes.view.ui.KubernetesTableBasedPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import io.kubernetes.client.common.KubernetesObject;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u000fB-\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\t0\b\u00a2\u0006\u0002\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/view/ui/KubernetesResourceInformationPanel;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "Lcom/intellij/kubernetes/view/ui/KubernetesTableBasedPanel;", "resource", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "columnDescriptors", "", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "(Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/openapi/Disposable;Ljava/util/List;)V", "placeName", "", "getPlaceName", "()Ljava/lang/String;", "CopyValueAction", "intellij.clouds.kubernetes"})
public final class KubernetesResourceInformationPanel<T extends KubernetesObject>
extends KubernetesTableBasedPanel {
    @NotNull
    private final String placeName;

    public KubernetesResourceInformationPanel(@NotNull T resource, @NotNull Disposable parentDisposable, @NotNull List<? extends KubernetesResourceMapper.ColumnDescriptor<T, ?>> columnDescriptors) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(columnDescriptors, (String)"columnDescriptors");
        super(parentDisposable);
        String string = resource.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKind(...)");
        this.placeName = string;
        DefaultTableModel tableModel2 = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        tableModel2.addColumn(KubernetesBundle.message("KubernetesResourceInformationPanel.nameColumn.name", new Object[0]));
        tableModel2.addColumn(KubernetesBundle.message("KubernetesResourceInformationPanel.valueColumn.name", new Object[0]));
        for (KubernetesResourceMapper.ColumnDescriptor<T, ?> columnDescriptor : columnDescriptors) {
            Object[] objectArray = new Object[]{columnDescriptor.getName(), columnDescriptor.valueOf(resource)};
            Object[] rowData = objectArray;
            tableModel2.addRow(rowData);
        }
        KubernetesTable table = new KubernetesTable(tableModel2);
        table.getColumnModel().getColumn(1).setCellRenderer(new KubernetesRowBasedTableCellRenderer(columnDescriptors));
        AnAction[] anActionArray = new AnAction[]{new CopyValueAction(table)};
        this.addTable(table, (ActionGroup)new DefaultActionGroup(anActionArray));
    }

    @Override
    @NotNull
    protected String getPlaceName() {
        return this.placeName;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/view/ui/KubernetesResourceInformationPanel$CopyValueAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "table", "Lcom/intellij/kubernetes/view/ui/KubernetesTable;", "(Lcom/intellij/kubernetes/view/ui/KubernetesTable;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesResourceInformationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesResourceInformationPanel.kt\ncom/intellij/kubernetes/view/ui/KubernetesResourceInformationPanel$CopyValueAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
    private static final class CopyValueAction
    extends DumbAwareAction {
        @NotNull
        private final KubernetesTable table;

        public CopyValueAction(@NotNull KubernetesTable table) {
            Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
            super(KubernetesBundle.message("KubernetesResourceInformationPanel.CopyValueAction.text", new Object[0]), KubernetesBundle.message("KubernetesResourceInformationPanel.CopyValueAction.description", new Object[0]), AllIcons.Actions.Copy);
            this.table = table;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(this.table.getSelectedRow() >= 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Integer n = this.table.getSelectedRow();
                int it = ((Number)n).intValue();
                boolean bl = false;
                Object object = it >= 0 ? n : null;
                if (object == null) break block1;
                int it2 = ((Number)object).intValue();
                boolean bl2 = false;
                Object object2 = this.table.getValueAt(it2, 1);
                object = object2;
                if (object2 != null && (object = object.toString()) != null) {
                    Object it3 = object;
                    boolean bl3 = false;
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection((String)it3));
                }
            }
        }
    }
}

