/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.ui.KubernetesConsoleViewPanel;
import com.intellij.kubernetes.view.ui.KubernetesResourceInformationPanel;
import com.intellij.kubernetes.view.ui.KubernetesUIUtilitiesKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import io.kubernetes.client.common.KubernetesObject;
import java.awt.Container;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B9\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ>\u0010\u001b\u001a\u00020\u001c\"\b\b\u0001\u0010\u0001*\u00020\u001d2\u0006\u0010\u001e\u001a\u0002H\u00012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00010 2\u000f\b\u0002\u0010!\u001a\t\u0018\u00010\"\u00a2\u0006\u0002\b#H\u0005\u00a2\u0006\u0002\u0010$J!\u0010%\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u000f\b\u0002\u0010!\u001a\t\u0018\u00010\"\u00a2\u0006\u0002\b#H\u0004J\b\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/kubernetes/view/ui/KubernetesResourceContent;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "Lcom/intellij/openapi/Disposable;", "resource", "parentDisposable", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "toolbarActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "(Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/openapi/Disposable;Lcom/intellij/kubernetes/api/KubernetesApiModel;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModel;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "manager", "Lcom/intellij/ui/content/ContentManager;", "getManager", "()Lcom/intellij/ui/content/ContentManager;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addConsoleTab", "Lcom/intellij/ui/content/Content;", "", "key", "panel", "Lcom/intellij/kubernetes/view/ui/KubernetesConsoleViewPanel;", "displayName", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "(Ljava/lang/Object;Lcom/intellij/kubernetes/view/ui/KubernetesConsoleViewPanel;Ljava/lang/String;)Lcom/intellij/ui/content/Content;", "addTab", "dispose", "", "intellij.clouds.kubernetes"})
public class KubernetesResourceContent<T extends KubernetesObject>
implements Disposable {
    @NotNull
    private final KubernetesApiModel apiModel;
    @Nullable
    private final ActionGroup toolbarActionGroup;
    @NotNull
    private final ContentManager manager;

    public KubernetesResourceContent(@NotNull T resource, @NotNull Disposable parentDisposable, @NotNull KubernetesApiModel apiModel2, @NotNull KubernetesResourceMapper<T, ?> mapper, @Nullable ActionGroup toolbarActionGroup) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        this.apiModel = apiModel2;
        this.toolbarActionGroup = toolbarActionGroup;
        ContentUI contentUI = ServiceViewUIUtils.getServicesAlignedTabbedPaneContentUI();
        Project project2 = this.getProject();
        this.manager = (ContentManager)new ContentManagerImpl(contentUI, project2){
            {
                this.addDataProvider(KubernetesUIUtilitiesKt.k8sHelpDataProvider());
            }

            @NotNull
            public List<AnAction> getAdditionalPopupActions(@NotNull Content content2) {
                Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                List list2 = super.getAdditionalPopupActions(content2);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAdditionalPopupActions(...)");
                return CollectionsKt.plus((Collection)list2, (Object)ActionManager.getInstance().getAction("Kubernetes.StopPortForwarding"));
            }
        };
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        KubernetesResourceInformationPanel<T> panel2 = new KubernetesResourceInformationPanel<T>(resource, this, mapper.getColumnDescriptors(this.apiModel));
        Content content2 = this.addTab(panel2, KubernetesBundle.message("KubernetesResourceContent.informationContent.displayName", new Object[0]));
        content2.getDisplayName();
        content2.setCloseable(false);
    }

    @NotNull
    protected final KubernetesApiModel getApiModel() {
        return this.apiModel;
    }

    @NotNull
    protected final Project getProject() {
        return this.apiModel.getProject();
    }

    @NotNull
    protected final ContentManager getManager() {
        return this.manager;
    }

    @NotNull
    public final JComponent getComponent() {
        JComponent jComponent = this.manager.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    public void dispose() {
    }

    @NotNull
    protected final Content addTab(@NotNull JComponent component2, @Nullable String displayName) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Content content2 = this.manager.getFactory().createContent(component2, displayName, true);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content content3 = content2;
        if (this.toolbarActionGroup != null) {
            content3.setActions(this.toolbarActionGroup, "ServicesToolbar", component2);
        }
        this.manager.addContent(content3);
        Container container = component2.getParent();
        JComponent jComponent = container instanceof JComponent ? (JComponent)container : null;
        if (jComponent != null) {
            jComponent.setBorder((Border)JBUI.Borders.empty());
        }
        return content3;
    }

    public static /* synthetic */ Content addTab$default(KubernetesResourceContent kubernetesResourceContent, JComponent jComponent, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addTab");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return kubernetesResourceContent.addTab(jComponent, string);
    }

    @RequiresEdt
    @NotNull
    protected final <T> Content addConsoleTab(@NotNull T key2, @NotNull KubernetesConsoleViewPanel<T> panel2, @Nullable String displayName) {
        Content content2;
        Object object;
        block4: {
            Intrinsics.checkNotNullParameter(key2, (String)"key");
            Intrinsics.checkNotNullParameter(panel2, (String)"panel");
            Content[] contentArray = this.manager.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            for (Object object2 : (Object[])contentArray) {
                Content it = (Content)object2;
                boolean bl = false;
                KubernetesConsoleViewPanel kubernetesConsoleViewPanel = (KubernetesConsoleViewPanel)KClasses.safeCast((KClass)Reflection.getOrCreateKotlinClass(panel2.getClass()), (Object)it.getComponent());
                boolean bl2 = kubernetesConsoleViewPanel != null ? kubernetesConsoleViewPanel.supports(key2) : false;
                if (!bl2) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        Content existingContent = (Content)object;
        if (existingContent != null) {
            JComponent jComponent = existingContent.getComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.kubernetes.view.ui.KubernetesConsoleViewPanel<*>");
            Disposer.dispose((Disposable)((Disposable)((KubernetesConsoleViewPanel)jComponent)));
        }
        if ((content2 = existingContent) == null) {
            content2 = this.addTab(panel2, displayName);
        }
        Content content3 = content2;
        content3.setComponent((JComponent)panel2);
        if (this.toolbarActionGroup != null) {
            content3.setActions(this.toolbarActionGroup, "ServicesToolbar", this.getComponent());
        }
        this.manager.setSelectedContent(content3, true);
        return content3;
    }

    public static /* synthetic */ Content addConsoleTab$default(KubernetesResourceContent kubernetesResourceContent, Object object, KubernetesConsoleViewPanel kubernetesConsoleViewPanel, String string, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addConsoleTab");
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return kubernetesResourceContent.addConsoleTab(object, kubernetesConsoleViewPanel, string);
    }
}

