/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.execution.KubernetesPodPortForwardingService;
import com.intellij.kubernetes.view.execution.PortForwarding;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.ui.KubernetesPodConsolePanel;
import com.intellij.kubernetes.view.ui.KubernetesPodForwardingPortsPanel;
import com.intellij.kubernetes.view.ui.KubernetesPodLogPanel;
import com.intellij.kubernetes.view.ui.KubernetesPodShellPanel;
import com.intellij.kubernetes.view.ui.KubernetesResourceContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.ui.content.Content;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B9\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/kubernetes/view/ui/KubernetesPodContent;", "Lcom/intellij/kubernetes/view/ui/KubernetesResourceContent;", "Lio/kubernetes/client/openapi/models/V1Pod;", "pod", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "toolbarActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "(Lio/kubernetes/client/openapi/models/V1Pod;Lcom/intellij/kubernetes/api/KubernetesApiModel;Lcom/intellij/openapi/Disposable;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "createConsolePanel", "Lcom/intellij/kubernetes/view/ui/KubernetesPodConsolePanel;", "container", "Lio/kubernetes/client/openapi/models/V1Container;", "createLogPanel", "Lcom/intellij/kubernetes/view/ui/KubernetesPodLogPanel;", "createPortsPanel", "Lcom/intellij/kubernetes/view/ui/KubernetesPodForwardingPortsPanel;", "portForwarding", "Lcom/intellij/kubernetes/view/execution/PortForwarding;", "createShellPanel", "Lcom/intellij/kubernetes/view/ui/KubernetesPodShellPanel;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesPodContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPodContent.kt\ncom/intellij/kubernetes/view/ui/KubernetesPodContent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1549#2:82\n1620#2,3:83\n1855#2,2:86\n*S KotlinDebug\n*F\n+ 1 KubernetesPodContent.kt\ncom/intellij/kubernetes/view/ui/KubernetesPodContent\n*L\n26#1:82\n26#1:83,3\n27#1:86,2\n*E\n"})
public final class KubernetesPodContent
extends KubernetesResourceContent<V1Pod> {
    /*
     * WARNING - void declaration
     */
    public KubernetesPodContent(@NotNull V1Pod pod, @NotNull KubernetesApiModel apiModel2, @NotNull Disposable parentDisposable, @NotNull KubernetesResourceMapper<V1Pod, ?> mapper, @Nullable ActionGroup toolbarActionGroup) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)pod, (String)"pod");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        super((KubernetesObject)pod, parentDisposable, apiModel2, mapper, toolbarActionGroup);
        KubernetesPodPortForwardingService portForwardingService = KubernetesPodPortForwardingService.Companion.getInstance();
        Iterable iterable = portForwardingService.listPortForwardings(pod);
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PortForwarding portForwarding = (PortForwarding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createPortsPanel(pod, (PortForwarding)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KubernetesPodForwardingPortsPanel it = (KubernetesPodForwardingPortsPanel)element$iv;
            boolean bl = false;
            KubernetesPodPortForwardingService.getOrCreate$default(portForwardingService, apiModel2, it, false, 4, null);
        }
    }

    @RequiresEdt
    @NotNull
    public final KubernetesPodLogPanel createLogPanel(@NotNull V1Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        KubernetesPodLogPanel panel2 = new KubernetesPodLogPanel(container, this, this.getProject());
        Object[] objectArray = new Object[]{container.getName()};
        this.addConsoleTab(container, panel2, KubernetesBundle.message("KubernetesPodContent.log.title", objectArray));
        return panel2;
    }

    @RequiresEdt
    @NotNull
    public final KubernetesPodConsolePanel createConsolePanel(@NotNull V1Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        KubernetesPodConsolePanel panel2 = new KubernetesPodConsolePanel(container, this, this.getProject());
        Object[] objectArray = new Object[]{container.getName()};
        this.addConsoleTab(container, panel2, KubernetesBundle.message("KubernetesPodContent.console.title", objectArray));
        return panel2;
    }

    @RequiresEdt
    @NotNull
    public final KubernetesPodShellPanel createShellPanel(@NotNull V1Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        KubernetesPodShellPanel panel2 = new KubernetesPodShellPanel(container, this, this.getProject());
        Object[] objectArray = new Object[]{container.getName()};
        this.addConsoleTab(container, panel2, KubernetesBundle.message("KubernetesPodContent.shell.title", objectArray));
        return panel2;
    }

    @RequiresEdt
    @NotNull
    public final KubernetesPodForwardingPortsPanel createPortsPanel(@NotNull V1Pod pod, @NotNull PortForwarding portForwarding) {
        Intrinsics.checkNotNullParameter((Object)pod, (String)"pod");
        Intrinsics.checkNotNullParameter((Object)portForwarding, (String)"portForwarding");
        KubernetesPodForwardingPortsPanel panel2 = new KubernetesPodForwardingPortsPanel(pod, portForwarding, this, this.getProject());
        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)portForwarding.getAddresses(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null), CollectionsKt.joinToString$default((Iterable)portForwarding.getMappings(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)};
        Content content2 = this.addConsoleTab(portForwarding, panel2, KubernetesBundle.message("KubernetesPodContent.ports.title", objectArray));
        content2.setCloseable(false);
        return panel2;
    }
}

