/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.mappers;

import com.intellij.ide.util.treeView.FileNameComparator;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.navigation.KubernetesResourceNavigationData;
import com.intellij.kubernetes.view.ui.DateTimeUtilitiesKt;
import com.intellij.kubernetes.view.ui.KubernetesTableCellRenderer;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.StatusText;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.custom.Quantity;
import java.time.OffsetDateTime;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 I*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005:\u0002HIB\u0019\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ9\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u00182\u001f\u0010\u001a\u001a\u001b\u0012\u0004\u0012\u00028\u0000\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00190\u001b\u00a2\u0006\u0002\b\u001cH\u0004J\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001e0\u0018H\u0004J;\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\u00182%\u0010 \u001a!\u0012\u0004\u0012\u00028\u0000\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\"\u0018\u00010!0\u001b\u00a2\u0006\u0002\b\u001cH\u0004J\u0018\u0010#\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0018H\u0004JL\u0010$\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0018\"\u0004\b\u0002\u0010%2\u000b\u0010&\u001a\u00070\n\u00a2\u0006\u0002\b'2\u001f\u0010(\u001a\u001b\u0012\u0004\u0012\u00028\u0000\u0012\f\u0012\n\u0012\u0004\u0012\u0002H%\u0018\u00010\u00190\u001b\u00a2\u0006\u0002\b\u001cH\u0004J\u0014\u0010)\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\u0018H\u0004J/\u0010*\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\u00182\u0019\u0010+\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001b\u00a2\u0006\u0002\b\u001cH\u0004J/\u0010,\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\u00182\u0019\u0010-\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001b\u00a2\u0006\u0002\b\u001cH\u0004J/\u0010.\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\u00182\u0019\u0010/\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001b\u00a2\u0006\u0002\b\u001cH\u0004Jd\u00100\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001e0\u00182\u000b\u0010&\u001a\u00070\n\u00a2\u0006\u0002\b'2&\u00101\u001a\"\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b2\u0012\b\b&\u0012\u0004\b\b(3\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b'0\u001b2\u0019\u00104\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001b\u00a2\u0006\u0002\b\u001cH\u0004J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J \u0010;\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u00180<2\u0006\u00107\u001a\u000208H&J\u001a\u0010=\u001a\u00070\n\u00a2\u0006\u0002\b'2\u0006\u0010>\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0016J+\u0010C\u001a\u00020@2\u0006\u0010>\u001a\u00028\u00002\u0006\u0010A\u001a\u00020B2\f\u0010D\u001a\b\u0012\u0004\u0012\u0002080EH\u0016\u00a2\u0006\u0002\u0010FJ\u001e\u0010G\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\f\u0010D\u001a\b\u0012\u0004\u0012\u0002080EH\u0016R\u0016\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0014\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b*\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006J"}, d2={"Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "L", "Lio/kubernetes/client/common/KubernetesListObject;", "", "entity", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "(Lcom/intellij/kubernetes/api/KubernetesEntity;)V", "directoryName", "", "Lorg/jetbrains/annotations/NonNls;", "getDirectoryName", "()Ljava/lang/String;", "getEntity$intellij_clouds_kubernetes", "()Lcom/intellij/kubernetes/api/KubernetesEntity;", "resourceClass", "Lkotlin/reflect/KClass;", "getResourceClass", "()Lkotlin/reflect/KClass;", "rootDirectoryName", "getRootDirectoryName", "(Lio/kubernetes/client/common/KubernetesObject;)Ljava/lang/String;", "addAccessModesField", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "", "getAccessModes", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "addAgeField", "Ljava/time/OffsetDateTime;", "addCapacityField", "getCapacity", "", "Lio/kubernetes/client/custom/Quantity;", "addLabelsField", "addMultilineField", "Aspect", "name", "Lorg/jetbrains/annotations/Nls;", "getValueFromResource", "addNameField", "addReasonField", "getReason", "addStatusField", "getStatus", "addStorageClassField", "getStorageClass", "addTimestampField", "getTooltipText", "Lkotlin/ParameterName;", "isoTimestamp", "getTimestamp", "customizeEmptyText", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "statusText", "Lcom/intellij/util/ui/StatusText;", "getColumnDescriptors", "", "getResourceDisplayableName", "resource", "isAccepted", "", "navigationData", "Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;", "isAcceptedFor", "getApiModel", "Lkotlin/Function0;", "(Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;Lkotlin/jvm/functions/Function0;)Z", "mayBeInList", "ColumnDescriptor", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesResourceMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesResourceMapper\n+ 2 KubernetesResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor$Companion\n*L\n1#1,185:1\n171#2,5:186\n171#2,5:191\n171#2,5:196\n171#2,5:201\n*S KotlinDebug\n*F\n+ 1 KubernetesResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesResourceMapper\n*L\n70#1:186,5\n73#1:191,5\n82#1:196,5\n85#1:201,5\n*E\n"})
public abstract class KubernetesResourceMapper<T extends KubernetesObject, L extends KubernetesListObject> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KubernetesEntity<T, L> entity;
    @NotNull
    private static final Map<KubernetesEntity<?, ?>, Function0<KubernetesResourceMapper<?, ?>>> mappersByEntity = new LinkedHashMap();

    public KubernetesResourceMapper(@NotNull KubernetesEntity<T, L> entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        this.entity = entity;
    }

    @NotNull
    public final KubernetesEntity<T, L> getEntity$intellij_clouds_kubernetes() {
        return this.entity;
    }

    @NotNull
    public abstract List<ColumnDescriptor<T, ?>> getColumnDescriptors(@NotNull KubernetesApiModel var1);

    public void customizeEmptyText(@NotNull KubernetesApiModel apiModel2, @NotNull StatusText statusText) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)statusText, (String)"statusText");
    }

    @NotNull
    public final KClass<T> getResourceClass() {
        return this.entity.getType();
    }

    @NotNull
    protected final ColumnDescriptor<T, String> addNameField() {
        String string = KubernetesBundle.message("KubernetesResourceMapper.nameField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new ColumnDescriptor(string, Reflection.getOrCreateKotlinClass(String.class), SortOrder.ASCENDING, FileNameComparator.getInstance(), null, null, null, addNameField.1.INSTANCE, 112, null);
    }

    @NotNull
    protected final ColumnDescriptor<T, OffsetDateTime> addAgeField() {
        String string = KubernetesBundle.message("KubernetesResourceMapper.ageField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.addTimestampField(string, (Function1<String, String>)((Function1)addAgeField.1.INSTANCE), addAgeField.2.INSTANCE);
    }

    @NotNull
    protected final ColumnDescriptor<T, Iterable<?>> addLabelsField() {
        String string = KubernetesBundle.message("KubernetesResourceMapper.labelsField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.addMultilineField(string, addLabelsField.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ColumnDescriptor<T, String> addStatusField(@NotNull Function1<? super T, String> getStatus) {
        void name$iv;
        Intrinsics.checkNotNullParameter(getStatus, (String)"getStatus");
        ColumnDescriptor.Companion companion = ColumnDescriptor.Companion;
        String string = KubernetesBundle.message("KubernetesResourceMapper.statusField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Function1 getValue$iv = new Function1<T, String>(getStatus){
            final /* synthetic */ Function1<T, String> $getStatus;
            {
                this.$getStatus = $getStatus;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull T $this$simple) {
                Intrinsics.checkNotNullParameter($this$simple, (String)"$this$simple");
                return (String)this.$getStatus.invoke($this$simple);
            }
        };
        boolean $i$f$simple = false;
        return new ColumnDescriptor((String)name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ColumnDescriptor<T, String> addCapacityField(@NotNull Function1<? super T, ? extends Map<String, ? extends Quantity>> getCapacity) {
        void name$iv;
        Intrinsics.checkNotNullParameter(getCapacity, (String)"getCapacity");
        ColumnDescriptor.Companion companion = ColumnDescriptor.Companion;
        String string = KubernetesBundle.message("KubernetesResourceMapper.capacityField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Function1 getValue$iv = new Function1<T, String>(getCapacity){
            final /* synthetic */ Function1<T, Map<String, Quantity>> $getCapacity;
            {
                this.$getCapacity = $getCapacity;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull T $this$simple) {
                Intrinsics.checkNotNullParameter($this$simple, (String)"$this$simple");
                Object object = (Map)this.$getCapacity.invoke($this$simple);
                return object != null && (object = (Quantity)object.get("storage")) != null ? ((Quantity)object).toSuffixedString() : null;
            }
        };
        boolean $i$f$simple = false;
        return new ColumnDescriptor((String)name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
    }

    @NotNull
    protected final ColumnDescriptor<T, Iterable<?>> addAccessModesField(@NotNull Function1<? super T, ? extends Iterable<String>> getAccessModes) {
        Intrinsics.checkNotNullParameter(getAccessModes, (String)"getAccessModes");
        String string = KubernetesBundle.message("KubernetesResourceMapper.accessModesField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.addMultilineField(string, (Function1)new Function1<T, Iterable<? extends String>>(getAccessModes){
            final /* synthetic */ Function1<T, Iterable<String>> $getAccessModes;
            {
                this.$getAccessModes = $getAccessModes;
                super(1);
            }

            @Nullable
            public final Iterable<String> invoke(@NotNull T $this$addMultilineField) {
                Intrinsics.checkNotNullParameter($this$addMultilineField, (String)"$this$addMultilineField");
                Iterable iterable = (Iterable)this.$getAccessModes.invoke($this$addMultilineField);
                return iterable != null ? CollectionsKt.sorted((Iterable)iterable) : null;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ColumnDescriptor<T, String> addStorageClassField(@NotNull Function1<? super T, String> getStorageClass) {
        void name$iv;
        Intrinsics.checkNotNullParameter(getStorageClass, (String)"getStorageClass");
        ColumnDescriptor.Companion companion = ColumnDescriptor.Companion;
        String string = KubernetesBundle.message("KubernetesResourceMapper.storageClassField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Function1 getValue$iv = new Function1<T, String>(getStorageClass){
            final /* synthetic */ Function1<T, String> $getStorageClass;
            {
                this.$getStorageClass = $getStorageClass;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull T $this$simple) {
                Intrinsics.checkNotNullParameter($this$simple, (String)"$this$simple");
                return (String)this.$getStorageClass.invoke($this$simple);
            }
        };
        boolean $i$f$simple = false;
        return new ColumnDescriptor((String)name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ColumnDescriptor<T, String> addReasonField(@NotNull Function1<? super T, String> getReason) {
        void name$iv;
        Intrinsics.checkNotNullParameter(getReason, (String)"getReason");
        ColumnDescriptor.Companion companion = ColumnDescriptor.Companion;
        String string = KubernetesBundle.message("KubernetesResourceMapper.reasonField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Function1 getValue$iv = new Function1<T, String>(getReason){
            final /* synthetic */ Function1<T, String> $getReason;
            {
                this.$getReason = $getReason;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull T $this$simple) {
                Intrinsics.checkNotNullParameter($this$simple, (String)"$this$simple");
                return (String)this.$getReason.invoke($this$simple);
            }
        };
        boolean $i$f$simple = false;
        return new ColumnDescriptor((String)name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
    }

    @NotNull
    protected final ColumnDescriptor<T, OffsetDateTime> addTimestampField(@NotNull String name2, @NotNull Function1<? super String, String> getTooltipText, @NotNull Function1<? super T, OffsetDateTime> getTimestamp) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(getTooltipText, (String)"getTooltipText");
        Intrinsics.checkNotNullParameter(getTimestamp, (String)"getTimestamp");
        return new ColumnDescriptor(name2, Reflection.getOrCreateKotlinClass(OffsetDateTime.class), null, null, new KubernetesTableCellRenderer(getTooltipText){
            final /* synthetic */ Function1<String, String> $getTooltipText;
            {
                this.$getTooltipText = $getTooltipText;
            }

            protected void setValue(@NotNull JBTextArea $this$setValue, @Nullable Object value2, int row) {
                Intrinsics.checkNotNullParameter((Object)$this$setValue, (String)"<this>");
                OffsetDateTime offsetDateTime = value2 instanceof OffsetDateTime ? (OffsetDateTime)value2 : null;
                if (offsetDateTime == null) {
                    return;
                }
                OffsetDateTime timestamp = offsetDateTime;
                $this$setValue.setText(DateTimeUtilitiesKt.formatAge$default(timestamp, null, 1, null));
                $this$setValue.setToolTipText((String)this.$getTooltipText.invoke((Object)DateTimeUtilitiesKt.formatISO(timestamp)));
            }
        }, null, null, getTimestamp, 108, null);
    }

    @NotNull
    protected final <Aspect> ColumnDescriptor<T, Iterable<?>> addMultilineField(@NotNull String name2, @NotNull Function1<? super T, ? extends Iterable<? extends Aspect>> getValueFromResource) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(getValueFromResource, (String)"getValueFromResource");
        KubernetesTableCellRenderer singleLineRenderer2 = new KubernetesTableCellRenderer(){

            protected void setValue(@NotNull JBTextArea $this$setValue, @Nullable Object value2, int row) {
                Iterable iterable;
                Intrinsics.checkNotNullParameter((Object)$this$setValue, (String)"<this>");
                Iterable iterable2 = iterable = value2 instanceof Iterable ? (Iterable)value2 : null;
                $this$setValue.setText(iterable2 != null ? CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)"", null, null, (int)1, null, null, (int)54, null) : null);
                Iterable iterable3 = iterable;
                $this$setValue.setToolTipText(iterable3 != null ? CollectionsKt.joinToString$default((Iterable)iterable3, (CharSequence)"<br>", null, null, (int)0, null, null, (int)62, null) : null);
            }
        };
        KubernetesTableCellRenderer multiLineRenderer2 = new KubernetesTableCellRenderer(){

            protected void setValue(@NotNull JBTextArea $this$setValue, @Nullable Object value2, int row) {
                Intrinsics.checkNotNullParameter((Object)$this$setValue, (String)"<this>");
                Iterable iterable = value2 instanceof Iterable ? (Iterable)value2 : null;
                $this$setValue.setText(iterable != null ? CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : null);
                $this$setValue.setToolTipText(null);
            }
        };
        return new ColumnDescriptor(name2, Reflection.getOrCreateKotlinClass(Iterable.class), null, null, singleLineRenderer2, multiLineRenderer2, null, getValueFromResource, 76, null);
    }

    @Nullable
    public String getRootDirectoryName(@NotNull T $this$rootDirectoryName) {
        Intrinsics.checkNotNullParameter($this$rootDirectoryName, (String)"<this>");
        return null;
    }

    @NotNull
    public final String getDirectoryName() {
        return this.entity.getResource();
    }

    @NotNull
    public String getResourceDisplayableName(@NotNull T resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Object[] objectArray = new Object[]{this.entity.getDisplayableKind(), resource.getMetadata().getName()};
        String string = KubernetesBundle.message("KubernetesResourceMapper.resourceDisplayableName.template", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAccepted(@NotNull KubernetesResourceNavigationData navigationData) {
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        return Intrinsics.areEqual((Object)navigationData.getKind(), (Object)this.entity.getKind());
    }

    public boolean mayBeInList(@NotNull KubernetesResourceNavigationData navigationData, @NotNull Function0<KubernetesApiModel> getApiModel) {
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        Intrinsics.checkNotNullParameter(getApiModel, (String)"getApiModel");
        return true;
    }

    public boolean isAcceptedFor(@NotNull T resource, @NotNull KubernetesResourceNavigationData navigationData, @NotNull Function0<KubernetesApiModel> getApiModel) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        Intrinsics.checkNotNullParameter(getApiModel, (String)"getApiModel");
        return Intrinsics.areEqual((Object)resource.getKind(), (Object)navigationData.getKind()) && Intrinsics.areEqual((Object)resource.getMetadata().getName(), (Object)navigationData.getName());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 (*\b\b\u0002\u0010\u0001*\u00020\u0002*\b\b\u0003\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005:\u0001(B\u0085\u0001\u0012\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00030\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u001c\b\u0002\u0010\r\u001a\u0016\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u000ej\n\u0012\u0004\u0012\u00028\u0003\u0018\u0001`\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\u0019\u0010\u0015\u001a\u0015\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0016\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0002\u0010\u0018J\f\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0016J\u0017\u0010%\u001a\u0004\u0018\u00018\u00032\u0006\u0010&\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010'R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0015\u001a\u0015\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R%\u0010\r\u001a\u0016\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u000ej\n\u0012\u0004\u0012\u00028\u0003\u0018\u0001`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006)"}, d2={"Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "Item", "Lio/kubernetes/client/common/KubernetesObject;", "Aspect", "", "Lcom/intellij/util/ui/ColumnInfo;", "name", "", "Lorg/jetbrains/annotations/Nls;", "columnClass", "Lkotlin/reflect/KClass;", "sortOrder", "Ljavax/swing/SortOrder;", "viewComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "singleLineRenderer", "Ljavax/swing/table/TableCellRenderer;", "multiLineRenderer", "singleLineColumnMaxWidth", "", "getValue", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Lkotlin/reflect/KClass;Ljavax/swing/SortOrder;Ljava/util/Comparator;Ljavax/swing/table/TableCellRenderer;Ljavax/swing/table/TableCellRenderer;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "getMultiLineRenderer", "()Ljavax/swing/table/TableCellRenderer;", "getSingleLineColumnMaxWidth", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getSingleLineRenderer", "getSortOrder", "()Ljavax/swing/SortOrder;", "getViewComparator", "()Ljava/util/Comparator;", "getColumnClass", "Ljava/lang/Class;", "valueOf", "item", "(Lio/kubernetes/client/common/KubernetesObject;)Ljava/lang/Object;", "Companion", "intellij.clouds.kubernetes"})
    public static final class ColumnDescriptor<Item extends KubernetesObject, Aspect>
    extends ColumnInfo<Item, Aspect> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final KClass<Aspect> columnClass;
        @Nullable
        private final SortOrder sortOrder;
        @Nullable
        private final Comparator<Aspect> viewComparator;
        @NotNull
        private final TableCellRenderer singleLineRenderer;
        @NotNull
        private final TableCellRenderer multiLineRenderer;
        @Nullable
        private final Integer singleLineColumnMaxWidth;
        @NotNull
        private final Function1<Item, Aspect> getValue;

        public ColumnDescriptor(@NotNull String name2, @NotNull KClass<Aspect> columnClass, @Nullable SortOrder sortOrder, @Nullable Comparator<Aspect> viewComparator, @NotNull TableCellRenderer singleLineRenderer2, @NotNull TableCellRenderer multiLineRenderer2, @Nullable Integer singleLineColumnMaxWidth, @NotNull Function1<? super Item, ? extends Aspect> getValue2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(columnClass, (String)"columnClass");
            Intrinsics.checkNotNullParameter((Object)singleLineRenderer2, (String)"singleLineRenderer");
            Intrinsics.checkNotNullParameter((Object)multiLineRenderer2, (String)"multiLineRenderer");
            Intrinsics.checkNotNullParameter(getValue2, (String)"getValue");
            super(name2);
            this.columnClass = columnClass;
            this.sortOrder = sortOrder;
            this.viewComparator = viewComparator;
            this.singleLineRenderer = singleLineRenderer2;
            this.multiLineRenderer = multiLineRenderer2;
            this.singleLineColumnMaxWidth = singleLineColumnMaxWidth;
            this.getValue = getValue2;
        }

        public /* synthetic */ ColumnDescriptor(String string, KClass kClass, SortOrder sortOrder, Comparator comparator2, TableCellRenderer tableCellRenderer, TableCellRenderer tableCellRenderer2, Integer n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                sortOrder = null;
            }
            if ((n2 & 8) != 0) {
                comparator2 = null;
            }
            if ((n2 & 0x10) != 0) {
                tableCellRenderer = new KubernetesTableCellRenderer();
            }
            if ((n2 & 0x20) != 0) {
                tableCellRenderer2 = tableCellRenderer;
            }
            if ((n2 & 0x40) != 0) {
                n = null;
            }
            this(string, kClass, sortOrder, comparator2, tableCellRenderer, tableCellRenderer2, n, function1);
        }

        @Nullable
        public final SortOrder getSortOrder() {
            return this.sortOrder;
        }

        @Nullable
        public final Comparator<Aspect> getViewComparator() {
            return this.viewComparator;
        }

        @NotNull
        public final TableCellRenderer getSingleLineRenderer() {
            return this.singleLineRenderer;
        }

        @NotNull
        public final TableCellRenderer getMultiLineRenderer() {
            return this.multiLineRenderer;
        }

        @Nullable
        public final Integer getSingleLineColumnMaxWidth() {
            return this.singleLineColumnMaxWidth;
        }

        @Nullable
        public Aspect valueOf(@NotNull Item item) {
            Intrinsics.checkNotNullParameter(item, (String)"item");
            return (Aspect)this.getValue.invoke(item);
        }

        @NotNull
        public Class<?> getColumnClass() {
            return JvmClassMappingKt.getJavaClass(this.columnClass);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JX\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\b\b\u0004\u0010\u0005*\u00020\u0007\"\n\b\u0005\u0010\u0006\u0018\u0001*\u00020\u00012\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u001b\b\b\u0010\u000b\u001a\u0015\u0012\u0004\u0012\u0002H\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\u00060\f\u00a2\u0006\u0002\b\rH\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor$Companion;", "", "()V", "simple", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "Item", "Aspect", "Lio/kubernetes/client/common/KubernetesObject;", "name", "", "Lorg/jetbrains/annotations/Nls;", "getValue", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "intellij.clouds.kubernetes"})
        public static final class Companion {
            private Companion() {
            }

            public final /* synthetic */ <Item extends KubernetesObject, Aspect> ColumnDescriptor<Item, Aspect> simple(String name2, Function1<? super Item, ? extends Aspect> getValue2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter(getValue2, (String)"getValue");
                boolean $i$f$simple = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"Aspect");
                return new ColumnDescriptor(name2, Reflection.getOrCreateKotlinClass(Object.class), null, null, null, null, null, getValue2, 124, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\b\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00072\u001a\u0010\t\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u000b0\nJH\u0010\f\u001a\u00020\r\"\b\b\u0002\u0010\u000e*\u00020\u000f\"\b\b\u0003\u0010\u0010*\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u00100\u00052\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u00100\u00070\u0006R0\u0010\u0003\u001a$\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$Companion;", "", "()V", "mappersByEntity", "", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "Lkotlin/Function0;", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "find", "predicate", "Lkotlin/Function1;", "", "registerMapper", "", "T", "Lio/kubernetes/client/common/KubernetesObject;", "L", "Lio/kubernetes/client/common/KubernetesListObject;", "entity", "lazyMapper", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesResourceMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1#2:186\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KubernetesResourceMapper<?, ?> find(@NotNull Function1<? super KubernetesEntity<?, ?>, Boolean> predicate2) {
            Function0 function0;
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
                Iterable iterable = mappersByEntity.entrySet();
                for (Object t : iterable) {
                    Map.Entry it = (Map.Entry)t;
                    boolean bl = false;
                    if (!((Boolean)predicate2.invoke(it.getKey())).booleanValue()) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            return entry != null && (function0 = (Function0)entry.getValue()) != null ? (KubernetesResourceMapper)function0.invoke() : null;
        }

        public final <T extends KubernetesObject, L extends KubernetesListObject> void registerMapper(@NotNull KubernetesEntity<T, L> entity, @NotNull Function0<? extends KubernetesResourceMapper<T, L>> lazyMapper) {
            Intrinsics.checkNotNullParameter(entity, (String)"entity");
            Intrinsics.checkNotNullParameter(lazyMapper, (String)"lazyMapper");
            mappersByEntity.put(entity, lazyMapper);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

