/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view;

import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.view.KubernetesServiceViewDescriptor;
import com.intellij.kubernetes.view.inEditor.KubernetesContentInEditorKt;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.ui.KubernetesResourceContent;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeleteResourceProvider;
import com.intellij.kubernetes.view.ui.actions.KubernetesResourceActionBaseKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesViewYAMLAction;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0010\b\u0001\u0010\u0003 \u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B;\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0014J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\u0018\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#H\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/kubernetes/view/KubernetesResourceServiceViewDescriptorBase;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "C", "Lcom/intellij/kubernetes/view/ui/KubernetesResourceContent;", "Lcom/intellij/kubernetes/view/KubernetesServiceViewDescriptor;", "resource", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "parentCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "icon", "Ljavax/swing/Icon;", "(Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/kubernetes/api/KubernetesApiModel;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;Ljavax/swing/Icon;)V", "createAdditionalCustomActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "createCustomActions", "getContentComponent", "Ljavax/swing/JComponent;", "getDataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "getId", "", "getRemover", "Ljava/lang/Runnable;", "handleDoubleClick", "", "event", "Ljava/awt/event/MouseEvent;", "isContentPartVisible", "onNodeSelected", "", "selectedServices", "", "", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesResourceServiceViewDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesResourceServiceViewDescriptor.kt\ncom/intellij/kubernetes/view/KubernetesResourceServiceViewDescriptorBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public abstract class KubernetesResourceServiceViewDescriptorBase<T extends KubernetesObject, C extends KubernetesResourceContent<T>>
extends KubernetesServiceViewDescriptor<T, C> {
    public KubernetesResourceServiceViewDescriptorBase(@NotNull T resource, @NotNull KubernetesApiModel apiModel2, @NotNull CoroutineScope parentCoroutineScope, @NotNull KubernetesResourceMapper<T, ?> mapper, @Nullable Icon icon) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentCoroutineScope, (String)"parentCoroutineScope");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        String string = resource.getMetadata().getName();
        Intrinsics.checkNotNull((Object)string);
        super(string, icon, apiModel2, parentCoroutineScope, resource, mapper);
    }

    public /* synthetic */ KubernetesResourceServiceViewDescriptorBase(KubernetesObject kubernetesObject, KubernetesApiModel kubernetesApiModel, CoroutineScope coroutineScope, KubernetesResourceMapper kubernetesResourceMapper, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            icon = null;
        }
        this(kubernetesObject, kubernetesApiModel, coroutineScope, kubernetesResourceMapper, icon);
    }

    @Override
    @NotNull
    protected DefaultActionGroup createCustomActions() {
        AnAction[] anActionArray = new AnAction[]{KubernetesResourceActionBaseKt.createResourceActionsGroup(), this.createAdditionalCustomActions()};
        return new DefaultActionGroup(anActionArray);
    }

    @NotNull
    protected DefaultActionGroup createAdditionalCustomActions() {
        return new DefaultActionGroup();
    }

    @Override
    @NotNull
    public String getId() {
        String namespace;
        V1ObjectMeta metadata = this.getResource$intellij_clouds_kubernetes().getMetadata();
        String string = metadata.getName();
        if (string == null) {
            String string2 = metadata.getUid();
            if (string2 == null) {
                string2 = String.valueOf(metadata);
            }
            return string2;
        }
        String name2 = string;
        String string3 = namespace = this.getMapper$intellij_clouds_kubernetes().getEntity$intellij_clouds_kubernetes().isNamespaced() ? metadata.getNamespace() : null;
        return (String)(string3 != null ? string3 + "/" : "") + name2;
    }

    @Nullable
    public JComponent getContentComponent() {
        JComponent jComponent;
        JComponent it = jComponent = ((KubernetesResourceContent)this.getContent$intellij_clouds_kubernetes()).getComponent();
        boolean bl = false;
        return !KubernetesContentInEditorKt.getShowServiceViewContentInEditor() ? jComponent : null;
    }

    public boolean isContentPartVisible() {
        return !KubernetesContentInEditorKt.getShowServiceViewContentInEditor();
    }

    public boolean handleDoubleClick(@NotNull MouseEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        JComponent component2 = ((KubernetesResourceContent)this.getContent$intellij_clouds_kubernetes()).getComponent();
        if (!KubernetesContentInEditorKt.getShowServiceViewContentInEditor()) {
            KubernetesViewYAMLAction.Companion.perform(component2, event2);
            return true;
        }
        Project project2 = this.getApiModel$intellij_clouds_kubernetes().getProject();
        ItemPresentation itemPresentation = this.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)itemPresentation, (String)"getPresentation(...)");
        KubernetesContentInEditorKt.showContentInEditor$default(project2, component2, this, itemPresentation, this.getId(), (Disposable)this, false, false, 192, null);
        return true;
    }

    @NotNull
    public DataProvider getDataProvider() {
        return KubernetesDeleteResourceProvider.dataProvider;
    }

    @Nullable
    public Runnable getRemover() {
        return null;
    }

    public void onNodeSelected(@Nullable List<Object> selectedServices) {
        if (!KubernetesContentInEditorKt.getShowServiceViewContentPreviewInEditor()) {
            return;
        }
        Project project2 = this.getApiModel$intellij_clouds_kubernetes().getProject();
        JComponent jComponent = ((KubernetesResourceContent)this.getContent$intellij_clouds_kubernetes()).getComponent();
        ItemPresentation itemPresentation = this.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)itemPresentation, (String)"getPresentation(...)");
        KubernetesContentInEditorKt.showContentInEditor$default(project2, jComponent, this, itemPresentation, this.getId(), (Disposable)this, false, true, 64, null);
    }
}

