/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view;

import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.view.KubernetesPodServiceViewDescriptorKt;
import com.intellij.kubernetes.view.KubernetesResourceServiceViewDescriptorBase;
import com.intellij.kubernetes.view.mappers.KubernetesPodMapperKt;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.ui.KubernetesPodContent;
import com.intellij.kubernetes.view.ui.actions.KubernetesPodActionBaseKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodStatus;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B/\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u0003H\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/view/KubernetesPodServiceViewDescriptor;", "Lcom/intellij/kubernetes/view/KubernetesResourceServiceViewDescriptorBase;", "Lio/kubernetes/client/openapi/models/V1Pod;", "Lcom/intellij/kubernetes/view/ui/KubernetesPodContent;", "resource", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "parentCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "(Lio/kubernetes/client/openapi/models/V1Pod;Lcom/intellij/kubernetes/api/KubernetesApiModel;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;)V", "createAdditionalCustomActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "createContent", "intellij.clouds.kubernetes"})
public final class KubernetesPodServiceViewDescriptor
extends KubernetesResourceServiceViewDescriptorBase<V1Pod, KubernetesPodContent> {
    public KubernetesPodServiceViewDescriptor(@NotNull V1Pod resource, @NotNull KubernetesApiModel apiModel2, @NotNull CoroutineScope parentCoroutineScope, @NotNull KubernetesResourceMapper<V1Pod, ?> mapper) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentCoroutineScope, (String)"parentCoroutineScope");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        V1PodStatus v1PodStatus = resource.getStatus();
        super((KubernetesObject)resource, apiModel2, parentCoroutineScope, mapper, v1PodStatus != null ? KubernetesPodMapperKt.getPodStatusIcon$default(v1PodStatus, (Icon)KubernetesPodServiceViewDescriptorKt.access$getPodSucceeded$p(), null, (Icon)KubernetesPodServiceViewDescriptorKt.access$getPodFailed$p(), (Icon)KubernetesPodServiceViewDescriptorKt.access$getPodPending$p(), KubernetesPodServiceViewDescriptorKt.access$getBasicIcon$p(), 2, null) : null);
    }

    @Override
    @NotNull
    protected KubernetesPodContent createContent() {
        return new KubernetesPodContent((V1Pod)this.getResource$intellij_clouds_kubernetes(), this.getApiModel$intellij_clouds_kubernetes(), (Disposable)this, this.getMapper$intellij_clouds_kubernetes(), this.getToolbarActions());
    }

    @Override
    @NotNull
    protected DefaultActionGroup createAdditionalCustomActions() {
        DefaultActionGroup actionGroup = super.createAdditionalCustomActions();
        actionGroup.addAll(KubernetesPodActionBaseKt.createPodActions());
        return actionGroup;
    }
}

