/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view;

import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.view.KubernetesServiceViewDescriptor;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.navigation.KubernetesNamespacedKeyValueResourceNavigationData;
import com.intellij.kubernetes.view.navigation.KubernetesResourceNavigationData;
import com.intellij.kubernetes.view.ui.KubernetesKeyValueViewerPanel;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import io.kubernetes.client.common.KubernetesObject;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003BK\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00028\u0000\u0012\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0004H\u0004J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/kubernetes/view/KubernetesKeyValueServiceViewDescriptor;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "Lcom/intellij/kubernetes/view/KubernetesServiceViewDescriptor;", "Ljavax/swing/JComponent;", "key", "", "value", "icon", "Ljavax/swing/Icon;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "parentCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "resource", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "(Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;Lcom/intellij/kubernetes/api/KubernetesApiModel;Lkotlinx/coroutines/CoroutineScope;Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;)V", "createCustomActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "createViewer", "equals", "", "other", "", "getContentComponent", "getId", "hashCode", "", "isAccepted", "navigationData", "Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesKeyValueServiceViewDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesKeyValueServiceViewDescriptor.kt\ncom/intellij/kubernetes/view/KubernetesKeyValueServiceViewDescriptor\n+ 2 KubernetesRuntimeUtilities.kt\ncom/intellij/kubernetes/util/KubernetesRuntimeUtilitiesKt\n*L\n1#1,58:1\n23#2:59\n*S KotlinDebug\n*F\n+ 1 KubernetesKeyValueServiceViewDescriptor.kt\ncom/intellij/kubernetes/view/KubernetesKeyValueServiceViewDescriptor\n*L\n42#1:59\n*E\n"})
public abstract class KubernetesKeyValueServiceViewDescriptor<T extends KubernetesObject>
extends KubernetesServiceViewDescriptor<T, JComponent> {
    @NotNull
    private final String key;
    @Nullable
    private final String value;

    public KubernetesKeyValueServiceViewDescriptor(@NotNull String key2, @Nullable String value2, @Nullable Icon icon, @NotNull KubernetesApiModel apiModel2, @NotNull CoroutineScope parentCoroutineScope, @NotNull T resource, @NotNull KubernetesResourceMapper<T, ?> mapper) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentCoroutineScope, (String)"parentCoroutineScope");
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        super(key2, icon, apiModel2, parentCoroutineScope, resource, mapper);
        this.key = key2;
        this.value = value2;
    }

    @Override
    @NotNull
    protected DefaultActionGroup createCustomActions() {
        AnAction[] anActionArray = new AnAction[]{ActionManager.getInstance().getAction("Kubernetes.FindUsages")};
        return new DefaultActionGroup(anActionArray);
    }

    @Override
    @NotNull
    public String getId() {
        return this.key;
    }

    @Nullable
    public JComponent getContentComponent() {
        return (JComponent)this.getContent$intellij_clouds_kubernetes();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        void it;
        KubernetesKeyValueServiceViewDescriptor $this$equals$iv = this;
        boolean $i$f$equals = false;
        if ($this$equals$iv == other) return true;
        Object object = other;
        if ($this$equals$iv.getClass() != (object != null ? object.getClass() : null)) return false;
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.kubernetes.view.KubernetesKeyValueServiceViewDescriptor<T>");
        }
        KubernetesKeyValueServiceViewDescriptor kubernetesKeyValueServiceViewDescriptor = (KubernetesKeyValueServiceViewDescriptor)object2;
        KubernetesKeyValueServiceViewDescriptor $this$equals_u24lambda_u240 = $this$equals$iv;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)$this$equals_u24lambda_u240.getApiModel$intellij_clouds_kubernetes(), (Object)it.getApiModel$intellij_clouds_kubernetes())) return false;
        if (!Intrinsics.areEqual((Object)$this$equals_u24lambda_u240.getId(), (Object)it.getId())) return false;
        if (!Intrinsics.areEqual((Object)$this$equals_u24lambda_u240.getResource$intellij_clouds_kubernetes().getMetadata().getNamespace(), (Object)it.getResource$intellij_clouds_kubernetes().getMetadata().getNamespace())) return false;
        if (!Intrinsics.areEqual((Object)$this$equals_u24lambda_u240.getResource$intellij_clouds_kubernetes().getMetadata().getName(), (Object)it.getResource$intellij_clouds_kubernetes().getMetadata().getName())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.getApiModel$intellij_clouds_kubernetes(), this.getId(), this.getResource$intellij_clouds_kubernetes().getMetadata().getNamespace(), this.getResource$intellij_clouds_kubernetes().getMetadata().getName()};
        return Objects.hash(objectArray);
    }

    @Override
    protected boolean isAccepted(@NotNull KubernetesResourceNavigationData navigationData) {
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        return navigationData instanceof KubernetesNamespacedKeyValueResourceNavigationData && Intrinsics.areEqual((Object)this.key, (Object)((KubernetesNamespacedKeyValueResourceNavigationData)navigationData).getKey()) && super.isAccepted(navigationData);
    }

    @NotNull
    protected final JComponent createViewer() {
        return new KubernetesKeyValueViewerPanel(this.getApiModel$intellij_clouds_kubernetes().getProject(), this.key, this.value, this.getResource$intellij_clouds_kubernetes());
    }
}

