/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view;

import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewNonActivatingDescriptor;
import com.intellij.execution.services.ServiceViewToolWindowDescriptor;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.KubernetesServiceViewContributorKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeletableServiceViewDescriptor;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeleteResourceProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/view/KubernetesDummyServiceViewNode;", "Lcom/intellij/execution/services/ServiceViewContributor;", "Lcom/intellij/execution/services/SimpleServiceViewDescriptor;", "()V", "getServiceDescriptor", "Lcom/intellij/execution/services/ServiceViewDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "service", "getServices", "", "getViewDescriptor", "ViewDescriptor", "intellij.clouds.kubernetes"})
public final class KubernetesDummyServiceViewNode
implements ServiceViewContributor<SimpleServiceViewDescriptor> {
    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new ViewDescriptor(project2);
    }

    @NotNull
    public List<SimpleServiceViewDescriptor> getServices(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return CollectionsKt.emptyList();
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project2, @NotNull SimpleServiceViewDescriptor service2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service2, (String)"service");
        throw new UnsupportedOperationException();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/intellij/kubernetes/view/KubernetesDummyServiceViewNode$ViewDescriptor;", "Lcom/intellij/execution/services/SimpleServiceViewDescriptor;", "Lcom/intellij/execution/services/ServiceViewNonActivatingDescriptor;", "Lcom/intellij/execution/services/ServiceViewToolWindowDescriptor;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesDeletableServiceViewDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/kubernetes/view/KubernetesDummyServiceViewNode;Lcom/intellij/openapi/project/Project;)V", "deletableName", "", "getDeletableName", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "getRemover", "Ljava/lang/Runnable;", "getStripeTitle", "getToolWindowIcon", "Ljavax/swing/Icon;", "getToolWindowId", "getToolbarActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "handleDoubleClick", "", "event", "Ljava/awt/event/MouseEvent;", "intellij.clouds.kubernetes"})
    public final class ViewDescriptor
    extends SimpleServiceViewDescriptor
    implements ServiceViewNonActivatingDescriptor,
    ServiceViewToolWindowDescriptor,
    KubernetesDeletableServiceViewDescriptor {
        @NotNull
        private final Project project;

        public ViewDescriptor(Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            super(KubernetesBundle.message("KubernetesServiceViewContributor.Descriptor.name", new Object[0]), KubernetesIcons.Kubernetes_Y, "Kubernetes");
            this.project = project2;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public DataProvider getDataProvider() {
            return KubernetesDeleteResourceProvider.dataProvider;
        }

        @NotNull
        public Runnable getRemover() {
            return () -> ViewDescriptor.getRemover$lambda$0(this, KubernetesDummyServiceViewNode.this);
        }

        @NotNull
        public String getToolWindowId() {
            String string = this.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            return string;
        }

        @NotNull
        public Icon getToolWindowIcon() {
            Icon icon = KubernetesIcons.ToolWindowKubernetes;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ToolWindowKubernetes");
            return icon;
        }

        @NotNull
        public String getStripeTitle() {
            String string = this.getPresentation().getPresentableText();
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        @NotNull
        public ActionGroup getToolbarActions() {
            AnAction anAction = ActionManager.getInstance().getAction("Kubernetes.CommonNodeActions");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
            return (ActionGroup)((DefaultActionGroup)anAction);
        }

        @Override
        @NotNull
        public String getDeletableName() {
            String string = this.getPresentation().getPresentableText();
            if (string == null) {
                String string2 = KubernetesBundle.message("KubernetesServiceViewContributor.Descriptor.name", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
            return string;
        }

        public boolean handleDoubleClick(@NotNull MouseEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            AnAction addContextsAction = ActionManager.getInstance().getAction("Kubernetes.AddContexts");
            ActionManager.getInstance().tryToExecute(addContextsAction, (InputEvent)event2, null, "KubernetesDummyServiceViewNode", true);
            return true;
        }

        private static final void getRemover$lambda$0(ViewDescriptor this$0, KubernetesDummyServiceViewNode this$1) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            AdvancedSettings.Companion.setBoolean("kubernetes.show.empty.node", false);
            KubernetesServiceViewContributorKt.fireKubernetesServiceChanged(this$0.project, ServiceEventListener.EventType.SERVICE_REMOVED, this$1);
        }
    }
}

