/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.util;

import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.util.StateFlowValue;
import com.intellij.kubernetes.util.StateObjectList;
import com.intellij.openapi.diagnostic.Logger;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.util.Watch;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0001\u001a\u0012\u0010\b\u001a\u00020\t*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n\u00a8\u0006\u000b"}, d2={"updateStateList", "", "T", "Lio/kubernetes/client/common/KubernetesObject;", "list", "Lcom/intellij/kubernetes/util/StateObjectList;", "event", "Lio/kubernetes/client/util/Watch$Response;", "getCoroutineName", "", "Lcom/intellij/kubernetes/util/StateFlowValue;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nStateFlowValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateFlowValue.kt\ncom/intellij/kubernetes/util/StateFlowValueKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,239:1\n13#2:240\n13#2:241\n*S KotlinDebug\n*F\n+ 1 StateFlowValue.kt\ncom/intellij/kubernetes/util/StateFlowValueKt\n*L\n215#1:240\n228#1:241\n*E\n"})
public final class StateFlowValueKt {
    @NotNull
    public static final String getCoroutineName(@NotNull StateFlowValue<?, ?> $this$getCoroutineName) {
        Intrinsics.checkNotNullParameter($this$getCoroutineName, (String)"<this>");
        return "Getting " + $this$getCoroutineName.getEntity().getDisplayableKinds();
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    public static final <T extends KubernetesObject> void updateStateList(@NotNull StateObjectList<T> list2, @NotNull Watch.Response<?> event2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter(event2, (String)"event");
        Object t = event2.object;
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type T of com.intellij.kubernetes.util.StateFlowValueKt.updateStateList");
        KubernetesObject resource = (KubernetesObject)t;
        String string = event2.type;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 62122208: {
                    if (!string.equals("ADDED")) break;
                    n = 1;
                    break;
                }
                case -1506962122: {
                    if (!string.equals("BOOKMARK")) break;
                    n = 2;
                    break;
                }
                case 167113417: {
                    if (!string.equals("MODIFIED")) break;
                    n = 3;
                    break;
                }
                case -2026521607: {
                    if (!string.equals("DELETED")) break;
                    n = 4;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(KubernetesApiProvider.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Metadata processing is not supported yet");
                    return;
                }
                case 1: {
                    String string2 = resource.getMetadata().getName();
                    String string3 = resource.getMetadata().getUid();
                    Intrinsics.checkNotNull((Object)string3);
                    String nameId = string2 + string3;
                    list2.updateValue(nameId, resource);
                    return;
                }
                case 3: {
                    String string4 = resource.getMetadata().getName();
                    String string5 = resource.getMetadata().getUid();
                    Intrinsics.checkNotNull((Object)string5);
                    String nameId = string4 + string5;
                    list2.updateValue(nameId, resource);
                    return;
                }
                case 4: {
                    String string6 = resource.getMetadata().getName();
                    String string7 = resource.getMetadata().getUid();
                    Intrinsics.checkNotNull((Object)string7);
                    String nameId = string6 + string7;
                    list2.removeValue(nameId);
                    return;
                }
            }
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesApiProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Unknown event type: " + event2.type + "}");
    }
}

