/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.intentions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.HelmExecutionManager;
import com.intellij.kubernetes.helm.RemoteHelmDependencyRepository;
import com.intellij.kubernetes.helm.chart.EffectiveHelmParameters;
import com.intellij.kubernetes.helm.dependencies.HelmIndex;
import com.intellij.kubernetes.helm.dependencies.dto.HubChartDto;
import com.intellij.kubernetes.helm.dependencies.dto.HubRepoDto;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.HelmAddRepositoryDialog;
import com.intellij.kubernetes.ui.intentions.HelmAddRepositoryAction;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kubernetes/ui/intentions/HelmAddRepositoryAction;", "Lcom/intellij/codeInspection/IntentionAndQuickFixAction;", "helmRepo", "Lcom/intellij/kubernetes/helm/RemoteHelmDependencyRepository;", "(Lcom/intellij/kubernetes/helm/RemoteHelmDependencyRepository;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "getFamilyName", "", "getName", "startInWriteAction", "", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmAddRepositoryAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmAddRepositoryAction.kt\ncom/intellij/kubernetes/ui/intentions/HelmAddRepositoryAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class HelmAddRepositoryAction
extends IntentionAndQuickFixAction {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final RemoteHelmDependencyRepository helmRepo;

    public HelmAddRepositoryAction(@NotNull RemoteHelmDependencyRepository helmRepo) {
        Intrinsics.checkNotNullParameter((Object)helmRepo, (String)"helmRepo");
        this.helmRepo = helmRepo;
    }

    @NotNull
    public String getName() {
        String string = KubernetesBundle.message("HelmChartUnknownValuesInspection.add.repository.quickfix.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return (IntentionPreviewInfo)new IntentionPreviewInfo.Html(KubernetesBundle.message("HelmChartUnknownValuesInspection.add.repository.quickfix.name.preview", new Object[0]));
    }

    public void applyFix(@NotNull Project project2, @Nullable PsiFile file2, @Nullable Editor editor) {
        String string;
        String predefinedRepoName;
        HubRepoDto repoDto;
        Object object4;
        String string2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (editor == null) {
            return;
        }
        PsiFile psiFile = file2;
        if (psiFile == null || (psiFile = YamlUtilKt.getVfsFile((PsiElement)psiFile)) == null) {
            return;
        }
        PsiFile vfsFile = psiFile;
        Ref allReposRef = new Ref();
        String string3 = KubernetesBundle.message("HelmChartUnknownValuesInspection.add.repository.quickfix.getting.repo.list.task.name", new Object[0]);
        new Task.Modal(project2, (Ref<List<HubRepoDto>>)allReposRef, string3){
            final /* synthetic */ Project $project;
            final /* synthetic */ Ref<List<HubRepoDto>> $allReposRef;
            {
                this.$project = $project;
                this.$allReposRef = $allReposRef;
                super($project, $super_call_param$1, true);
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Callable<Collection> callable = () -> applyFix.1.run$lambda$0(this.$project);
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
                Object object = ApplicationUtil.runWithCheckCanceled(callable, (ProgressIndicator)progressIndicator);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWithCheckCanceled(...)");
                object = (Iterable)object;
                Ref<List<HubRepoDto>> ref = this.$allReposRef;
                boolean $i$f$mapNotNull = false;
                void var4_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    HubRepoDto it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    HubChartDto it = (HubChartDto)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getRepository() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                ref.set((Object)((List)destination$iv$iv));
            }

            /*
             * WARNING - void declaration
             */
            public void onCancel() {
                List list2;
                Ref<List<HubRepoDto>> ref = this.$allReposRef;
                Object $this$service$iv = (ComponentManager)this.$project;
                boolean $i$f$service = false;
                Class<HelmIndex> serviceClass$iv = HelmIndex.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                Collection<HubChartDto> collection = ((HelmIndex)object).getDownloadedOnlyCharts();
                if (collection != null) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    $this$service$iv = collection;
                    Ref<List<HubRepoDto>> ref2 = ref;
                    boolean $i$f$mapNotNull = false;
                    serviceClass$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        HubRepoDto it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        HubChartDto it = (HubChartDto)element$iv$iv;
                        boolean bl2 = false;
                        if (it.getRepository() == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list2 = (List)destination$iv$iv;
                    ref = ref2;
                } else {
                    list2 = null;
                }
                ref.set(list2);
            }

            private static final Collection run$lambda$0(Project $project) {
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                ComponentManager $this$service$iv = (ComponentManager)$project;
                boolean $i$f$service = false;
                Class<HelmIndex> serviceClass$iv = HelmIndex.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return ((HelmIndex)object).getAllCharts();
            }
        }.queue();
        if (allReposRef.isNull()) {
            allReposRef.set((Object)CollectionsKt.emptyList());
        }
        if ((string2 = this.helmRepo.getAlias()) == null) {
            Object object2;
            block11: {
                Object object3 = allReposRef.get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                Iterable iterable = (Iterable)object3;
                for (Object object4 : iterable) {
                    String string4;
                    repoDto = (HubRepoDto)object4;
                    boolean bl = false;
                    if (repoDto.getUrl() != null) {
                        String it;
                        boolean bl2 = false;
                        string4 = StringUtil.trimEnd((String)it, (char)'/');
                    } else {
                        string4 = null;
                    }
                    if (!Intrinsics.areEqual((Object)string4, (Object)this.helmRepo.getSpecifiedUrl())) continue;
                    object2 = object4;
                    break block11;
                }
                object2 = null;
            }
            HubRepoDto hubRepoDto = (HubRepoDto)object2;
            string2 = predefinedRepoName = hubRepoDto != null ? hubRepoDto.getName() : null;
        }
        if ((string = this.helmRepo.getSpecifiedUrl()) == null) {
            HubRepoDto hubRepoDto;
            block12: {
                Object object5 = allReposRef.get();
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
                Iterable iterable = (Iterable)object5;
                object4 = iterable.iterator();
                while (object4.hasNext()) {
                    HubRepoDto repoDto2 = repoDto = object4.next();
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)repoDto2.getName(), (Object)this.helmRepo.getAlias())) continue;
                    hubRepoDto = repoDto;
                    break block12;
                }
                hubRepoDto = null;
            }
            HubRepoDto hubRepoDto2 = hubRepoDto;
            string = hubRepoDto2 != null ? hubRepoDto2.getUrl() : null;
        }
        String predefinedRepoUrl = string;
        HelmAddRepositoryDialog $this$applyFix_u24lambda_u243 = new HelmAddRepositoryDialog(project2, this.helmRepo, predefinedRepoName, predefinedRepoUrl);
        boolean bl = false;
        String cmdMoniker = null;
        if ($this$applyFix_u24lambda_u243.showAndGet()) {
            object4 = new String[]{"repo", "add", $this$applyFix_u24lambda_u243.getRepoName(), $this$applyFix_u24lambda_u243.getRepoUrl()};
            List helmCommand = CollectionsKt.mutableListOf((Object[])object4);
            VirtualFile workingDir = vfsFile.getParent();
            if (!StringsKt.isBlank((CharSequence)$this$applyFix_u24lambda_u243.getUsername())) {
                Object[] objectArray = new String[]{"--username", $this$applyFix_u24lambda_u243.getUsername()};
                helmCommand.addAll(CollectionsKt.listOf((Object[])objectArray));
                cmdMoniker = CollectionsKt.joinToString$default((Iterable)helmCommand, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + " --password ********";
                objectArray = new String[]{"--password", $this$applyFix_u24lambda_u243.getPassword()};
                helmCommand.addAll(CollectionsKt.listOf((Object[])objectArray));
            }
            HelmExecutionManager helmExecutionManager = HelmExecutionManager.Companion.getInstance(project2);
            String string5 = KubernetesBundle.message("HelmChartUnknownValuesInspection.add.repository.quickfix.adding.repo.task.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            EffectiveHelmParameters effectiveHelmParameters = EffectiveHelmParameters.Companion.getEMPTY_PARAMETERS();
            Intrinsics.checkNotNull((Object)workingDir);
            helmExecutionManager.executeSlowCommand(new HelmExecutionManager.ExecutionRequest(string5, helmCommand, effectiveHelmParameters, workingDir, null, cmdMoniker, null, 64, null), false, (Function1<? super ProcessHandler, Unit>)((Function1)new Function1<ProcessHandler, Unit>(project2, file2){
                final /* synthetic */ Project $project;
                final /* synthetic */ PsiFile $file;
                {
                    this.$project = $project;
                    this.$file = $file;
                    super(1);
                }

                public final void invoke(@NotNull ProcessHandler it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ComponentManager $this$service$iv = (ComponentManager)this.$project;
                    boolean $i$f$service = false;
                    Class<HelmIndex> serviceClass$iv = HelmIndex.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    ((HelmIndex)object).forceUpdateAddedReposCache();
                    DaemonCodeAnalyzer.getInstance((Project)this.$project).restart(this.$file);
                }
            }));
        }
    }
}

