/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.actions;

import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.actions.KubernetesActionBase;
import com.intellij.kubernetes.ui.actions.SlowHelmActionBase;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/ui/actions/HelmLintAction;", "Lcom/intellij/kubernetes/ui/actions/SlowHelmActionBase;", "()V", "helmCommand", "", "", "getHelmCommand", "()Ljava/util/List;", "getChart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "context", "Lcom/intellij/kubernetes/ui/actions/KubernetesActionBase$ActionContext;", "isApplicable", "", "onProcessFinished", "", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmLintAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmLintAction.kt\ncom/intellij/kubernetes/ui/actions/HelmLintAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,22:1\n31#2,2:23\n1#3:25\n*S KotlinDebug\n*F\n+ 1 HelmLintAction.kt\ncom/intellij/kubernetes/ui/actions/HelmLintAction\n*L\n16#1:23,2\n*E\n"})
public final class HelmLintAction
extends SlowHelmActionBase {
    @NotNull
    private final List<String> helmCommand;

    public HelmLintAction() {
        String string = KubernetesBundle.message("HelmLintAction.task.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, true);
        this.helmCommand = CollectionsKt.listOf((Object)"lint");
    }

    @Override
    @NotNull
    public List<String> getHelmCommand() {
        return this.helmCommand;
    }

    @Override
    protected boolean isApplicable(@NotNull KubernetesActionBase.ActionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getChart(context) != null;
    }

    @Override
    @Nullable
    protected Chart getChart(@NotNull KubernetesActionBase.ActionContext context) {
        Chart chart2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ComponentManager $this$service$iv = (ComponentManager)context.getProject();
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Chart chart3 = ((ChartManager)object).findChartByRelatedFile(context.getCurrentFile());
        if (chart3 != null) {
            Chart chart4;
            Chart it = chart4 = chart3;
            boolean bl = false;
            chart2 = !it.isDownloaded() && it.getChartFile() != null ? chart4 : null;
        } else {
            chart2 = null;
        }
        return chart2;
    }

    @Override
    protected void onProcessFinished(@NotNull KubernetesActionBase.ActionContext context) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Chart chart2 = this.getChart(context);
            if (chart2 == null || (chart2 = chart2.getBaseDir()) == null) break block0;
            chart2.refresh(false, true);
        }
    }
}

