/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui;

import com.intellij.execution.filters.Filter;
import com.intellij.kubernetes.helm.HelmExecutionManager;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.ui.FilePositionHyperlinkInfo;
import com.intellij.kubernetes.ui.HelmConsoleUtilKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/ui/HelmFilePointerFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmConsoleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmConsoleManager.kt\ncom/intellij/kubernetes/ui/HelmFilePointerFilter\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,187:1\n31#2,2:188\n31#2,2:191\n1#3:190\n1#3:203\n1603#4,9:193\n1855#4:202\n1856#4:204\n1612#4:205\n1282#5,2:206\n*S KotlinDebug\n*F\n+ 1 HelmConsoleManager.kt\ncom/intellij/kubernetes/ui/HelmFilePointerFilter\n*L\n155#1:188,2\n168#1:191,2\n172#1:203\n172#1:193,9\n172#1:202\n172#1:204\n172#1:205\n178#1:206,2\n*E\n"})
final class HelmFilePointerFilter
implements Filter {
    @NotNull
    private final Project project;

    public HelmFilePointerFilter(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        VirtualFile virtualFile;
        Object object;
        int lineOffset;
        block11: {
            block10: {
                VirtualFile virtualFile2;
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                ComponentManager $this$service$iv = (ComponentManager)this.project;
                boolean $i$f$service = false;
                Class<HelmExecutionManager> serviceClass$iv = HelmExecutionManager.class;
                Object object2 = $this$service$iv.getService(serviceClass$iv);
                if (object2 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                HelmExecutionManager executionManager = (HelmExecutionManager)object2;
                HelmExecutionManager.ExecutionRequest executionRequest = executionManager.getLastRequest();
                if (executionRequest == null) {
                    return null;
                }
                HelmExecutionManager.ExecutionRequest currentRequest = executionRequest;
                if (currentRequest.getChartDirName() == null) {
                    return null;
                }
                lineOffset = entireLength - line.length();
                if (!currentRequest.getWorkingDir().isValid()) {
                    return null;
                }
                object = currentRequest.getWorkingDir().findChild(currentRequest.getChartDirName());
                if (object == null) break block10;
                VirtualFile it = virtualFile2 = object;
                boolean bl = false;
                Object object3 = virtualFile = it.isDirectory() ? virtualFile2 : null;
                if (virtualFile != null) break block11;
            }
            return null;
        }
        VirtualFile baseDir = virtualFile;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service22 = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object4 = $this$service$iv.getService(serviceClass$iv);
        if (object4 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Chart chart2 = ((ChartManager)object4).findChartByBaseDir(baseDir);
        if (chart2 == null) {
            return null;
        }
        Chart chart3 = chart2;
        object = HelmConsoleUtilKt.extractSubdirectoryFileHyperlinks(line);
        boolean $i$f$mapNotNull = false;
        void $i$f$service22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Filter.ResultItem it$iv$iv;
            VirtualFile file2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FilePositionHyperlinkInfo hyperlinkInfo = (FilePositionHyperlinkInfo)element$iv$iv;
            boolean bl2 = false;
            if ((HelmConsoleUtilKt.findFile(chart3, hyperlinkInfo.getFilePath()) == null ? null : new Filter.ResultItem(lineOffset + hyperlinkInfo.getStartPosition(), lineOffset + hyperlinkInfo.getEndPosition(), arg_0 -> HelmFilePointerFilter.applyFilter$lambda$3$lambda$2(file2, hyperlinkInfo, arg_0))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return new Filter.Result(list2);
    }

    private static final void applyFilter$lambda$3$lambda$2(VirtualFile $file, FilePositionHyperlinkInfo $hyperlinkInfo, Project project2) {
        block4: {
            TextEditor textEditor;
            TextEditor editor;
            FileEditor fileEditor;
            block3: {
                FileEditor[] editors;
                Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                Intrinsics.checkNotNullParameter((Object)$hyperlinkInfo, (String)"$hyperlinkInfo");
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project2).openFile($file, true);
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
                FileEditor[] $this$firstOrNull$iv = editors = fileEditorArray;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    FileEditor element$iv;
                    FileEditor it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!(it instanceof TextEditor)) continue;
                    fileEditor = element$iv;
                    break block3;
                }
                fileEditor = null;
            }
            FileEditor fileEditor2 = fileEditor;
            TextEditor textEditor2 = editor = fileEditor2 instanceof TextEditor ? (TextEditor)fileEditor2 : null;
            if ($hyperlinkInfo.getRow() == null) break block4;
            TextEditor textEditor3 = editor;
            if (textEditor3 != null && (textEditor3 = textEditor3.getEditor()) != null && (textEditor3 = textEditor3.getCaretModel()) != null) {
                Integer n = $hyperlinkInfo.getColumn();
                textEditor3.moveToLogicalPosition(new LogicalPosition($hyperlinkInfo.getRow().intValue(), n != null ? n : 0));
            }
            if ((textEditor = editor) != null && (textEditor = textEditor.getEditor()) != null && (textEditor = textEditor.getScrollingModel()) != null) {
                textEditor.scrollToCaret(ScrollType.MAKE_VISIBLE);
            }
        }
    }
}

