/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui;

import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.config.HelmParameters;
import com.intellij.kubernetes.config.KubernetesProjectSettings;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.EffectiveHelmParameters;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextAreaKt;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0007H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u0007*\u00020\u00138CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kubernetes/ui/HelmCommandParametersDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "chart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "commandTitle", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/kubernetes/helm/chart/Chart;Ljava/lang/String;)V", "getChart", "()Lcom/intellij/kubernetes/helm/chart/Chart;", "helmParameters", "Lcom/intellij/kubernetes/helm/chart/EffectiveHelmParameters;", "getHelmParameters", "()Lcom/intellij/kubernetes/helm/chart/EffectiveHelmParameters;", "getProject", "()Lcom/intellij/openapi/project/Project;", "valuesFilesModel", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/openapi/vfs/VirtualFile;", "valuesText", "relativePath", "getRelativePath", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "getHelpId", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmCommandParametersDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmCommandParametersDialog.kt\ncom/intellij/kubernetes/ui/HelmCommandParametersDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1855#2,2:148\n*S KotlinDebug\n*F\n+ 1 HelmCommandParametersDialog.kt\ncom/intellij/kubernetes/ui/HelmCommandParametersDialog\n*L\n59#1:148,2\n*E\n"})
public final class HelmCommandParametersDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final Chart chart;
    @NotNull
    private final ListTableModel<VirtualFile> valuesFilesModel;
    @NotNull
    private String valuesText;

    /*
     * WARNING - void declaration
     */
    public HelmCommandParametersDialog(@NotNull Project project2, @NotNull Chart chart2, @Nls @Nullable String commandTitle) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
        super(project2, false);
        this.project = project2;
        this.chart = chart2;
        String string = commandTitle;
        if (string == null) {
            string = KubernetesBundle.message("HelmCommandParametersDialog.default.title", new Object[0]);
        }
        this.setTitle(string);
        if (commandTitle != null) {
            this.setOKButtonText(KubernetesBundle.message("HelmCommandParametersDialog.ok.button.title", new Object[0]));
        }
        this.setDoNotAskOption((DoNotAskOption)new DoNotAskOption.Adapter(){

            @NotNull
            public String getDoNotShowMessage() {
                String string = KubernetesBundle.message("HelmCommandParametersDialog.do.not.show.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public boolean isSelectedByDefault() {
                HelmParameters helmParameters = KubernetesProjectSettings.Companion.getInstance(this.getProject()).getHelmParameters(this.getChart());
                return helmParameters != null ? !helmParameters.getShowConfigDialog() : false;
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                KubernetesProjectSettings.Companion.getInstance(this.getProject()).getOrCreateHelmParameters(this.getChart()).setShowConfigDialog(!isSelected);
            }
        });
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ColumnInfo<VirtualFile, String>(){

            @Nullable
            public String valueOf(@Nullable VirtualFile item) {
                return item != null ? this.getRelativePath(item) : null;
            }
        }};
        this.valuesFilesModel = new ListTableModel(columnInfoArray);
        EffectiveHelmParameters $this$_init__u24lambda_u240 = this.chart.getEffectiveHelmParameters();
        boolean bl = false;
        Iterable iterable = $this$_init__u24lambda_u240.getValuesFiles();
        ListTableModel<VirtualFile> listTableModel = this.valuesFilesModel;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile p0 = (VirtualFile)element$iv;
            boolean bl2 = false;
            listTableModel.addRow((Object)p0);
        }
        String string2 = $this$_init__u24lambda_u240.getValues();
        if (string2 == null) {
            string2 = "";
        }
        this.valuesText = string2;
        this.init();
        this.valuesText = "";
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Chart getChart() {
        return this.chart;
    }

    @NotNull
    public final EffectiveHelmParameters getHelmParameters() {
        return new EffectiveHelmParameters(new ArrayList(this.valuesFilesModel.getItems()), this.valuesText);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        TableView tableView;
        TableView $this$createCenterPanel_u24lambda_u241 = tableView = new TableView(this.valuesFilesModel);
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u241.setVisibleRowCount(5);
        $this$createCenterPanel_u24lambda_u241.setShowGrid(false);
        $this$createCenterPanel_u24lambda_u241.setTableHeader(null);
        $this$createCenterPanel_u24lambda_u241.getEmptyText().setText(this.chart.getAvailableValuesFiles().isEmpty() ? KubernetesBundle.message("HelmCommandParametersDialog.values.files.table.empty.text.no.files.exist", new Object[0]) : KubernetesBundle.message("HelmCommandParametersDialog.values.files.table.empty.text", new Object[0]));
        TableView valuesFileTable = tableView;
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)valuesFileTable)).setAddAction(arg_0 -> HelmCommandParametersDialog.createCenterPanel$lambda$2(this, arg_0)).setAddActionUpdater(arg_0 -> HelmCommandParametersDialog.createCenterPanel$lambda$3(this, arg_0)).setRemoveActionUpdater(arg_0 -> HelmCommandParametersDialog.createCenterPanel$lambda$4(this, arg_0)).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel valuesFilesPanel2 = jPanel;
        return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(valuesFilesPanel2, this){
            final /* synthetic */ JPanel $valuesFilesPanel;
            final /* synthetic */ HelmCommandParametersDialog this$0;
            {
                this.$valuesFilesPanel = $valuesFilesPanel;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$valuesFilesPanel){
                    final /* synthetic */ JPanel $valuesFilesPanel;
                    {
                        this.$valuesFilesPanel = $valuesFilesPanel;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Cell.comment$default((Cell)$this$row.cell((JComponent)this.$valuesFilesPanel).align(Align.FILL).label(KubernetesBundle.message("HelmCommandParametersDialog.values.files.table.label", new Object[0]) + ":", LabelPosition.TOP), (String)KubernetesBundle.message("HelmCommandParametersDialog.values.files.table.comment", new Object[0]), (int)0, null, (int)6, null);
                    }
                }), (int)1, null).resizableRow();
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0, this.$valuesFilesPanel){
                    final /* synthetic */ HelmCommandParametersDialog this$0;
                    final /* synthetic */ JPanel $valuesFilesPanel;
                    {
                        this.this$0 = $receiver;
                        this.$valuesFilesPanel = $valuesFilesPanel;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Cell.comment$default((Cell)TextFieldKt.bindText((Cell)TextAreaKt.rows((Cell)$this$row.scrollCell((JComponent)new JBTextArea()).align(Align.FILL), (int)5), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                            @Nullable
                            public Object get() {
                                return HelmCommandParametersDialog.access$getValuesText$p((HelmCommandParametersDialog)((Object)this.receiver));
                            }

                            public void set(@Nullable Object value2) {
                                HelmCommandParametersDialog.access$setValuesText$p((HelmCommandParametersDialog)((Object)this.receiver), (String)value2);
                            }
                        })).label(KubernetesBundle.message("HelmCommandParametersDialog.additional.values.label", new Object[0]) + ":", LabelPosition.TOP), (String)KubernetesBundle.message("HelmCommandParametersDialog.additional.values.comment", new Object[0]), (int)-1, null, (int)4, null).applyToComponent((Function1)new Function1<JBTextArea, Unit>(this.$valuesFilesPanel){
                            final /* synthetic */ JPanel $valuesFilesPanel;
                            {
                                this.$valuesFilesPanel = $valuesFilesPanel;
                                super(1);
                            }

                            public final void invoke(@NotNull JBTextArea $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                $this$applyToComponent.setBorder(this.$valuesFilesPanel.getBorder());
                                $this$applyToComponent.getEmptyText().setText("outer.inner=value");
                            }
                        });
                    }
                }), (int)1, null).resizableRow();
            }
        }));
    }

    @NotNull
    protected String getHelpId() {
        return "Kubernetes.helm.parameters";
    }

    protected void doOKAction() {
        super.doOKAction();
        this.chart.saveHelmParameters(this.getHelmParameters());
    }

    @NlsSafe
    private final String getRelativePath(VirtualFile $this$relativePath) {
        return FileUtil.getRelativePath((String)this.chart.getBaseDir().getPath(), (String)$this$relativePath.getPath(), (char)'/');
    }

    private static final void createCenterPanel$lambda$2(HelmCommandParametersDialog this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ListPopup listPopup = PopupFactoryImpl.getInstance().createListPopup((ListPopupStep)new ListPopupStep<VirtualFile>(this$0){
            final /* synthetic */ HelmCommandParametersDialog this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public String getTitle() {
                String string = KubernetesBundle.message("HelmCommandParametersDialog.values.files.popup.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Nullable
            public PopupStep<?> onChosen(@Nullable VirtualFile selectedValue, boolean finalChoice) {
                HelmCommandParametersDialog.access$getValuesFilesModel$p(this.this$0).addRow((Object)selectedValue);
                return PopupStep.FINAL_CHOICE;
            }

            public boolean hasSubstep(@Nullable VirtualFile selectedValue) {
                return false;
            }

            public void canceled() {
            }

            public boolean isMnemonicsNavigationEnabled() {
                return false;
            }

            @Nullable
            public MnemonicNavigationFilter<VirtualFile> getMnemonicNavigationFilter() {
                return null;
            }

            public boolean isSpeedSearchEnabled() {
                return false;
            }

            @Nullable
            public SpeedSearchFilter<VirtualFile> getSpeedSearchFilter() {
                return null;
            }

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            @Nullable
            public Runnable getFinalRunnable() {
                return null;
            }

            @NotNull
            public List<VirtualFile> getValues() {
                Iterable iterable = this.this$0.getChart().getAvailableValuesFiles();
                List list2 = HelmCommandParametersDialog.access$getValuesFilesModel$p(this.this$0).getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
                return CollectionsKt.toMutableList((Collection)CollectionsKt.minus((Iterable)iterable, (Iterable)CollectionsKt.toSet((Iterable)list2)));
            }

            public boolean isSelectable(@Nullable VirtualFile value2) {
                return true;
            }

            @NotNull
            public Icon getIconFor(@Nullable VirtualFile value2) {
                Icon icon = KubernetesIcons.HelmValues;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"HelmValues");
                return icon;
            }

            @NotNull
            public String getTextFor(@NotNull VirtualFile value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                String string = HelmCommandParametersDialog.access$getRelativePath(this.this$0, value2);
                if (string == null) {
                    String string2 = value2.getName();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                }
                return string;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(@Nullable VirtualFile value2) {
                return null;
            }

            public int getDefaultOptionIndex() {
                return 0;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
        ListPopup popup2 = listPopup;
        popup2.show(it.getPreferredPopupPoint());
    }

    private static final boolean createCenterPanel$lambda$3(HelmCommandParametersDialog this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.valuesFilesModel.getItems().size() < this$0.chart.getAvailableValuesFiles().size();
    }

    private static final boolean createCenterPanel$lambda$4(HelmCommandParametersDialog this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.valuesFilesModel.getItems().size() > 1;
    }

    public static final /* synthetic */ String access$getValuesText$p(HelmCommandParametersDialog $this) {
        return $this.valuesText;
    }

    public static final /* synthetic */ void access$setValuesText$p(HelmCommandParametersDialog $this, String string) {
        $this.valuesText = string;
    }

    public static final /* synthetic */ ListTableModel access$getValuesFilesModel$p(HelmCommandParametersDialog $this) {
        return $this.valuesFilesModel;
    }
}

