/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.telepresence;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.kubernetes.api.FlowProcessBuilder;
import com.intellij.kubernetes.api.FlowProcessBuilderKt;
import com.intellij.kubernetes.api.ProcessFlowEvent;
import com.intellij.kubernetes.api.RequestFailedException;
import com.intellij.kubernetes.api.ResultCollector;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.telepresence.MergingMutexEvaluation;
import com.intellij.kubernetes.telepresence.TelepresenceAvailability;
import com.intellij.kubernetes.telepresence.TelepresenceSharedExecutor;
import com.intellij.kubernetes.util.GsonUtilKt;
import com.intellij.kubernetes.view.notification.KubernetesNotificationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import io.kubernetes.client.openapi.JSON;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0013\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0014J4\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\r\u0010\u0019\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u001a2\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c\u00a2\u0006\u0002\b\u001fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/kubernetes/telepresence/TelepresenceSharedExecutor;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "availability", "Lcom/intellij/kubernetes/telepresence/MergingMutexEvaluation;", "Lcom/intellij/kubernetes/telepresence/TelepresenceAvailability;", "<set-?>", "Lcom/intellij/openapi/util/Version;", "lastDetectedVersion", "getLastDetectedVersion", "()Lcom/intellij/openapi/util/Version;", "toolPath", "", "userDaemonStatus", "Lcom/google/gson/JsonObject;", "versionRegex", "Lkotlin/text/Regex;", "getAvailability", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUserDaemonStatus", "telepresenceProcess", "Lkotlinx/coroutines/flow/Flow;", "Lcom/intellij/kubernetes/api/ProcessFlowEvent;", "title", "Lcom/intellij/openapi/util/NlsContexts$ProgressTitle;", "build", "Lkotlin/Function1;", "Lcom/intellij/kubernetes/api/FlowProcessBuilder;", "", "Lkotlin/ExtensionFunctionType;", "intellij.clouds.kubernetes"})
public final class TelepresenceSharedExecutor {
    @NotNull
    private final Project project;
    @NotNull
    private final String toolPath;
    @Nullable
    private Version lastDetectedVersion;
    @NotNull
    private final Regex versionRegex;
    @NotNull
    private final MergingMutexEvaluation<TelepresenceAvailability> availability;
    @NotNull
    private final MergingMutexEvaluation<JsonObject> userDaemonStatus;

    public TelepresenceSharedExecutor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.toolPath = "telepresence";
        this.versionRegex = new Regex(".*Client\\s*:\\s*v([\\d.]+)");
        this.availability = new MergingMutexEvaluation((Function1)new Function1<Continuation<? super TelepresenceAvailability>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ TelepresenceSharedExecutor this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$collectAndGet$iv = this.this$0.telepresenceProcess(KubernetesBundle.message("progress.title.getting.telepresence.version", new Object[0]), (Function1<? super FlowProcessBuilder, Unit>)((Function1)availability.availability.output.1.INSTANCE));
                        collector$iv = new ResultCollector();
                        $i$f$collectAndGet = false;
                        it$iv = var7_13 = collector$iv;
                        $i$a$-also-FlowProcessExecutorKt$collectAndGet$2$iv = false;
                        this.L$0 = var7_13;
                        this.label = 1;
                        v0 = $this$collectAndGet$iv.collect(it$iv, (Continuation)this);
                        ** if (v0 != var12_2) goto lbl17
lbl16:
                        // 1 sources

                        return var12_2;
lbl17:
                        // 1 sources

                        ** GOTO lbl27
                    }
                    case 1: {
                        $i$f$collectAndGet = false;
                        $i$a$-also-FlowProcessExecutorKt$collectAndGet$2$iv = false;
                        var7_13 = (FlowCollector)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl27:
                            // 2 sources

                            output = ((ResultCollector)var7_13).getStdOutOrThrow();
                            $i$f$thisLogger = false;
                            v1 = Logger.getInstance(TelepresenceSharedExecutor.class);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                            $this$debug_u24default$iv = v1;
                            e$iv = null;
                            $i$f$debug = false;
                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                var11_24 /* !! */  = $this$debug_u24default$iv;
                                $i$a$-debug$default-TelepresenceSharedExecutor$availability$1$availability$1 = false;
                                var11_24 /* !! */ .debug("telepresence version output:\n" + output, e$iv);
                            }
                            $this$debug_u24default$iv = StringsKt.lineSequence((CharSequence)output);
                            e$iv = this.this$0;
                            var11_24 /* !! */  = this.this$0;
                            for (String line : $this$debug_u24default$iv) {
                                $i$a$-firstNotNullOfOrNull-TelepresenceSharedExecutor$availability$1$availability$2 = false;
                                v2 /* !! */  = TelepresenceSharedExecutor.access$getVersionRegex$p(e$iv).matchEntire((CharSequence)line);
                                if (v2 /* !! */  != null && (v2 /* !! */  = v2 /* !! */ .getGroupValues()) != null && (v2 /* !! */  = (String)CollectionsKt.getOrNull((List)v2 /* !! */ , (int)1)) != null) {
                                    it /* !! */  = v2 /* !! */ ;
                                    $i$a$-let-TelepresenceSharedExecutor$availability$1$availability$2$1 = false;
                                    v3 = Version.parseVersion((String)it /* !! */ );
                                } else {
                                    v3 = null;
                                }
                                if ((line = v3) == null) continue;
                                v4 = line;
                                ** GOTO lbl57
                            }
                            v4 = null;
lbl57:
                            // 2 sources

                            TelepresenceSharedExecutor.access$setLastDetectedVersion$p((TelepresenceSharedExecutor)var11_24 /* !! */ , v4);
                            $this$any$iv = StringsKt.lines((CharSequence)output);
                            $i$f$any = false;
                            if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl64
                            v5 = false;
                            ** GOTO lbl71
lbl64:
                            // 2 sources

                            for (T element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                $i$a$-any-TelepresenceSharedExecutor$availability$1$availability$3 = false;
                                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"not running", (boolean)false, (int)2, null)) continue;
                                v5 = true;
                                ** GOTO lbl71
                            }
                            v5 = false;
lbl71:
                            // 3 sources

                            if (!v5) ** GOTO lbl74
                            v6 = TelepresenceAvailability.DEAMON_NOT_STARTED;
                            ** GOTO lbl87
lbl74:
                            // 1 sources

                            $this$any$iv = StringsKt.lines((CharSequence)output);
                            $i$f$any = false;
                            if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl79
                            v7 = false;
                            ** GOTO lbl86
lbl79:
                            // 2 sources

                            for (T element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                $i$a$-any-TelepresenceSharedExecutor$availability$1$availability$4 = false;
                                if (!StringsKt.contains((CharSequence)it, (CharSequence)"client", (boolean)true)) continue;
                                v7 = true;
                                ** GOTO lbl86
                            }
                            v7 = false;
lbl86:
                            // 3 sources

                            v6 = v7 != false ? TelepresenceAvailability.AVAILABLE : TelepresenceAvailability.UNKNOWN;
lbl87:
                            // 2 sources

                            var3_23 = v6;
                        }
                        catch (ProcessNotCreatedException $this$any$iv) {
                            return TelepresenceAvailability.NOT_INSTALLED;
                        }
                        catch (RequestFailedException e) {
                            $i$f$thisLogger = false;
                            v8 = Logger.getInstance(TelepresenceSharedExecutor.class);
                            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getInstance(...)");
                            v8.warn("telepresence RequestFailedException", (Throwable)e);
                            v9 = e.getMessage();
                            v10 = v9 != null ? StringsKt.contains$default((CharSequence)v9, (CharSequence)"failed to launch the daemon service", (boolean)false, (int)2, null) : false;
                            if (v10) {
                                return TelepresenceAvailability.DEAMON_NOT_STARTED;
                            }
                            KubernetesNotificationManager.Companion.getInstance(TelepresenceSharedExecutor.access$getProject$p(this.this$0)).reportRequestError(e);
                            return TelepresenceAvailability.UNKNOWN;
                        }
                        availability = var3_23;
                        $i$f$thisLogger = false;
                        v11 = Logger.getInstance(TelepresenceSharedExecutor.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getInstance(...)");
                        v11.debug(TelepresenceSharedExecutor.access$getToolPath$p(this.this$0) + " available by version: " + availability);
                        return availability;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super TelepresenceAvailability> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
        this.userDaemonStatus = new MergingMutexEvaluation((Function1)new Function1<Continuation<? super JsonObject>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ TelepresenceSharedExecutor this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$collectAndGet$iv = this.this$0.telepresenceProcess(KubernetesBundle.message("progress.title.checking.telepresence.status", new Object[0]), (Function1<? super FlowProcessBuilder, Unit>)((Function1)userDaemonStatus.output.1.INSTANCE));
                        collector$iv = new ResultCollector();
                        $i$f$collectAndGet = false;
                        it$iv = var6_7 = collector$iv;
                        $i$a$-also-FlowProcessExecutorKt$collectAndGet$2$iv = false;
                        this.L$0 = var6_7;
                        this.label = 1;
                        v0 = $this$collectAndGet$iv.collect(it$iv, (Continuation)this);
                        if (v0 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl23
                    }
                    case 1: {
                        $i$f$collectAndGet = false;
                        $i$a$-also-FlowProcessExecutorKt$collectAndGet$2$iv = false;
                        var6_7 = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl23:
                        // 2 sources

                        output = ((ResultCollector)var6_7).getStdOutOrThrow();
                        v1 = (JsonElement)new JSON().getGson().fromJson(output, JsonElement.class);
                        if (v1 == null || (v1 = GsonUtilKt.asJsonObjectOrNull(v1)) == null) {
                            return null;
                        }
                        parsedOutput = v1;
                        v2 = GsonUtilKt.optJsonObject((JsonObject)parsedOutput, "user_daemon");
                        if (v2 == null) {
                            return null;
                        }
                        return v2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super JsonObject> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @NotNull
    public final Flow<ProcessFlowEvent> telepresenceProcess(@Nullable String title, @NotNull Function1<? super FlowProcessBuilder, Unit> build) {
        Intrinsics.checkNotNullParameter(build, (String)"build");
        return FlowProcessBuilderKt.buildProcessFlow(this.project, this.toolPath, (Function1<? super FlowProcessBuilder, Unit>)((Function1)new Function1<FlowProcessBuilder, Unit>(title, build){
            final /* synthetic */ String $title;
            final /* synthetic */ Function1<FlowProcessBuilder, Unit> $build;
            {
                this.$title = $title;
                this.$build = $build;
                super(1);
            }

            public final void invoke(@NotNull FlowProcessBuilder $this$buildProcessFlow) {
                Intrinsics.checkNotNullParameter((Object)$this$buildProcessFlow, (String)"$this$buildProcessFlow");
                $this$buildProcessFlow.setTitle(this.$title);
                this.$build.invoke((Object)$this$buildProcessFlow);
            }
        }));
    }

    @Nullable
    public final Version getLastDetectedVersion() {
        return this.lastDetectedVersion;
    }

    @Nullable
    public final Object getAvailability(@NotNull Continuation<? super TelepresenceAvailability> $completion) {
        return this.availability.invoke($completion);
    }

    @Nullable
    public final Object getUserDaemonStatus(@NotNull Continuation<? super JsonObject> $completion) {
        return this.userDaemonStatus.invoke($completion);
    }

    public static final /* synthetic */ void access$setLastDetectedVersion$p(TelepresenceSharedExecutor $this, Version version2) {
        $this.lastDetectedVersion = version2;
    }

    public static final /* synthetic */ Project access$getProject$p(TelepresenceSharedExecutor $this) {
        return $this.project;
    }

    public static final /* synthetic */ String access$getToolPath$p(TelepresenceSharedExecutor $this) {
        return $this.toolPath;
    }

    public static final /* synthetic */ Regex access$getVersionRegex$p(TelepresenceSharedExecutor $this) {
        return $this.versionRegex;
    }
}

