/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.telepresence;

import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.ProcessFlowEvent;
import com.intellij.kubernetes.telepresence.CommandFilter;
import com.intellij.kubernetes.telepresence.HelmInstallFilter;
import com.intellij.kubernetes.telepresence.HelmUpgradeFilter;
import com.intellij.kubernetes.telepresence.TelepresenceProblem;
import com.intellij.kubernetes.telepresence.TelepresenceQuitFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.SuspendFunction;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/telepresence/TelepresenceOutputCommands;", "", "()V", "commandFilters", "", "Lcom/intellij/kubernetes/telepresence/CommandFilter;", "getCommandFilters", "()Ljava/util/List;", "PfeFirstProblemCollector", "PfeHandler", "intellij.clouds.kubernetes"})
public final class TelepresenceOutputCommands {
    @NotNull
    public static final TelepresenceOutputCommands INSTANCE = new TelepresenceOutputCommands();
    @NotNull
    private static final List<CommandFilter> commandFilters;

    private TelepresenceOutputCommands() {
    }

    @NotNull
    public final List<CommandFilter> getCommandFilters() {
        return commandFilters;
    }

    static {
        Object[] objectArray = new CommandFilter[]{new HelmInstallFilter(), new HelmUpgradeFilter(), new TelepresenceQuitFilter("telepresence quit -s", "please run 'telepresence quit -s'"), new TelepresenceQuitFilter("quit telepresence", "please quit telepresence")};
        commandFilters = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u001e\b\u0001\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0002H\u0096B\u00a2\u0006\u0002\u0010\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/kubernetes/telepresence/TelepresenceOutputCommands$PfeFirstProblemCollector;", "Lkotlin/Function2;", "Lcom/intellij/kubernetes/api/ProcessFlowEvent;", "Lkotlin/coroutines/Continuation;", "", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "(Lcom/intellij/kubernetes/api/KubernetesApiModel;)V", "_firstProblemReason", "Lcom/intellij/kubernetes/telepresence/TelepresenceProblem;", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModel;", "firstProblemReason", "getFirstProblemReason", "()Lcom/intellij/kubernetes/telepresence/TelepresenceProblem;", "helmInstallFilter", "Lcom/intellij/kubernetes/telepresence/HelmInstallFilter;", "helmUpgradeFilter", "Lcom/intellij/kubernetes/telepresence/HelmUpgradeFilter;", "invoke", "pfe", "(Lcom/intellij/kubernetes/api/ProcessFlowEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
    public static final class PfeFirstProblemCollector
    implements Function2<ProcessFlowEvent, Continuation<? super Unit>, Object>,
    SuspendFunction {
        @NotNull
        private final KubernetesApiModel apiModel;
        @Nullable
        private TelepresenceProblem _firstProblemReason;
        @NotNull
        private final HelmInstallFilter helmInstallFilter;
        @NotNull
        private final HelmUpgradeFilter helmUpgradeFilter;

        public PfeFirstProblemCollector(@NotNull KubernetesApiModel apiModel2) {
            Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
            this.apiModel = apiModel2;
            this.helmInstallFilter = new HelmInstallFilter();
            this.helmUpgradeFilter = new HelmUpgradeFilter();
        }

        @NotNull
        public final KubernetesApiModel getApiModel() {
            return this.apiModel;
        }

        @Nullable
        public final TelepresenceProblem getFirstProblemReason() {
            return this._firstProblemReason;
        }

        @Nullable
        public Object invoke(@NotNull ProcessFlowEvent pfe, @NotNull Continuation<? super Unit> $completion) {
            if (this._firstProblemReason != null) {
                return Unit.INSTANCE;
            }
            if (pfe instanceof ProcessFlowEvent.OnProcessOutput) {
                String string = ((ProcessFlowEvent.OnProcessOutput)pfe).getProcessEvent().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                for (String line : StringsKt.lineSequence((CharSequence)string)) {
                    if (this.helmInstallFilter.applyFilter(line, line.length()) != null) {
                        this._firstProblemReason = TelepresenceProblem.TrafficManagerNotInstalled.INSTANCE;
                    }
                    if (this.helmUpgradeFilter.applyFilter(line, line.length()) == null) continue;
                    this._firstProblemReason = TelepresenceProblem.TrafficManagerNotInstalled.INSTANCE;
                }
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u001e\b\u0001\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0002H\u0096B\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/telepresence/TelepresenceOutputCommands$PfeHandler;", "Lkotlin/Function2;", "Lcom/intellij/kubernetes/api/ProcessFlowEvent;", "Lkotlin/coroutines/Continuation;", "", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "(Lcom/intellij/kubernetes/api/KubernetesApiModel;)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModel;", "commandsToInvokeOnTextAppearance", "", "Lcom/intellij/kubernetes/telepresence/CommandFilter;", "invoke", "pfe", "(Lcom/intellij/kubernetes/api/ProcessFlowEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nTelepresenceConsoleFilterProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelepresenceConsoleFilterProvider.kt\ncom/intellij/kubernetes/telepresence/TelepresenceOutputCommands$PfeHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n766#2:171\n857#2,2:172\n*S KotlinDebug\n*F\n+ 1 TelepresenceConsoleFilterProvider.kt\ncom/intellij/kubernetes/telepresence/TelepresenceOutputCommands$PfeHandler\n*L\n49#1:171\n49#1:172,2\n*E\n"})
    public static final class PfeHandler
    implements Function2<ProcessFlowEvent, Continuation<? super Unit>, Object>,
    SuspendFunction {
        @NotNull
        private final KubernetesApiModel apiModel;
        @NotNull
        private final List<CommandFilter> commandsToInvokeOnTextAppearance;

        /*
         * WARNING - void declaration
         */
        public PfeHandler(@NotNull KubernetesApiModel apiModel2) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
            this.apiModel = apiModel2;
            Iterable iterable = INSTANCE.getCommandFilters();
            PfeHandler pfeHandler = this;
            boolean $i$f$filter = false;
            void var4_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CommandFilter it = (CommandFilter)element$iv$iv;
                boolean bl = false;
                if (!it.getAutoInvoke()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            pfeHandler.commandsToInvokeOnTextAppearance = (List)destination$iv$iv;
        }

        @NotNull
        public final KubernetesApiModel getApiModel() {
            return this.apiModel;
        }

        @Nullable
        public Object invoke(@NotNull ProcessFlowEvent pfe, @NotNull Continuation<? super Unit> $completion) {
            if (pfe instanceof ProcessFlowEvent.OnProcessOutput) {
                String string = ((ProcessFlowEvent.OnProcessOutput)pfe).getProcessEvent().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                for (String line : StringsKt.lineSequence((CharSequence)string)) {
                    for (CommandFilter command : this.commandsToInvokeOnTextAppearance) {
                        if (command.applyFilter(line, line.length()) == null) continue;
                        command.invoke(this.apiModel);
                    }
                }
            }
            return Unit.INSTANCE;
        }
    }
}

