/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.telepresence;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.telepresence.TelepresenceCreateInterceptionAction;
import com.intellij.kubernetes.telepresence.TelepresenceInterceptOptions;
import com.intellij.kubernetes.telepresence.TelepresenceInterceptionDialog;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.ui.UI;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ReplicaSet;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\u0006\u0010\u0018\u001a\u00020\tR\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/intellij/kubernetes/telepresence/TelepresenceInterceptionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "availableServices", "", "Lio/kubernetes/client/common/KubernetesObject;", "(Lcom/intellij/kubernetes/api/KubernetesApiModel;Ljava/util/List;)V", "currentOptions", "Lcom/intellij/kubernetes/telepresence/TelepresenceInterceptOptions;", "getCurrentOptions", "()Lcom/intellij/kubernetes/telepresence/TelepresenceInterceptOptions;", "otherOptions", "Lcom/intellij/ui/TextFieldWithStoredHistory;", "ports", "services", "Lcom/intellij/openapi/ui/ComboBox;", "getServices", "()Lcom/intellij/openapi/ui/ComboBox;", "createCenterPanel", "Ljavax/swing/JComponent;", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "getPreferredFocusedComponent", "storeAndGetSelectedOptions", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nTelepresenceCreateInterceptionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelepresenceCreateInterceptionAction.kt\ncom/intellij/kubernetes/telepresence/TelepresenceInterceptionDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,241:1\n1#2:242\n35#3:243\n14#3:244\n*S KotlinDebug\n*F\n+ 1 TelepresenceCreateInterceptionAction.kt\ncom/intellij/kubernetes/telepresence/TelepresenceInterceptionDialog\n*L\n117#1:243\n151#1:244\n*E\n"})
final class TelepresenceInterceptionDialog
extends DialogWrapper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final ComboBox<KubernetesObject> services;
    @NotNull
    private final TextFieldWithStoredHistory ports;
    @NotNull
    private final TextFieldWithStoredHistory otherOptions;
    @NotNull
    private static final Regex SPLITTER = new Regex("[,\\s]+");

    /*
     * WARNING - void declaration
     */
    public TelepresenceInterceptionDialog(@NotNull KubernetesApiModel apiModel2, @NotNull List<? extends KubernetesObject> availableServices) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter(availableServices, (String)"availableServices");
        super(apiModel2.getProject());
        this.ports = new TextFieldWithStoredHistory(TelepresenceInterceptionDialog.Companion.qualifiedPropertyName("ports"));
        this.otherOptions = new TextFieldWithStoredHistory(TelepresenceInterceptionDialog.Companion.qualifiedPropertyName("otherOptions"));
        if (!((Collection)availableServices).isEmpty()) {
            void $this$_init__u24lambda_u244;
            ComboBox comboBox;
            ComboBox comboBox2 = comboBox = new ComboBox();
            TelepresenceInterceptionDialog telepresenceInterceptionDialog = this;
            boolean bl = false;
            $this$_init__u24lambda_u244.setRenderer((ListCellRenderer)new SimpleListCellRenderer<KubernetesObject>(){

                public void customize(@NotNull JList<? extends KubernetesObject> list2, @Nullable KubernetesObject value2, int index, boolean selected, boolean hasFocus) {
                    Intrinsics.checkNotNullParameter(list2, (String)"list");
                    Object object = value2;
                    this.setText(object != null && (object = object.getMetadata()) != null ? ((V1ObjectMeta)object).getName() : null);
                    KubernetesObject kubernetesObject = value2;
                    if (kubernetesObject instanceof V1Deployment) {
                        this.setIcon(AllIcons.Nodes.Deploy);
                    } else if (kubernetesObject instanceof V1ReplicaSet) {
                        this.setIcon(KubernetesIcons.ReplicaSets);
                    } else if (kubernetesObject instanceof V1StatefulSet) {
                        this.setIcon(AllIcons.Scope.ChangedFilesAll);
                    }
                }
            });
            ComboboxSpeedSearch.installSpeedSearch((JComboBox)((JComboBox)$this$_init__u24lambda_u244), arg_0 -> TelepresenceInterceptionDialog.lambda$4$lambda$0(1.2.INSTANCE, arg_0));
            for (KubernetesObject kubernetesObject : availableServices) {
                $this$_init__u24lambda_u244.addItem((Object)kubernetesObject);
            }
            String string = PropertiesComponent.getInstance().getValue(TelepresenceInterceptionDialog.Companion.qualifiedPropertyName("services"));
            if (string != null) {
                Object v2;
                block6: {
                    String storedValue = string;
                    boolean bl2 = false;
                    Iterable iterable = availableServices;
                    for (Object t : iterable) {
                        KubernetesObject it = (KubernetesObject)t;
                        boolean bl3 = false;
                        V1ObjectMeta v1ObjectMeta = it.getMetadata();
                        if (!Intrinsics.areEqual((Object)(v1ObjectMeta != null ? v1ObjectMeta.getName() : null), (Object)storedValue)) continue;
                        v2 = t;
                        break block6;
                    }
                    v2 = null;
                }
                KubernetesObject kubernetesObject = v2;
                if (kubernetesObject != null) {
                    KubernetesObject prevSelected = kubernetesObject;
                    boolean bl4 = false;
                    $this$_init__u24lambda_u244.setSelectedItem((Object)prevSelected);
                }
            }
            telepresenceInterceptionDialog.services = comboBox;
        } else {
            this.services = null;
        }
        TelepresenceInterceptionDialog.Companion.initFieldWithStoredHistory(this.ports, 40);
        TelepresenceInterceptionDialog.Companion.initFieldWithStoredHistory(this.otherOptions, 60);
        this.setTitle(KubernetesBundle.message("TelepresenceInterceptionDialog.dialog.title.telepresence.intercept.options", new Object[0]));
        this.setOKButtonText(KubernetesBundle.message("TelepresenceInterceptionDialog.button.telepresence.intercept", new Object[0]));
        this.init();
    }

    @Nullable
    public final ComboBox<KubernetesObject> getServices() {
        return this.services;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        PanelGridBuilder panelGridBuilder;
        PanelGridBuilder panelGridBuilder2 = UI.PanelFactory.grid();
        boolean condition$iv = this.services != null;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$applyIf$iv;
            void $this$createCenterPanel_u24lambda_u245 = $this$applyIf$iv;
            boolean bl = false;
            panelGridBuilder = $this$createCenterPanel_u24lambda_u245.add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)this.services)).withLabel(KubernetesBundle.message("TelepresenceInterceptionDialog.label.telepresence.service", new Object[0])).withComment(KubernetesBundle.message("TelepresenceInterceptionDialog.label.text.select.service.to.intercept", new Object[0])));
        } else {
            panelGridBuilder = panelGridBuilder2;
        }
        JPanel jPanel = panelGridBuilder.add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)this.ports)).withLabel(KubernetesBundle.message("TelepresenceInterceptionDialog.label.telepresence.ports", new Object[0])).withComment(KubernetesBundle.message("TelepresenceInterceptionDialog.text.specify.ports.to.intercept.html", new Object[0]))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)this.otherOptions)).withLabel(KubernetesBundle.message("TelepresenceInterceptionDialog.label.telepresence.advanced.options", new Object[0])).withComment(KubernetesBundle.message("TelepresenceInterceptionDialog.text.specify.additional.options.for.telepresence.html", new Object[0]))).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        return jPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.getCurrentOptions().isEmpty() ? new ValidationInfo(KubernetesBundle.message("TelepresenceInterceptionDialog.dialog.message.specify.ports.to.intercept", new Object[0]), (JComponent)this.ports) : null;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.ports;
    }

    private final TelepresenceInterceptOptions getCurrentOptions() {
        List portValues = TelepresenceInterceptionDialog.Companion.splitText(this.ports);
        List options = TelepresenceInterceptionDialog.Companion.splitText(this.otherOptions);
        return new TelepresenceInterceptOptions(portValues, options);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final TelepresenceInterceptOptions storeAndGetSelectedOptions() {
        block5: {
            if (this.services == null) break block5;
            v0 = PropertiesComponent.getInstance();
            v1 = com.intellij.kubernetes.telepresence.TelepresenceInterceptionDialog$Companion.access$qualifiedPropertyName(TelepresenceInterceptionDialog.Companion, "services");
            v2 = this.services.getSelectedItem();
            if (v2 == null) ** GOTO lbl-1000
            $this$asSafely$iv = v2;
            $i$f$asSafely = false;
            v3 = $this$asSafely$iv;
            if (!(v3 instanceof KubernetesObject)) {
                v3 = null;
            }
            if ((v2 = (KubernetesObject)v3) != null && (v2 = v2.getMetadata()) != null) {
                v4 = v2.getName();
            } else lbl-1000:
            // 2 sources

            {
                v4 = null;
            }
            v0.setValue(v1, v4);
        }
        it = var1_4 = this.getCurrentOptions();
        $i$a$-also-TelepresenceInterceptionDialog$storeAndGetSelectedOptions$1 = false;
        if (((Collection)it.getPorts()).isEmpty() == false) {
            this.ports.addCurrentTextToHistory();
        }
        if (((Collection)it.getOptions()).isEmpty() == false) {
            this.otherOptions.addCurrentTextToHistory();
        }
        return var1_4;
    }

    private static final String lambda$4$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0016\u0010\b\u001a\u00020\t*\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e*\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/telepresence/TelepresenceInterceptionDialog$Companion;", "", "()V", "SPLITTER", "Lkotlin/text/Regex;", "qualifiedPropertyName", "", "suffix", "initFieldWithStoredHistory", "", "Lcom/intellij/ui/TextFieldWithStoredHistory;", "columnsCount", "", "splitText", "", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nTelepresenceCreateInterceptionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelepresenceCreateInterceptionAction.kt\ncom/intellij/kubernetes/telepresence/TelepresenceInterceptionDialog$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n766#2:242\n857#2,2:243\n1#3:245\n*S KotlinDebug\n*F\n+ 1 TelepresenceCreateInterceptionAction.kt\ncom/intellij/kubernetes/telepresence/TelepresenceInterceptionDialog$Companion\n*L\n170#1:242\n170#1:243,2\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        private final String qualifiedPropertyName(String suffix) {
            return Reflection.getOrCreateKotlinClass(TelepresenceCreateInterceptionAction.class).getQualifiedName() + "." + suffix;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> splitText(TextFieldWithStoredHistory $this$splitText) {
            void $this$filterTo$iv$iv;
            String string = $this$splitText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence charSequence = string;
            Regex regex = SPLITTER;
            int n = 0;
            Iterable $this$filter$iv = regex.split(charSequence, n);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final void initFieldWithStoredHistory(TextFieldWithStoredHistory $this$initFieldWithStoredHistory, int columnsCount) {
            block0: {
                $this$initFieldWithStoredHistory.setEditor((ComboBoxEditor)new BasicComboBoxEditor(columnsCount){
                    final /* synthetic */ int $columnsCount;
                    {
                        this.$columnsCount = $columnsCount;
                    }

                    @NotNull
                    protected JTextField createEditorComponent() {
                        ExpandableTextField expandableTextField = new ExpandableTextField();
                        int n = this.$columnsCount;
                        ExpandableTextField $this$createEditorComponent_u24lambda_u240 = expandableTextField;
                        boolean bl = false;
                        $this$createEditorComponent_u24lambda_u240.setBorder(null);
                        $this$createEditorComponent_u24lambda_u240.setColumns(n);
                        return (JTextField)expandableTextField;
                    }
                });
                $this$initFieldWithStoredHistory.setHistorySize(-1);
                $this$initFieldWithStoredHistory.reset();
                List list2 = $this$initFieldWithStoredHistory.getHistory();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getHistory(...)");
                String string = (String)CollectionsKt.firstOrNull((List)list2);
                if (string == null) break block0;
                String it = string;
                boolean bl = false;
                $this$initFieldWithStoredHistory.setSelectedItem((Object)it);
            }
        }

        static /* synthetic */ void initFieldWithStoredHistory$default(Companion companion, TextFieldWithStoredHistory textFieldWithStoredHistory, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 40;
            }
            companion.initFieldWithStoredHistory(textFieldWithStoredHistory, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

