/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.telepresence;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.install.ArchDistribution;
import com.intellij.kubernetes.install.BinaryInstaller;
import com.intellij.kubernetes.install.FailedInstallation;
import com.intellij.kubernetes.install.InstallationResult;
import com.intellij.kubernetes.install.OSDistribution;
import com.intellij.kubernetes.telepresence.TelepresenceInstallActionKt;
import com.intellij.kubernetes.telepresence.TelepresenceModel;
import com.intellij.kubernetes.view.notification.KubernetesNotificationManager;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.system.CpuArch;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0080@\u00a2\u0006\u0002\u0010\t\u001a\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"TELEPRESENCE_INSTALL_VERSION", "", "distributions", "", "Lcom/intellij/kubernetes/install/OSDistribution;", "downloadAndInstallTelepresence", "Lcom/intellij/kubernetes/install/InstallationResult;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadAndInstallTelepresenceInteractive", "", "asUpgrade", "", "intellij.clouds.kubernetes"})
public final class TelepresenceInstallActionKt {
    @NotNull
    public static final String TELEPRESENCE_INSTALL_VERSION = "2.19.0";
    @NotNull
    private static final Map<String, OSDistribution> distributions;

    @RequiresEdt
    public static final void downloadAndInstallTelepresenceInteractive(@NotNull Project project2, boolean asUpgrade) {
        OSDistribution osDistribution;
        OkCancelDialogBuilder okCancelDialogBuilder;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        KubernetesUsageTriggerCollector.INSTANCE.getTELEPRESENCE_ACTION_TRIGGERED_EVENT().log(project2, (Object)"telepresence-install");
        if (SystemInfoRt.isWindows) {
            String windowsDownloadUrl = "https://www.telepresence.io/docs/latest/quick-start/?os=windows";
            Object[] objectArray = new Object[]{windowsDownloadUrl};
            Messages.showInfoMessage((String)KubernetesBundle.message("dialog.Telepresence.install.suggest.win", objectArray), (String)KubernetesBundle.message("dialog.Telepresence.install.telepresence.not.installed", new Object[0]));
            return;
        }
        if (asUpgrade) {
            String string = KubernetesBundle.message("dialog.Telepresence.install.telepresence.upgrade", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object[] objectArray = new Object[]{TelepresenceModel.Companion.getMINIMAL_REQUIRED_VERSION(), TELEPRESENCE_INSTALL_VERSION};
            String string2 = KubernetesBundle.message("dialog.Telepresence.install.suggest.upgrade", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            okCancelDialogBuilder = MessageDialogBuilder.Companion.okCancel(string, string2);
        } else {
            String string = KubernetesBundle.message("dialog.Telepresence.install.telepresence.not.installed", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string3 = KubernetesBundle.message("dialog.Telepresence.install.suggest", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            okCancelDialogBuilder = MessageDialogBuilder.Companion.okCancel(string, string3);
        }
        OkCancelDialogBuilder dialog2 = okCancelDialogBuilder;
        String string = LangBundle.message((String)"button.install", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        if (!((OkCancelDialogBuilder)dialog2.yesText(string)).ask(project2)) {
            return;
        }
        OSDistribution oSDistribution = SystemInfoRt.isMac ? distributions.get("darwin") : (osDistribution = SystemInfoRt.isLinux ? distributions.get("linux") : null);
        if (osDistribution == null) {
            KubernetesNotificationManager.Companion.getInstance(project2).reportRequestError(new IllegalStateException("Unable to find Telepresence distribution for platform: " + SystemInfoRt.OS_NAME));
            return;
        }
        ArchDistribution archDistribution = CpuArch.isArm64() ? osDistribution.getArm64() : osDistribution.getAmd64();
        String downloadUrl = archDistribution.getUrl();
        BinaryInstaller.Companion.create(project2).withBinaryName((Function0<String>)((Function0)downloadAndInstallTelepresenceInteractive.1.INSTANCE)).withDownloadUrl((Function1<? super BinaryInstaller.Configuration, String>)((Function1)new Function1<BinaryInstaller.Configuration, String>(downloadUrl){
            final /* synthetic */ String $downloadUrl;
            {
                this.$downloadUrl = $downloadUrl;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull BinaryInstaller.Configuration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$downloadUrl;
            }
        })).install();
    }

    public static /* synthetic */ void downloadAndInstallTelepresenceInteractive$default(Project project2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        TelepresenceInstallActionKt.downloadAndInstallTelepresenceInteractive(project2, bl);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object downloadAndInstallTelepresence(@NotNull Project var0, @NotNull Continuation<? super InstallationResult> var1_1) {
        block11: {
            if (!(var1_1 instanceof downloadAndInstallTelepresence.1)) ** GOTO lbl-1000
            var6_2 = var1_1;
            if ((var6_2.label & -2147483648) != 0) {
                var6_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(var1_1){
                    /* synthetic */ Object result;
                    int label;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return TelepresenceInstallActionKt.downloadAndInstallTelepresence(null, (Continuation<? super InstallationResult>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    KubernetesUsageTriggerCollector.INSTANCE.getTELEPRESENCE_ACTION_TRIGGERED_EVENT().log(project, (Object)"telepresence-install");
                    if (!SystemInfoRt.isWindows) break;
                    windowsDownloadUrl = "https://www.telepresence.io/docs/latest/quick-start/?os=windows";
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(windowsDownloadUrl, null){
                        int label;
                        final /* synthetic */ String $windowsDownloadUrl;
                        {
                            this.$windowsDownloadUrl = $windowsDownloadUrl;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    Object[] objectArray = new Object[]{this.$windowsDownloadUrl};
                                    Messages.showInfoMessage((String)KubernetesBundle.message("dialog.Telepresence.install.suggest.win", objectArray), (String)KubernetesBundle.message("dialog.Telepresence.install.telepresence.not.installed", new Object[0]));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var7_4) {
                        return var7_4;
                    }
                    ** GOTO lbl23
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl23:
                    // 2 sources

                    return new FailedInstallation((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, downloadAndInstallTelepresence$lambda$0(), ()Ljava/lang/String;)());
                }
            }
            v1 = SystemInfoRt.isMac != false ? TelepresenceInstallActionKt.distributions.get("darwin") : (osDistribution = SystemInfoRt.isLinux != false ? TelepresenceInstallActionKt.distributions.get("linux") : null);
            if (osDistribution != null) break block11;
            $continuation.label = 2;
            v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
                int label;
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            KubernetesNotificationManager.Companion.getInstance(this.$project).reportRequestError(new IllegalStateException("Unable to find Telepresence distribution for platform: " + SystemInfoRt.OS_NAME));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (Continuation)$continuation);
            if (v2 == var7_4) {
                return var7_4;
            }
            ** GOTO lbl34
            {
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl34:
                    // 2 sources

                    return new FailedInstallation((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, downloadAndInstallTelepresence$lambda$1(), ()Ljava/lang/String;)());
                }
            }
        }
        archDistribution = CpuArch.isArm64() != false ? osDistribution.getArm64() : osDistribution.getAmd64();
        downloadUrl = archDistribution.getUrl();
        $continuation.label = 3;
        v3 = BinaryInstaller.Companion.create(project).withBinaryName((Function0<String>)((Function0)downloadAndInstallTelepresence.6.INSTANCE)).withDownloadUrl((Function1<? super BinaryInstaller.Configuration, String>)((Function1)new Function1<BinaryInstaller.Configuration, String>(downloadUrl){
            final /* synthetic */ String $downloadUrl;
            {
                this.$downloadUrl = $downloadUrl;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull BinaryInstaller.Configuration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$downloadUrl;
            }
        })).installSuspend((Continuation<? super InstallationResult>)$continuation);
        if (v3 == var7_4) {
            return var7_4;
        }
        ** GOTO lbl46
        {
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl46:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final String downloadAndInstallTelepresence$lambda$0() {
        return KubernetesBundle.message("dialog.Telepresence.install.telepresence.not.installed", new Object[0]);
    }

    private static final String downloadAndInstallTelepresence$lambda$1() {
        return KubernetesBundle.message("dialog.Telepresence.install.telepresence.not.installed", new Object[0]);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"darwin", (Object)new OSDistribution(new ArchDistribution("https://app.getambassador.io/download/tel2oss/releases/download/v2.19.0/telepresence-darwin-amd64", ""), new ArchDistribution("https://app.getambassador.io/download/tel2oss/releases/download/v2.19.0/telepresence-darwin-arm64", ""))), TuplesKt.to((Object)"linux", (Object)new OSDistribution(new ArchDistribution("https://app.getambassador.io/download/tel2oss/releases/download/v2.19.0/telepresence-linux-amd64", ""), new ArchDistribution("https://app.getambassador.io/download/tel2oss/releases/download/v2.19.0/telepresence-linux-amd64", "")))};
        distributions = MapsKt.mapOf((Pair[])pairArray);
    }
}

