/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.references;

import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.kubernetes.KubernetesResolver;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.references.KubernetesLabelValueReference;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018R)\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/kubernetes/references/LabelValueReference;", "Lcom/intellij/kubernetes/references/KubernetesLabelValueReference;", "Lcom/intellij/codeInsight/highlighting/HighlightedReference;", "Lcom/intellij/psi/PsiReferenceBase$Poly;", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "matchingLabelValue", "(Lorg/jetbrains/yaml/psi/YAMLScalar;)V", "label", "Lkotlin/Pair;", "", "getLabel", "()Lkotlin/Pair;", "label$delegate", "Lkotlin/Lazy;", "resolver", "Lcom/intellij/kubernetes/KubernetesResolver;", "getVariants", "", "", "()[Ljava/lang/Object;", "multiResolve", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "", "(Z)[Lcom/intellij/psi/ResolveResult;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nLabelValueReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LabelValueReference.kt\ncom/intellij/kubernetes/references/LabelValueReference\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,67:1\n31#2,2:68\n26#3:70\n26#3:77\n1549#4:71\n1620#4,3:72\n1549#4:78\n1620#4,3:79\n37#5,2:75\n37#5,2:82\n*S KotlinDebug\n*F\n+ 1 LabelValueReference.kt\ncom/intellij/kubernetes/references/LabelValueReference\n*L\n22#1:68,2\n30#1:70\n49#1:77\n33#1:71\n33#1:72,3\n52#1:78\n52#1:79,3\n44#1:75,2\n53#1:82,2\n*E\n"})
public final class LabelValueReference
extends PsiReferenceBase.Poly<YAMLScalar>
implements KubernetesLabelValueReference,
HighlightedReference {
    @NotNull
    private final KubernetesResolver resolver;
    @NotNull
    private final Lazy label$delegate;

    public LabelValueReference(@NotNull YAMLScalar matchingLabelValue) {
        Intrinsics.checkNotNullParameter((Object)matchingLabelValue, (String)"matchingLabelValue");
        super((PsiElement)matchingLabelValue, new TextRange(0, matchingLabelValue.getTextLength()), false);
        Project project2 = ((YAMLScalar)this.getElement()).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<KubernetesResolver> serviceClass$iv = KubernetesResolver.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.resolver = (KubernetesResolver)object;
        this.label$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pair<? extends String, ? extends String>>(this){
            final /* synthetic */ LabelValueReference this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Pair<String, String> invoke() {
                PsiElement psiElement = this.this$0.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
                Pair<String, String> pair = YamlUtilKt.getTypedAncestorOrSelf(psiElement, YAMLKeyValue.class);
                if (pair == null || (pair = YamlUtilKt.getEffectiveTextPair((YAMLKeyValue)pair)) == null) {
                    return null;
                }
                return pair;
            }
        }));
    }

    @Override
    @Nullable
    public Pair<String, String> getLabel() {
        Lazy lazy = this.label$delegate;
        return (Pair)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        void $this$mapTo$iv$iv;
        if (this.getLabel() == null) {
            boolean $i$f$emptyArray = false;
            return new ResolveResult[0];
        }
        PsiElement psiElement = this.getElement();
        Pair<String, String> pair = this.getLabel();
        Intrinsics.checkNotNull(pair);
        String string = (String)pair.getFirst();
        Pair<String, String> pair2 = this.getLabel();
        Intrinsics.checkNotNull(pair2);
        Iterable $this$map$iv = this.resolver.findTargetLabelDeclarationsForNavigation(psiElement, string, (String)pair2.getSecond());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ResolveResult((YAMLKeyValue)it){
                final /* synthetic */ YAMLKeyValue $it;
                {
                    this.$it = $it;
                }

                @Nullable
                public YAMLScalar getElement() {
                    YAMLValue yAMLValue = this.$it.getValue();
                    return yAMLValue instanceof YAMLScalar ? (YAMLScalar)yAMLValue : null;
                }

                public boolean isValidResult() {
                    return true;
                }
            });
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ResolveResult[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object[] getVariants() {
        void $this$mapTo$iv$iv;
        if (this.getLabel() == null) {
            boolean $i$f$emptyArray = false;
            return new Object[0];
        }
        PsiElement psiElement = this.getElement();
        Pair<String, String> pair = this.getLabel();
        Intrinsics.checkNotNull(pair);
        Iterable $this$map$iv = this.resolver.findTargetLabelDeclarationsForUsages(psiElement, (String)pair.getFirst(), null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(YamlUtilKt.getEffectiveValueText((YAMLKeyValue)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }
}

