/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.references;

import com.intellij.kubernetes.KubernetesLabelUtilKt;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.PatternsKt;
import com.intellij.kubernetes.references.LabelKeyReference;
import com.intellij.kubernetes.references.LabelValueReference;
import com.intellij.kubernetes.references.LabelValueSelfReference;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlReferenceType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/kubernetes/references/KubernetesReferenceContributor;", "Lcom/intellij/psi/PsiReferenceContributor;", "()V", "registerReferenceProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "intellij.clouds.kubernetes"})
public final class KubernetesReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        registrar.registerReferenceProvider((ElementPattern)PatternsKt.getK8sValuePattern(), new PsiReferenceProvider(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                PsiReference[] psiReferenceArray;
                YamlReferenceType yamlReferenceType;
                PsiReference[] psiReferenceArray2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (!(element instanceof YAMLScalar)) {
                    return new PsiReference[0];
                }
                if (KubernetesLabelUtilKt.getSelectorMatchLabel(element) != null) {
                    PsiReference[] psiReferenceArray3 = new PsiReference[]{new LabelValueReference((YAMLScalar)element)};
                    psiReferenceArray2 = psiReferenceArray3;
                    return psiReferenceArray2;
                }
                if (KubernetesLabelUtilKt.getObjectLabel(element) != null) {
                    PsiReference[] psiReferenceArray4 = new PsiReference[]{new LabelValueSelfReference((YAMLScalar)element)};
                    psiReferenceArray2 = psiReferenceArray4;
                    return psiReferenceArray2;
                }
                YAMLPsiElement $this$k8sMetaType$iv = (YAMLPsiElement)element;
                boolean $i$f$k8sMetaType = false;
                YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getK8sMetaTypeProxy($this$k8sMetaType$iv);
                Object object = metaTypeProxy != null ? metaTypeProxy.getMetaType() : null;
                if (!(object instanceof YamlReferenceType)) {
                    object = null;
                }
                if ((yamlReferenceType = (YamlReferenceType)((YamlMetaType)((YamlReferenceType)object))) != null && (psiReferenceArray = yamlReferenceType.getReferencesFromValue((YAMLScalar)element)) != null) {
                    void $this$filterTo$iv$iv;
                    PsiReference[] $this$filter$iv = psiReferenceArray;
                    boolean $i$f$filter = false;
                    PsiReference[] psiReferenceArray5 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    int n = ((void)$this$filterTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv;
                        void it = element$iv$iv = $this$filterTo$iv$iv[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getElement(), (Object)element)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    PsiReference[] psiReferenceArray6 = thisCollection$iv.toArray(new PsiReference[0]);
                    if (psiReferenceArray6 != null) {
                        psiReferenceArray2 = psiReferenceArray6;
                        return psiReferenceArray2;
                    }
                }
                boolean $i$f$emptyArray = false;
                psiReferenceArray2 = new PsiReference[]{};
                return psiReferenceArray2;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PatternsKt.getK8sKeyValuePattern(), new PsiReferenceProvider(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                YamlReferenceType $i$f$emptyArray2;
                PsiReference[] psiReferenceArray;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (!(element instanceof YAMLKeyValue)) {
                    return new PsiReference[0];
                }
                if (KubernetesLabelUtilKt.getObjectLabel(element) != null || KubernetesLabelUtilKt.getSelectorMatchLabel(element) != null) {
                    PsiReference[] $i$f$emptyArray2 = new PsiReference[]{new LabelKeyReference((YAMLKeyValue)element)};
                    psiReferenceArray = $i$f$emptyArray2;
                    return psiReferenceArray;
                }
                if (!(((YAMLKeyValue)element).getValue() instanceof YAMLScalar)) {
                    boolean $i$f$emptyArray3 = false;
                    psiReferenceArray = new PsiReference[]{};
                    return psiReferenceArray;
                }
                YAMLKeyValue $this$valueK8sMetaType$iv = (YAMLKeyValue)element;
                boolean $i$f$valueK8sMetaType = false;
                YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getValueK8sMetaTypeProxy($this$valueK8sMetaType$iv);
                Object object = metaTypeProxy != null ? metaTypeProxy.getMetaType() : null;
                if (!(object instanceof YamlReferenceType)) {
                    object = null;
                }
                if (($i$f$emptyArray2 = (YamlReferenceType)((YamlMetaType)((YamlReferenceType)object))) != null) {
                    YAMLValue yAMLValue = ((YAMLKeyValue)element).getValue();
                    Intrinsics.checkNotNull((Object)yAMLValue, (String)"null cannot be cast to non-null type org.jetbrains.yaml.psi.YAMLScalar");
                    PsiReference[] psiReferenceArray2 = $i$f$emptyArray2.getReferencesFromValue((YAMLScalar)yAMLValue);
                    if (psiReferenceArray2 != null) {
                        void $this$filterTo$iv$iv;
                        PsiReference[] $this$filter$iv = psiReferenceArray2;
                        boolean $i$f$filter = false;
                        PsiReference[] psiReferenceArray3 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        int n = ((void)$this$filterTo$iv$iv).length;
                        for (int i = 0; i < n; ++i) {
                            void element$iv$iv;
                            void it = element$iv$iv = $this$filterTo$iv$iv[i];
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getElement(), (Object)element)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        PsiReference[] psiReferenceArray4 = thisCollection$iv.toArray(new PsiReference[0]);
                        if (psiReferenceArray4 != null) {
                            psiReferenceArray = psiReferenceArray4;
                            return psiReferenceArray;
                        }
                    }
                }
                boolean $i$f$emptyArray4 = false;
                psiReferenceArray = new PsiReference[]{};
                return psiReferenceArray;
            }
        });
    }
}

