/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.references;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.kubernetes.KubernetesLabelUtilKt;
import com.intellij.kubernetes.KubernetesResolver;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.references.KubernetesLabelValueReference;
import com.intellij.kubernetes.references.KubernetesLabelValueRenameHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J/\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u001d2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J4\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010$\u001a\u00020\u000bH\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/kubernetes/references/KubernetesLabelValueRenameHandler;", "Lcom/intellij/refactoring/rename/RenameHandler;", "()V", "findUsages", "", "Lcom/intellij/usageView/UsageInfo;", "resolver", "Lcom/intellij/kubernetes/KubernetesResolver;", "contextElement", "Lcom/intellij/psi/PsiElement;", "labelName", "", "labelValue", "getLabelValueReference", "Lcom/intellij/kubernetes/references/KubernetesLabelValueReference;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getTargets", "", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "elements", "", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isAvailableOnDataContext", "", "rename", "targets", "usages", "newName", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesLabelValueRenameHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLabelValueRenameHandler.kt\ncom/intellij/kubernetes/references/KubernetesLabelValueRenameHandler\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n31#2,2:164\n31#2,2:183\n1549#3:166\n1620#3,3:167\n1603#3,9:185\n1855#3:194\n1856#3:196\n1612#3:197\n1855#3,2:198\n1855#3,2:200\n11383#4,9:170\n13309#4:179\n13310#4:181\n11392#4:182\n1#5:180\n1#5:195\n*S KotlinDebug\n*F\n+ 1 KubernetesLabelValueRenameHandler.kt\ncom/intellij/kubernetes/references/KubernetesLabelValueRenameHandler\n*L\n47#1:164,2\n141#1:183,2\n126#1:166\n126#1:167,3\n143#1:185,9\n143#1:194\n143#1:196\n143#1:197\n111#1:198,2\n117#1:200,2\n134#1:170,9\n134#1:179\n134#1:181\n134#1:182\n134#1:180\n143#1:195\n*E\n"})
public final class KubernetesLabelValueRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.getLabelValueReference(dataContext) != null;
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor, @Nullable PsiFile file2, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (dataContext == null) {
            return;
        }
        Collection<YAMLScalar> targets = this.getTargets(dataContext);
        if (targets.isEmpty()) {
            return;
        }
        YAMLScalar mainTarget = (YAMLScalar)CollectionsKt.first((Iterable)targets);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Pair<String, String> pair = KubernetesLabelUtilKt.getObjectLabel((PsiElement)mainTarget);
            if (pair == null) {
                return;
            }
            Pair<String, String> pair2 = pair;
            String labelName = (String)pair2.component1();
            String labelValue = (String)pair2.component2();
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<KubernetesResolver> serviceClass$iv = KubernetesResolver.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            List<UsageInfo> usages = this.findUsages((KubernetesResolver)object, (PsiElement)mainTarget, labelName, labelValue);
            Collection collection = usages;
            Object object2 = PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
            Intrinsics.checkNotNull((Object)object2);
            this.rename(project2, targets, collection, (String)object2);
            return;
        }
        new RenameDialog(project2, mainTarget, editor, targets, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ YAMLScalar $mainTarget;
            final /* synthetic */ Collection<YAMLScalar> $targets;
            final /* synthetic */ KubernetesLabelValueRenameHandler this$0;
            {
                this.$project = $project;
                this.$mainTarget = $mainTarget;
                this.$targets = $targets;
                this.this$0 = $receiver;
                super($project, (PsiElement)$mainTarget, null, $editor);
            }

            protected void createCheckboxes(@Nullable JPanel panel2, @Nullable GridBagConstraints gbConstraints) {
                super.createCheckboxes(panel2, gbConstraints);
                this.getCbSearchInComments().setVisible(false);
            }

            protected boolean isToSearchForTextOccurrencesForRename() {
                return false;
            }

            protected boolean isToSearchInCommentsForRename() {
                return false;
            }

            @NotNull
            protected String getFullName() {
                Pair<String, String> pair = KubernetesLabelUtilKt.getObjectLabel((PsiElement)this.$mainTarget);
                Intrinsics.checkNotNull(pair);
                String labelName = (String)pair.component1();
                Object[] objectArray = new Object[]{labelName};
                String string = KubernetesBundle.message("KubernetesLabelValueRenameHandler.full.name", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            protected void doAction() {
                Pair<String, String> pair = KubernetesLabelUtilKt.getObjectLabel((PsiElement)this.$mainTarget);
                if (pair == null) {
                    return;
                }
                Pair<String, String> pair2 = pair;
                String labelName = (String)pair2.component1();
                String labelValue = (String)pair2.component2();
                this.invokeRefactoring(new BaseRefactoringProcessor(this.$project, this.$targets, labelName, labelValue, this.this$0, this.$mainTarget, this){
                    @NotNull
                    private final KubernetesResolver resolver;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Collection<YAMLScalar> $targets;
                    final /* synthetic */ String $labelName;
                    final /* synthetic */ String $labelValue;
                    final /* synthetic */ KubernetesLabelValueRenameHandler this$0;
                    final /* synthetic */ YAMLScalar $mainTarget;
                    final /* synthetic */ invoke.1 this$1;
                    {
                        this.$project = $project;
                        this.$targets = $targets;
                        this.$labelName = $labelName;
                        this.$labelValue = $labelValue;
                        this.this$0 = $receiver;
                        this.$mainTarget = $mainTarget;
                        this.this$1 = $receiver2;
                        super($project);
                        ComponentManager $this$service$iv = (ComponentManager)$project;
                        boolean $i$f$service = false;
                        Class<KubernetesResolver> serviceClass$iv = KubernetesResolver.class;
                        Object object = $this$service$iv.getService(serviceClass$iv);
                        if (object == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        this.resolver = (KubernetesResolver)object;
                    }

                    @NotNull
                    public final KubernetesResolver getResolver() {
                        return this.resolver;
                    }

                    @NotNull
                    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
                        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
                        return new UsageViewDescriptor(this.$targets, this.$labelName, this.$labelValue){
                            final /* synthetic */ Collection<YAMLScalar> $targets;
                            final /* synthetic */ String $labelName;
                            final /* synthetic */ String $labelValue;
                            {
                                this.$targets = $targets;
                                this.$labelName = $labelName;
                                this.$labelValue = $labelValue;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public PsiElement[] getElements() {
                                void $this$mapTo$iv$iv;
                                Iterable $this$map$iv = this.$targets;
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    YAMLScalar yAMLScalar = (YAMLScalar)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(it);
                                }
                                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                return thisCollection$iv.toArray(new PsiElement[0]);
                            }

                            @NotNull
                            public String getProcessedElementsHeader() {
                                Object[] objectArray = new Object[]{this.$labelName, this.$labelValue};
                                String string = KubernetesBundle.message("KubernetesLabelValueRenameHandler.processed.elements.header", objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                return string;
                            }

                            @NotNull
                            public String getCodeReferencesText(int usagesCount, int filesCount) {
                                Object[] objectArray = new Object[]{usagesCount, filesCount};
                                String string = KubernetesBundle.message("KubernetesLabelValueRenameHandler.code.references.text", objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                return string;
                            }
                        };
                    }

                    @NotNull
                    protected UsageInfo[] findUsages() {
                        Collection $this$toTypedArray$iv = KubernetesLabelValueRenameHandler.access$findUsages(this.this$0, this.resolver, (PsiElement)this.$mainTarget, this.$labelName, this.$labelValue);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        return thisCollection$iv.toArray(new UsageInfo[0]);
                    }

                    protected void performRefactoring(@NotNull UsageInfo[] usages) {
                        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
                        Collection collection = ArraysKt.asList((Object[])usages);
                        String string = this.this$1.getNewName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNewName(...)");
                        KubernetesLabelValueRenameHandler.access$rename(this.this$0, this.$project, this.$targets, collection, string);
                    }

                    @NotNull
                    protected String getCommandName() {
                        String string = KubernetesBundle.message("KubernetesLabelValueRenameHandler.command.name", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        return string;
                    }
                });
                this.close(0);
            }
        }.show();
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
    }

    private final void rename(Project project2, Collection<? extends YAMLScalar> targets, Collection<? extends UsageInfo> usages, String newName) {
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> KubernetesLabelValueRenameHandler.rename$lambda$2(project2, usages, targets, newName));
    }

    /*
     * WARNING - void declaration
     */
    private final List<UsageInfo> findUsages(KubernetesResolver resolver, PsiElement contextElement, String labelName, String labelValue) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = resolver.findLabelReferrers(contextElement, labelName, labelValue);
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            YAMLValue yAMLValue = it.getValue();
            Intrinsics.checkNotNull((Object)yAMLValue);
            collection.add(new UsageInfo((PsiElement)yAMLValue, false));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<YAMLScalar> getTargets(DataContext dataContext) {
        Collection collection;
        KubernetesLabelValueReference kubernetesLabelValueReference = this.getLabelValueReference(dataContext);
        if (kubernetesLabelValueReference == null) {
            return CollectionsKt.emptyList();
        }
        KubernetesLabelValueReference ref = kubernetesLabelValueReference;
        if (ref instanceof PsiPolyVariantReference) {
            void $this$mapNotNullTo$iv$iv;
            ResolveResult[] resolveResultArray = ((PsiPolyVariantReference)ref).multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
            Object[] $this$mapNotNull$iv = resolveResultArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                YAMLScalar it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                ResolveResult it = (ResolveResult)element$iv$iv;
                boolean bl2 = false;
                PsiElement psiElement = it.getElement();
                if ((psiElement instanceof YAMLScalar ? (YAMLScalar)psiElement : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            collection = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        } else {
            List list2;
            YAMLScalar singleTarget;
            PsiElement $i$f$mapNotNull = ref.resolve();
            YAMLScalar yAMLScalar = singleTarget = $i$f$mapNotNull instanceof YAMLScalar ? (YAMLScalar)$i$f$mapNotNull : null;
            if (singleTarget != null) {
                Pair<String, String> objectLabel = KubernetesLabelUtilKt.getObjectLabel((PsiElement)singleTarget);
                if (objectLabel != null) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Project project2 = singleTarget.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                    Object $this$service$iv = (ComponentManager)project2;
                    boolean $i$f$service = false;
                    Class<KubernetesResolver> serviceClass$iv = KubernetesResolver.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    $this$service$iv = ((KubernetesResolver)object).findTargetLabelDeclarationsForUsages((PsiElement)singleTarget, (String)objectLabel.getFirst(), (String)objectLabel.getSecond());
                    boolean $i$f$mapNotNull2 = false;
                    serviceClass$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        YAMLScalar it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        YAMLKeyValue it = (YAMLKeyValue)element$iv$iv;
                        boolean bl4 = false;
                        YAMLValue yAMLValue = it.getValue();
                        if ((yAMLValue instanceof YAMLScalar ? (YAMLScalar)yAMLValue : null) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = CollectionsKt.emptyList();
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            collection = list2;
        }
        return collection;
    }

    private final KubernetesLabelValueReference getLabelValueReference(DataContext dataContext) {
        if (dataContext == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor2);
        return psiReference instanceof KubernetesLabelValueReference ? (KubernetesLabelValueReference)psiReference : null;
    }

    private static final void rename$lambda$2(Project $project, Collection $usages, Collection $targets, String $newName) {
        YAMLValue newVal;
        UsageInfo it;
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$usages, (String)"$usages");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Intrinsics.checkNotNullParameter((Object)$newName, (String)"$newName");
        YAMLElementGenerator gen = YAMLElementGenerator.getInstance((Project)$project);
        Iterable $this$forEach$iv = $usages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement psiElement;
            it = (UsageInfo)element$iv;
            boolean bl = false;
            if (it.getElement() == null) continue;
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement usageElement = psiElement;
            Intrinsics.checkNotNull((Object)gen.createYamlKeyValue("foo", $newName).getValue());
            usageElement.replace((PsiElement)newVal);
        }
        $this$forEach$iv = $targets;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (YAMLScalar)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)gen.createYamlKeyValue("foo", $newName).getValue());
            it.replace((PsiElement)newVal);
        }
    }

    public static final /* synthetic */ List access$findUsages(KubernetesLabelValueRenameHandler $this, KubernetesResolver resolver, PsiElement contextElement, String labelName, String labelValue) {
        return $this.findUsages(resolver, contextElement, labelName, labelValue);
    }

    public static final /* synthetic */ void access$rename(KubernetesLabelValueRenameHandler $this, Project project2, Collection targets, Collection usages, String newName) {
        $this.rename(project2, targets, usages, newName);
    }
}

