/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.GenericFileReferenceType;
import com.intellij.kubernetes.model.SchemaSpecInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/model/SimpleFileOrDirReferenceType;", "Lcom/intellij/kubernetes/model/GenericFileReferenceType;", "typeName", "", "specInfo", "Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "(Ljava/lang/String;Lcom/intellij/kubernetes/model/SchemaSpecInfo;)V", "validateScalarValue", "", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.kubernetes"})
public class SimpleFileOrDirReferenceType
extends GenericFileReferenceType {
    public SimpleFileOrDirReferenceType(@NotNull String typeName, @Nullable SchemaSpecInfo specInfo) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        super(typeName, specInfo);
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        VirtualFile targetFile;
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)scalarValue);
        VirtualFile virtualFile2 = virtualFile != null && (virtualFile = virtualFile.getParent()) != null ? virtualFile.findFileByRelativePath(YamlUtilKt.getEffectiveText((YAMLValue)scalarValue)) : (targetFile = null);
        if (targetFile == null) {
            holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message("KubernetesModelDefinition.file.or.dir.not.exist.error", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }
}

