/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.model.KubernetesModel;
import com.intellij.kubernetes.model.KubernetesResourceDefinition;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/model/ResourceMetatypeSupplier;", "Lorg/jetbrains/yaml/meta/model/Field$MetaTypeSupplier;", "()V", "defaultType", "Lcom/intellij/kubernetes/model/KubernetesResourceDefinition;", "getMainType", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "getSpecializedType", "element", "Lorg/jetbrains/yaml/psi/YAMLValue;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesResourceDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesResourceDefinitions.kt\ncom/intellij/kubernetes/model/ResourceMetatypeSupplier\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,460:1\n14#2:461\n*S KotlinDebug\n*F\n+ 1 KubernetesResourceDefinitions.kt\ncom/intellij/kubernetes/model/ResourceMetatypeSupplier\n*L\n60#1:461\n*E\n"})
public final class ResourceMetatypeSupplier
implements Field.MetaTypeSupplier {
    @NotNull
    private final KubernetesResourceDefinition defaultType = new KubernetesResourceDefinition("K8sResource", null);

    @NotNull
    public YamlMetaType getMainType() {
        return (YamlMetaType)this.defaultType;
    }

    @Nullable
    public YamlMetaType getSpecializedType(@NotNull YAMLValue element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project2 = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KubernetesModel kubernetesModel = KubernetesUtilKt.getK8sModel(project2);
        YAMLValue $this$asSafely$iv = element;
        boolean $i$f$asSafely = false;
        YAMLValue yAMLValue = $this$asSafely$iv;
        if (!(yAMLValue instanceof YAMLMapping)) {
            yAMLValue = null;
        }
        YAMLMapping yAMLMapping = (YAMLMapping)yAMLValue;
        if (yAMLMapping == null) {
            return null;
        }
        Field field = kubernetesModel.getResourceModel(yAMLMapping);
        return field != null ? field.getDefaultType() : null;
    }
}

