/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.ConstantsKt;
import com.intellij.kubernetes.model.EmbeddedSpecInfo;
import com.intellij.kubernetes.model.ExternalSpecInfo;
import com.intellij.kubernetes.model.KubernetesDocumentationModel;
import com.intellij.kubernetes.model.KubernetesModel;
import com.intellij.kubernetes.model.KubernetesModelSettings;
import com.intellij.kubernetes.model.KubernetesYamlModelBuilder;
import com.intellij.kubernetes.model.ModelData;
import com.intellij.kubernetes.model.ResourceIdentity;
import com.intellij.kubernetes.model.RootField;
import com.intellij.kubernetes.model.SchemaSpecInfo;
import com.intellij.kubernetes.model.openapi.GroupVersionKind;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLMapping;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u0000 R2\u00020\u0001:\u0003RSTB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010>\u001a\u00020\u000bH\u0002J\u001c\u0010?\u001a\u0004\u0018\u00010\u000b2\u0006\u0010@\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010>\u001a\u00020\u000bH\u0016J\u0012\u0010E\u001a\u0004\u0018\u00010\u00102\u0006\u0010F\u001a\u00020GH\u0016J\u0012\u0010H\u001a\u0004\u0018\u00010\u001e2\u0006\u0010I\u001a\u00020\u0010H\u0016J\u0012\u0010H\u001a\u0004\u0018\u00010\u001e2\u0006\u0010J\u001a\u00020KH\u0016J\u0012\u0010L\u001a\u0004\u0018\u00010\u001e2\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010M\u001a\u00020N2\u0006\u0010I\u001a\u00020\u0010H\u0016J\u001c\u0010O\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00100QH\u0002R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00148F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0016R\u001e\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060#R\u00020\u00000\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u00100%j\b\u0012\u0004\u0012\u00020\u0010`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020(X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u00101\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\u0018\u001a\u0004\b2\u0010\u0016R\u001a\u00104\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0016R\u0017\u00106\u001a\b\u0012\u0004\u0012\u00020\u00100\u00148F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0016R*\u00108\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e09j\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e`:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00148F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0016\u00a8\u0006U"}, d2={"Lcom/intellij/kubernetes/model/RegularKubernetesModel;", "Lcom/intellij/kubernetes/model/KubernetesModel;", "modelData", "Lcom/intellij/kubernetes/model/ModelData;", "modelId", "", "errorHandler", "Lcom/intellij/kubernetes/model/RegularKubernetesModel$ErrorHandler;", "(Lcom/intellij/kubernetes/model/ModelData;ILcom/intellij/kubernetes/model/RegularKubernetesModel$ErrorHandler;)V", "_groups", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "_versions", "allResourcesByApiVersion", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/kubernetes/model/ResourceIdentity;", "documentationModel", "Lcom/intellij/kubernetes/model/KubernetesDocumentationModel;", "editableFullApiVersions", "", "getEditableFullApiVersions", "()Ljava/util/Set;", "editableFullApiVersions$delegate", "Lkotlin/Lazy;", "editableResources", "getEditableResources", "fullApiVersions", "getFullApiVersions", "generalUndefined", "Lorg/jetbrains/yaml/meta/model/Field;", "groups", "getGroups", "kindsByApi", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/kubernetes/model/RegularKubernetesModel$KindsImpl;", "kustomizationResources", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "mainSpecInfo", "Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "getMainSpecInfo$annotations", "()V", "getMainSpecInfo", "()Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "metaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "getMetaTypeProvider", "()Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "nonEditableFullApiVersions", "getNonEditableFullApiVersions", "nonEditableFullApiVersions$delegate", "nonEditableResources", "getNonEditableResources", "resourceIds", "getResourceIds", "resourceModels", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "versions", "getVersions", "getAllKindNames", "apiVersion", "getDescription", "type", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "field", "getKinds", "Lcom/intellij/kubernetes/model/KubernetesModel$Kinds;", "getResourceId", "document", "Lorg/jetbrains/yaml/psi/YAMLDocument;", "getResourceModel", "resourceId", "mapping", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "getRoot", "isKustomizeResource", "", "toApiVersions", "keys", "", "Companion", "ErrorHandler", "KindsImpl", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesModel.kt\ncom/intellij/kubernetes/model/RegularKubernetesModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1855#2,2:232\n1549#2:234\n1620#2,3:235\n1549#2:240\n1620#2,3:241\n1549#2:244\n1620#2,3:245\n129#3:238\n1#4:239\n*S KotlinDebug\n*F\n+ 1 KubernetesModel.kt\ncom/intellij/kubernetes/model/RegularKubernetesModel\n*L\n162#1:232,2\n174#1:234\n174#1:235,3\n227#1:240\n227#1:241,3\n229#1:244\n229#1:245,3\n188#1:238\n*E\n"})
public final class RegularKubernetesModel
implements KubernetesModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int modelId;
    @NotNull
    private final HashMap<ResourceIdentity, Field> resourceModels;
    @NotNull
    private final Field generalUndefined;
    @NotNull
    private final MultiMap<String, ResourceIdentity> allResourcesByApiVersion;
    @NotNull
    private final HashSet<String> _versions;
    @NotNull
    private final HashSet<String> _groups;
    @NotNull
    private final SchemaSpecInfo mainSpecInfo;
    @NotNull
    private final Set<ResourceIdentity> editableResources;
    @NotNull
    private final Set<ResourceIdentity> nonEditableResources;
    @NotNull
    private final ArrayList<ResourceIdentity> kustomizationResources;
    @NotNull
    private final ConcurrentMap<String, KindsImpl> kindsByApi;
    @NotNull
    private final KubernetesDocumentationModel documentationModel;
    @NotNull
    private final Lazy editableFullApiVersions$delegate;
    @NotNull
    private final Lazy nonEditableFullApiVersions$delegate;
    @NotNull
    private final YamlMetaTypeProvider metaTypeProvider;
    @NotNull
    private static final ResourceIdentity _kustomizationResourceId = ResourceIdentity.Companion.create(new GroupVersionKind("kustomize.config.k8s.io", "v1beta1", "Kustomization"));
    @NotNull
    public static final String kustomizeConfigurationDefinition = "io.k8s.config.kustomize.Configuration";

    /*
     * WARNING - void declaration
     */
    private RegularKubernetesModel(ModelData modelData, int modelId, ErrorHandler errorHandler) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object element$iv2;
        this.modelId = modelId;
        this.resourceModels = new HashMap();
        this.allResourcesByApiVersion = new MultiMap();
        this._versions = new HashSet();
        this._groups = new HashSet();
        this.kustomizationResources = new ArrayList();
        this.kindsByApi = new ConcurrentHashMap();
        this.documentationModel = new KubernetesDocumentationModel();
        this.mainSpecInfo = ((ModelData.DefinitionInfo)CollectionsKt.first((Iterable)modelData.getMainSpecData().getDefinitions())).getSpecInfo();
        this.resourceModels.putAll(new KubernetesYamlModelBuilder(modelData, this.documentationModel, errorHandler).build());
        Field field = this.resourceModels.remove(ResourceIdentity.Companion.getUNDEFINED());
        Intrinsics.checkNotNull((Object)field);
        this.generalUndefined = field;
        this.generalUndefined.getDefaultType().setDisplayName(KubernetesBundle.message("KubernetesResourceKindType.validation.unknown.resource.kind", new Object[0]));
        Set<ResourceIdentity> set = this.resourceModels.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ResourceIdentity it = (ResourceIdentity)element$iv2;
            boolean bl = false;
            this.allResourcesByApiVersion.putValue((Object)it.getApiVersion(), (Object)it);
            this._versions.add(it.getVersion());
            this._groups.add(it.getGroup());
        }
        this.editableResources = CollectionsKt.intersect((Iterable)modelData.getEditableResources(), (Iterable)this.getResourceIds());
        this.nonEditableResources = CollectionsKt.subtract((Iterable)this.getResourceIds(), (Iterable)this.getEditableResources());
        ModelData.DefinitionInfo definitionInfo = modelData.getMergedDefinitions().get(kustomizeConfigurationDefinition);
        Intrinsics.checkNotNull((Object)definitionInfo);
        $this$forEach$iv = definitionInfo.getDefinition().getGroupVersionKinds();
        ResourceIdentity.Companion companion = ResourceIdentity.Companion;
        ArrayList<ResourceIdentity> arrayList = this.kustomizationResources;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            GroupVersionKind groupVersionKind = (GroupVersionKind)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(companion.create((GroupVersionKind)p0));
        }
        arrayList.addAll((List)destination$iv$iv);
        this.editableFullApiVersions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ RegularKubernetesModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<String> invoke() {
                return RegularKubernetesModel.access$toApiVersions(this.this$0, this.this$0.getEditableResources());
            }
        }));
        this.nonEditableFullApiVersions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ RegularKubernetesModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<String> invoke() {
                return CollectionsKt.subtract((Iterable)this.this$0.getFullApiVersions(), (Iterable)this.this$0.getEditableFullApiVersions());
            }
        }));
        this.metaTypeProvider = new YamlMetaTypeProvider(this::getRoot, () -> this.modelId);
    }

    @Override
    @NotNull
    public SchemaSpecInfo getMainSpecInfo() {
        return this.mainSpecInfo;
    }

    public static /* synthetic */ void getMainSpecInfo$annotations() {
    }

    @Override
    @NotNull
    public Set<ResourceIdentity> getEditableResources() {
        return this.editableResources;
    }

    @Override
    @NotNull
    public Set<ResourceIdentity> getNonEditableResources() {
        return this.nonEditableResources;
    }

    @Override
    @NotNull
    public Set<String> getEditableFullApiVersions() {
        Lazy lazy = this.editableFullApiVersions$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public Set<String> getNonEditableFullApiVersions() {
        Lazy lazy = this.nonEditableFullApiVersions$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public YamlMetaTypeProvider getMetaTypeProvider() {
        return this.metaTypeProvider;
    }

    private final Field getRoot(YAMLDocument document) {
        ResourceIdentity resourceIdentity = this.getResourceId(document);
        if (resourceIdentity == null) {
            Field field;
            boolean condition$iv = KubernetesUtilKt.isKubernetesYaml(document.getContainingFile());
            boolean $i$f$doIf = false;
            if (condition$iv) {
                boolean bl = false;
                field = this.generalUndefined;
            } else {
                field = null;
            }
            return field;
        }
        ResourceIdentity resourceId = resourceIdentity;
        Field field = this.getResourceModel(resourceId);
        if (field == null) {
            field = this.generalUndefined;
        }
        return field;
    }

    @Override
    @Nullable
    public Field getResourceModel(@NotNull YAMLMapping mapping) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        ResourceIdentity resourceIdentity = KubernetesUtilKt.getK8sResourceId(mapping);
        if (resourceIdentity == null) {
            return null;
        }
        Field field = this.getResourceModel(resourceIdentity);
        if (field == null) {
            field = this.generalUndefined;
        }
        return field;
    }

    @Override
    @Nullable
    public ResourceIdentity getResourceId(@NotNull YAMLDocument document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Object object = YamlUtilKt.getTopLevelMapping(document);
        if (object == null || (object = KubernetesUtilKt.getK8sResourceId(object)) == null) {
            ResourceIdentity resourceIdentity;
            ResourceIdentity it = resourceIdentity = _kustomizationResourceId;
            boolean bl = false;
            object = KubernetesUtilKt.isKustomizationVirtualFile(YamlUtilKt.getVfsFile((PsiElement)document)) ? resourceIdentity : null;
        }
        return object;
    }

    @NotNull
    public final Set<ResourceIdentity> getResourceIds() {
        Set<ResourceIdentity> set = this.resourceModels.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    @Override
    @Nullable
    public Field getResourceModel(@NotNull ResourceIdentity resourceId) {
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        return this.resourceModels.get(resourceId);
    }

    @Override
    @Nullable
    public KubernetesModel.Kinds getKinds(@NotNull String apiVersion) {
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        if (!this.allResourcesByApiVersion.containsKey((Object)apiVersion)) {
            return null;
        }
        return this.kindsByApi.computeIfAbsent(apiVersion, arg_0 -> RegularKubernetesModel.getKinds$lambda$3((Function1)new Function1<String, KindsImpl>(this){
            final /* synthetic */ RegularKubernetesModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final KindsImpl invoke(String it) {
                Intrinsics.checkNotNull((Object)it);
                return this.this$0.new KindsImpl(it);
            }
        }, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getDescription(@NotNull YamlMetaType type, @Nullable Field field) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KubernetesDocumentationModel kubernetesDocumentationModel = this.documentationModel;
        YamlMetaType yamlMetaType = type;
        Field field2 = field;
        if (field2 != null) {
            void it;
            Field field3;
            Field field4 = field3 = field2;
            YamlMetaType yamlMetaType2 = yamlMetaType;
            KubernetesDocumentationModel kubernetesDocumentationModel2 = kubernetesDocumentationModel;
            boolean bl = false;
            boolean bl2 = !(it instanceof RootField);
            kubernetesDocumentationModel = kubernetesDocumentationModel2;
            yamlMetaType = yamlMetaType2;
            object = bl2 ? field3 : null;
        } else {
            object = null;
        }
        return kubernetesDocumentationModel.getDescription(yamlMetaType, (Field)object);
    }

    @Override
    public boolean isKustomizeResource(@NotNull ResourceIdentity resourceId) {
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        return this.kustomizationResources.contains(resourceId);
    }

    @NotNull
    public final Set<String> getVersions() {
        return this._versions;
    }

    @NotNull
    public final Set<String> getGroups() {
        return this._groups;
    }

    @Override
    @NotNull
    public Set<String> getFullApiVersions() {
        Set set = this.allResourcesByApiVersion.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getAllKindNames(String apiVersion) {
        void $this$mapTo$iv$iv;
        Collection collection = this.allResourcesByApiVersion.get((Object)apiVersion);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceIdentity resourceIdentity = (ResourceIdentity)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getKind());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> toApiVersions(Collection<ResourceIdentity> keys) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = keys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceIdentity resourceIdentity = (ResourceIdentity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getApiVersion());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final KindsImpl getKinds$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (KindsImpl)$tmp0.invoke(p0);
    }

    public /* synthetic */ RegularKubernetesModel(ModelData modelData, int modelId, ErrorHandler errorHandler, DefaultConstructorMarker $constructor_marker) {
        this(modelData, modelId, errorHandler);
    }

    public static final /* synthetic */ Set access$toApiVersions(RegularKubernetesModel $this, Collection keys) {
        return $this.toApiVersions(keys);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ \u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00072\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kubernetes/model/RegularKubernetesModel$Companion;", "", "()V", "_kustomizationResourceId", "Lcom/intellij/kubernetes/model/ResourceIdentity;", "get_kustomizationResourceId$annotations", "kustomizeConfigurationDefinition", "", "load", "Lcom/intellij/kubernetes/model/RegularKubernetesModel;", "settings", "Lcom/intellij/kubernetes/model/KubernetesModelSettings;", "modelId", "", "errorHandler", "Lcom/intellij/kubernetes/model/RegularKubernetesModel$ErrorHandler;", "mainApiVersion", "externalSpecs", "", "Lcom/intellij/kubernetes/model/ExternalSpecInfo;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        @NotNull
        public final RegularKubernetesModel load(@NotNull String mainApiVersion, @NotNull List<ExternalSpecInfo> externalSpecs) {
            Intrinsics.checkNotNullParameter((Object)mainApiVersion, (String)"mainApiVersion");
            Intrinsics.checkNotNullParameter(externalSpecs, (String)"externalSpecs");
            return this.load(new KubernetesModelSettings(mainApiVersion, null, EmbeddedSpecInfo.Companion.getListOfCommonSpecs(ConstantsKt.getDEFAULT_KUSTOMIZE_VERSION()), externalSpecs), 0, null);
        }

        public static /* synthetic */ RegularKubernetesModel load$default(Companion companion, String string, List list2, int n, Object object) {
            if ((n & 2) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            return companion.load(string, list2);
        }

        @NotNull
        public final RegularKubernetesModel load(@NotNull KubernetesModelSettings settings2, int modelId, @Nullable ErrorHandler errorHandler) {
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            return new RegularKubernetesModel(ModelData.Companion.load(settings2, (Function2<? super ExternalSpecInfo, ? super Exception, Unit>)((Function2)new Function2<ExternalSpecInfo, Exception, Unit>(errorHandler){
                final /* synthetic */ ErrorHandler $errorHandler;
                {
                    this.$errorHandler = $errorHandler;
                    super(2);
                }

                public final void invoke(@NotNull ExternalSpecInfo specInfo, @NotNull Exception error) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)specInfo, (String)"specInfo");
                        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                        ErrorHandler errorHandler = this.$errorHandler;
                        if (errorHandler == null) break block0;
                        errorHandler.handleFileError(specInfo, error);
                    }
                }
            })), modelId, errorHandler, null);
        }

        private static /* synthetic */ void get_kustomizationResourceId$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH&J \u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000bH&J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\fH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/kubernetes/model/RegularKubernetesModel$ErrorHandler;", "", "handleFileError", "", "specInfo", "Lcom/intellij/kubernetes/model/ExternalSpecInfo;", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleGenericError", "typeName", "", "Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "message", "handleUnresolvedDefinition", "intellij.clouds.kubernetes"})
    public static interface ErrorHandler {
        public void handleFileError(@NotNull ExternalSpecInfo var1, @NotNull Exception var2);

        public void handleUnresolvedDefinition(@NotNull String var1, @NotNull SchemaSpecInfo var2);

        public void handleGenericError(@NotNull String var1, @NotNull SchemaSpecInfo var2, @NotNull String var3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/model/RegularKubernetesModel$KindsImpl;", "Lcom/intellij/kubernetes/model/KubernetesModel$Kinds;", "apiVersion", "", "(Lcom/intellij/kubernetes/model/RegularKubernetesModel;Ljava/lang/String;)V", "allKinds", "", "getAllKinds", "()Ljava/util/Set;", "deprecatedKinds", "", "getDeprecatedKinds", "()Ljava/util/Collection;", "nonEditableKinds", "getNonEditableKinds", "validKinds", "getValidKinds", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesModel.kt\ncom/intellij/kubernetes/model/RegularKubernetesModel$KindsImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n766#2:232\n857#2,2:233\n1549#2:235\n1620#2,3:236\n766#2:239\n857#2,2:240\n1549#2:242\n1620#2,3:243\n1549#2:246\n1620#2,3:247\n*S KotlinDebug\n*F\n+ 1 KubernetesModel.kt\ncom/intellij/kubernetes/model/RegularKubernetesModel$KindsImpl\n*L\n137#1:232\n137#1:233,2\n139#1:235\n139#1:236,3\n140#1:239\n140#1:240,2\n142#1:242\n142#1:243,3\n143#1:246\n143#1:247,3\n*E\n"})
    private final class KindsImpl
    implements KubernetesModel.Kinds {
        @NotNull
        private final Set<String> allKinds;
        @NotNull
        private final Collection<String> validKinds;
        @NotNull
        private final Collection<String> deprecatedKinds;
        @NotNull
        private final Collection<String> nonEditableKinds;

        /*
         * WARNING - void declaration
         */
        public KindsImpl(String apiVersion) {
            Iterable $this$mapTo$iv$iv;
            ResourceIdentity it;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            Object element$iv$iv2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            this.allKinds = RegularKubernetesModel.this.getAllKindNames(apiVersion);
            Collection collection2 = RegularKubernetesModel.this.allResourcesByApiVersion.get((Object)apiVersion);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
            Collection allApiResources = collection2;
            Iterable iterable = CollectionsKt.intersect((Iterable)allApiResources, (Iterable)RegularKubernetesModel.this.getEditableResources());
            RegularKubernetesModel regularKubernetesModel = RegularKubernetesModel.this;
            KindsImpl kindsImpl = this;
            boolean $i$f$filter22 = false;
            void var7_14 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                ResourceIdentity resourceId = (ResourceIdentity)element$iv$iv2;
                boolean bl = false;
                Field field = (Field)regularKubernetesModel.resourceModels.get(resourceId);
                if (!(!(field != null ? field.isDeprecated() : false))) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map22 = false;
            void $i$f$filter22 = $this$map$iv;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                element$iv$iv2 = (ResourceIdentity)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getKind());
            }
            kindsImpl.validKinds = (List)destination$iv$iv2;
            $this$map$iv = CollectionsKt.intersect((Iterable)allApiResources, (Iterable)SetsKt.plus(RegularKubernetesModel.this.getEditableResources(), (Iterable)RegularKubernetesModel.this.getNonEditableResources()));
            RegularKubernetesModel $i$f$map22 = RegularKubernetesModel.this;
            kindsImpl = this;
            boolean $i$f$filter32 = false;
            destination$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                ResourceIdentity resourceId = (ResourceIdentity)element$iv$iv2;
                boolean bl = false;
                Field field = (Field)$i$f$map22.resourceModels.get(resourceId);
                if (!(field != null ? field.isDeprecated() : false)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            Iterable $i$f$filter32 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                element$iv$iv2 = (ResourceIdentity)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getKind());
            }
            kindsImpl.deprecatedKinds = (List)destination$iv$iv2;
            $this$map$iv = CollectionsKt.intersect((Iterable)allApiResources, (Iterable)RegularKubernetesModel.this.getNonEditableResources());
            kindsImpl = this;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ResourceIdentity)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getKind());
            }
            kindsImpl.nonEditableKinds = (List)destination$iv$iv2;
        }

        @Override
        @NotNull
        public Set<String> getAllKinds() {
            return this.allKinds;
        }

        @Override
        @NotNull
        public Collection<String> getValidKinds() {
            return this.validKinds;
        }

        @Override
        @NotNull
        public Collection<String> getDeprecatedKinds() {
            return this.deprecatedKinds;
        }

        @Override
        @NotNull
        public Collection<String> getNonEditableKinds() {
            return this.nonEditableKinds;
        }
    }
}

