/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.psi.PsiElement;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kubernetes/model/OpenApiSchemaPatternValidator;", "Lorg/jetbrains/yaml/meta/model/YamlScalarType;", "patternString", "", "(Ljava/lang/String;)V", "pattern", "Lkotlin/text/Regex;", "getPattern", "()Lkotlin/text/Regex;", "pattern$delegate", "Lkotlin/Lazy;", "validateScalarValue", "", "value", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "Companion", "intellij.clouds.kubernetes"})
public final class OpenApiSchemaPatternValidator
extends YamlScalarType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String patternString;
    @NotNull
    private final Lazy pattern$delegate;
    @NotNull
    private static final Regex allMatchingRegex = new Regex("[\\s\\S]*");

    public OpenApiSchemaPatternValidator(@NotNull String patternString) {
        Intrinsics.checkNotNullParameter((Object)patternString, (String)"patternString");
        super("pattern validator");
        this.patternString = patternString;
        this.pattern$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Regex>(this){
            final /* synthetic */ OpenApiSchemaPatternValidator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Regex invoke() {
                Regex regex;
                try {
                    regex = new Regex(OpenApiSchemaPatternValidator.access$getPatternString$p(this.this$0));
                }
                catch (Exception e) {
                    regex = OpenApiSchemaPatternValidator.access$getAllMatchingRegex$cp();
                }
                return regex;
            }
        }));
    }

    private final Regex getPattern() {
        Lazy lazy = this.pattern$delegate;
        return (Regex)lazy.getValue();
    }

    protected void validateScalarValue(@NotNull YAMLScalar value2, @NotNull ProblemsHolder holder) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            String string = YamlUtilKt.getAsStrictString(value2);
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            if (!this.getPattern().matches((CharSequence)it)) {
                Object[] objectArray = new Object[]{this.patternString};
                holder.registerProblem((PsiElement)value2, KubernetesBundle.message("KubernetesModelDefinition.value.should.match.error", objectArray), new LocalQuickFix[0]);
            }
        }
    }

    public static final /* synthetic */ String access$getPatternString$p(OpenApiSchemaPatternValidator $this) {
        return $this.patternString;
    }

    public static final /* synthetic */ Regex access$getAllMatchingRegex$cp() {
        return allMatchingRegex;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/kubernetes/model/OpenApiSchemaPatternValidator$Companion;", "", "()V", "allMatchingRegex", "Lkotlin/text/Regex;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

