/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.KubernetesBasicDefinitionsKt;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/model/OpenApiSchemaMinimumValidator;", "Lorg/jetbrains/yaml/meta/model/YamlScalarType;", "minimum", "", "exclusiveMinimum", "", "(FZ)V", "validateScalarValue", "", "value", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.kubernetes"})
public final class OpenApiSchemaMinimumValidator
extends YamlScalarType {
    private final float minimum;
    private final boolean exclusiveMinimum;

    public OpenApiSchemaMinimumValidator(float minimum, boolean exclusiveMinimum) {
        super("minimum validator");
        this.minimum = minimum;
        this.exclusiveMinimum = exclusiveMinimum;
    }

    protected void validateScalarValue(@NotNull YAMLScalar value2, @NotNull ProblemsHolder holder) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Float f = YamlUtilKt.getAsFloat(value2);
        if (f == null) {
            return;
        }
        float numericValue = f.floatValue();
        if (numericValue < this.minimum) {
            objectArray = new Object[]{Float.valueOf(this.minimum)};
            holder.registerProblem((PsiElement)value2, KubernetesBundle.message("KubernetesModelDefinition.value.should.not.less.error", objectArray), new LocalQuickFix[0]);
        }
        if (this.exclusiveMinimum && KubernetesBasicDefinitionsKt.access$areEqual(numericValue, this.minimum)) {
            objectArray = new Object[]{Float.valueOf(this.minimum)};
            holder.registerProblem((PsiElement)value2, KubernetesBundle.message("KubernetesModelDefinition.value.should.not.less.or.equal.error", objectArray), new LocalQuickFix[0]);
        }
    }
}

