/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.werf;

import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.model.HelmValuePomTarget;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.kubernetes.helm.model.SimpleHelmObject;
import com.intellij.kubernetes.helm.model.SimpleHelmObjectWithChildren;
import com.intellij.kubernetes.helm.model.SimpleSearchableObject;
import com.intellij.kubernetes.helm.werf.WerfImageObject;
import com.intellij.kubernetes.helm.werf.WerfNameObject;
import com.intellij.kubernetes.helm.werf.WerfObjectKt;
import com.intellij.kubernetes.helm.werf.WerfTagObject;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/kubernetes/helm/werf/WerfObject;", "Lcom/intellij/kubernetes/helm/model/SimpleHelmObjectWithChildren;", "chart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "(Lcom/intellij/kubernetes/helm/chart/Chart;)V", "description", "", "getDescription", "()Ljava/lang/String;", "intellij.clouds.kubernetes"})
public final class WerfObject
extends SimpleHelmObjectWithChildren {
    @NotNull
    private final String description;

    public WerfObject(@NotNull Chart chart2) {
        Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
        Object[] objectArray = new SimpleHelmObject[8];
        Object object = new String[]{"name"};
        objectArray[0] = new WerfNameObject(new PathInChart(WerfObjectKt.access$getWERF_ROOT$p().append((String)object), chart2));
        Object[] objectArray2 = new String[]{"version"};
        object = new PathInChart(WerfObjectKt.access$getWERF_ROOT$p().append((String[])objectArray2), chart2);
        objectArray[1] = new SimpleSearchableObject((PathInChart)object){
            @NotNull
            private final String description;
            {
                this.description = "Version of the werf CLI util";
            }

            @Override
            @NotNull
            public String getDescription() {
                return this.description;
            }
        };
        objectArray2 = new String[]{"namespace"};
        object = new PathInChart(WerfObjectKt.access$getWERF_ROOT$p().append((String[])objectArray2), chart2);
        objectArray[2] = new SimpleSearchableObject((PathInChart)object){
            @NotNull
            private final String description;
            {
                this.description = "The namespace resources will be deployed in";
            }

            @Override
            @NotNull
            public String getDescription() {
                return this.description;
            }
        };
        objectArray2 = new String[]{"env"};
        object = new PathInChart(WerfObjectKt.access$getWERF_ROOT$p().append((String[])objectArray2), chart2);
        objectArray[3] = new SimpleSearchableObject((PathInChart)object){
            @NotNull
            private final String description;
            {
                this.description = "Name of a CI/CD environment used during the current deploy process";
            }

            @Override
            @NotNull
            public String getDescription() {
                return this.description;
            }
        };
        objectArray2 = new String[]{"repo"};
        object = new PathInChart(WerfObjectKt.access$getWERF_ROOT$p().append((String[])objectArray2), chart2);
        objectArray[4] = new SimpleSearchableObject((PathInChart)object){
            @NotNull
            private final String description;
            {
                this.description = "Container registry repo used during the current deploy process";
            }

            @Override
            @NotNull
            public String getDescription() {
                return this.description;
            }
        };
        objectArray[5] = new WerfImageObject(chart2);
        objectArray[6] = new WerfTagObject(chart2);
        objectArray2 = new SimpleHelmObject[2];
        Object[] objectArray3 = new SimpleSearchableObject[2];
        String[] stringArray = new String[]{"commit", "date", "human"};
        objectArray3[0] = new SimpleSearchableObject(new PathInChart(WerfObjectKt.access$getWERF_ROOT$p().append(stringArray), chart2));
        stringArray = new String[]{"commit", "date", "unix"};
        objectArray3[1] = new SimpleSearchableObject(new PathInChart(WerfObjectKt.access$getWERF_ROOT$p().append(stringArray), chart2));
        String[] stringArray2 = CollectionsKt.listOf((Object[])objectArray3);
        objectArray2[0] = new SimpleHelmObjectWithChildren(chart2, (List<? extends SimpleSearchableObject>)stringArray2){
            @NotNull
            private final PathInChart position;
            {
                String[] stringArray = new String[]{"commit", "date"};
                this.position = new PathInChart(WerfObjectKt.access$getWERF_ROOT$p().append(stringArray), $chart);
            }

            @Override
            @NotNull
            public Collection<PsiElement> getDeclarationElements() {
                PsiElement psiElement = PomService.convertToPsi((Project)this.position.getChart().getProject(), (PomTarget)((PomTarget)new HelmValuePomTarget(this.getName(), this.position, this.isRenameable())));
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"convertToPsi(...)");
                return CollectionsKt.listOf((Object)psiElement);
            }
        };
        stringArray2 = new String[]{"commit", "hash"};
        objectArray2[1] = new SimpleSearchableObject(new PathInChart(WerfObjectKt.access$getWERF_ROOT$p().append(stringArray2), chart2));
        object = CollectionsKt.listOf((Object[])objectArray2);
        objectArray[7] = new SimpleHelmObjectWithChildren(chart2, (List<? extends SimpleHelmObject>)object){
            @NotNull
            private final PathInChart position;
            @NotNull
            private final String description;
            {
                String[] stringArray = new String[]{"commit"};
                this.position = new PathInChart(WerfObjectKt.access$getWERF_ROOT$p().append(stringArray), $chart);
                this.description = "Info about commit from which werf was executed";
            }

            @Override
            @NotNull
            public String getDescription() {
                return this.description;
            }

            @Override
            @NotNull
            public Collection<PsiElement> getDeclarationElements() {
                PsiElement psiElement = PomService.convertToPsi((Project)this.position.getChart().getProject(), (PomTarget)((PomTarget)new HelmValuePomTarget(this.getName(), this.position, this.isRenameable())));
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"convertToPsi(...)");
                return CollectionsKt.listOf((Object)psiElement);
            }
        };
        super("werf", CollectionsKt.listOf((Object[])objectArray));
        this.description = "werf-backed fields";
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }
}

