/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.werf;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.CustomChartSupport;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.model.HelmObject;
import com.intellij.kubernetes.helm.model.HelmObjectMetaClass;
import com.intellij.kubernetes.helm.model.HelmResolveTarget;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.kubernetes.helm.model.SimpleHelmObject;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.kubernetes.helm.werf.GlobalWerfObject;
import com.intellij.kubernetes.helm.werf.WerfChartSupport;
import com.intellij.kubernetes.helm.werf.WerfChartSupportKt;
import com.intellij.kubernetes.helm.werf.WerfObject;
import com.intellij.kubernetes.helm.werf.WerfUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0015\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0018\u0012\u0004\u0012\u00020\u00190\u00170\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0012H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0012H\u0016R'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"Lcom/intellij/kubernetes/helm/werf/WerfChartSupport;", "Lcom/intellij/kubernetes/helm/CustomChartSupport;", "()V", "werfSchemas", "", "", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "getWerfSchemas", "()Ljava/util/Map;", "werfSchemas$delegate", "Lkotlin/Lazy;", "werfYamlProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "getWerfYamlProvider", "()Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "werfYamlProvider$delegate", "calculateWerfProjectName", "werfFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "collectObjects", "", "Lkotlin/Pair;", "", "Lcom/intellij/kubernetes/helm/model/HelmObject;", "chart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "getCustomChartInfo", "Lcom/intellij/kubernetes/helm/CustomChartSupport$CustomChartInfo;", "chartDirCandidate", "getMetaTypeProvider", "psiFile", "Lcom/intellij/psi/PsiFile;", "getResolveTarget", "Lcom/intellij/kubernetes/helm/model/HelmResolveTarget;", "pathInChart", "Lcom/intellij/kubernetes/helm/model/PathInChart;", "isValueContainer", "", "file", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nWerfChartSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WerfChartSupport.kt\ncom/intellij/kubernetes/helm/werf/WerfChartSupport\n+ 2 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n129#2:86\n129#2:87\n129#2:88\n129#2:89\n1#3:90\n*S KotlinDebug\n*F\n+ 1 WerfChartSupport.kt\ncom/intellij/kubernetes/helm/werf/WerfChartSupport\n*L\n22#1:86\n39#1:87\n53#1:88\n56#1:89\n*E\n"})
public final class WerfChartSupport
implements CustomChartSupport {
    @NotNull
    private final Lazy werfSchemas$delegate = LazyKt.lazy((Function0)werfSchemas.2.INSTANCE);
    @NotNull
    private final Lazy werfYamlProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<YamlMetaTypeProvider>(this){
        final /* synthetic */ WerfChartSupport this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final YamlMetaTypeProvider invoke() {
            return new YamlMetaTypeProvider(arg_0 -> werfYamlProvider.2.invoke$lambda$0(this.this$0, arg_0), werfYamlProvider.2::invoke$lambda$1);
        }

        private static final Field invoke$lambda$0(WerfChartSupport this$0, YAMLDocument it) {
            Field field;
            YAMLMapping topLevelMapping;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            YAMLMapping yAMLMapping = topLevelMapping = YamlUtilKt.getTopLevelMapping(it);
            if ((yAMLMapping != null ? yAMLMapping.getKeyValueByKey("project") : null) != null) {
                field = new Field("Meta", (YamlMetaType)new HelmObjectMetaClass("Meta", (Definition)MapsKt.getValue((Map)WerfChartSupport.access$getWerfSchemas(this$0), (Object)"Meta")));
            } else {
                YAMLMapping yAMLMapping2 = topLevelMapping;
                field = (yAMLMapping2 != null ? yAMLMapping2.getKeyValueByKey("image") : null) != null ? (topLevelMapping.getKeyValueByKey("dockerfile") != null ? new Field("Dockerfile", (YamlMetaType)new HelmObjectMetaClass("Dockerfile", (Definition)MapsKt.getValue((Map)WerfChartSupport.access$getWerfSchemas(this$0), (Object)"Dockerfile"))) : (topLevelMapping.getKeyValueByKey("from") != null ? new Field("Stapel", (YamlMetaType)new HelmObjectMetaClass("Stapel", (Definition)MapsKt.getValue((Map)WerfChartSupport.access$getWerfSchemas(this$0), (Object)"Stapel"))) : new Field("UnknownImage", (YamlMetaType)new HelmObjectMetaClass("UnknownImage", (Definition)MapsKt.getValue((Map)WerfChartSupport.access$getWerfSchemas(this$0), (Object)"UnknownImage"))))) : new Field("Unknown", (YamlMetaType)new HelmObjectMetaClass("Unknown", (Definition)MapsKt.getValue((Map)WerfChartSupport.access$getWerfSchemas(this$0), (Object)"Unknown")));
            }
            return field;
        }

        private static final long invoke$lambda$1() {
            return 0L;
        }
    }));

    @Override
    @Nullable
    public CustomChartSupport.CustomChartInfo getCustomChartInfo(@NotNull VirtualFile chartDirCandidate) {
        CustomChartSupport.CustomChartInfo customChartInfo2;
        Intrinsics.checkNotNullParameter((Object)chartDirCandidate, (String)"chartDirCandidate");
        boolean condition$iv = Intrinsics.areEqual((Object)chartDirCandidate.getName(), (Object)".helm");
        boolean $i$f$doIf = false;
        if (condition$iv) {
            boolean bl = false;
            customChartInfo2 = new CustomChartSupport.CustomChartInfo("werf", arg_0 -> WerfChartSupport.getCustomChartInfo$lambda$1$lambda$0(this, chartDirCandidate, arg_0));
        } else {
            customChartInfo2 = null;
        }
        return customChartInfo2;
    }

    @Override
    @NotNull
    public Collection<Pair<List<String>, HelmObject>> collectObjects(@NotNull Chart chart2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
        boolean condition$iv = WerfChartSupportKt.access$isWerf(chart2);
        boolean $i$f$doIf = false;
        if (condition$iv) {
            boolean bl = false;
            Object[] objectArray = new Pair[3];
            Object[] objectArray2 = new String[]{"Values", "werf"};
            objectArray[0] = TuplesKt.to((Object)CollectionsKt.listOf((Object[])objectArray2), (Object)new WerfObject(chart2));
            objectArray2 = new String[]{"Values", "global", "werf"};
            objectArray[1] = TuplesKt.to((Object)CollectionsKt.listOf((Object[])objectArray2), (Object)new GlobalWerfObject(chart2));
            objectArray2 = new String[]{"Values", "global", "env"};
            objectArray[2] = TuplesKt.to((Object)CollectionsKt.listOf((Object[])objectArray2), (Object)new SimpleHelmObject(){
                @NotNull
                private final String description;
                {
                    this.description = "Name of a CI/CD environment used during the current deploy process";
                }

                @NotNull
                public String getDescription() {
                    return this.description;
                }
            });
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list2 = null;
        }
        return list2 != null ? (Collection)list2 : (Collection)CollectionsKt.emptyList();
    }

    @Override
    public boolean isValueContainer(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return YamlUtilKt.isYamlWithName("werf", file2.getNameSequence());
    }

    @Override
    @Nullable
    public YamlMetaTypeProvider getMetaTypeProvider(@NotNull PsiFile psiFile) {
        YamlMetaTypeProvider yamlMetaTypeProvider;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)psiFile);
        boolean condition$iv = YamlUtilKt.isYamlWithName("werf", virtualFile != null ? virtualFile.getNameSequence() : null);
        boolean $i$f$doIf = false;
        if (condition$iv) {
            boolean bl = false;
            yamlMetaTypeProvider = this.getWerfYamlProvider();
        } else {
            yamlMetaTypeProvider = null;
        }
        return yamlMetaTypeProvider;
    }

    @Override
    @Nullable
    public HelmResolveTarget getResolveTarget(@NotNull PathInChart pathInChart) {
        HelmResolveTarget helmResolveTarget;
        Intrinsics.checkNotNullParameter((Object)pathInChart, (String)"pathInChart");
        boolean condition$iv = WerfChartSupportKt.access$isWerf(pathInChart.getChart()) && WerfUtilKt.isWerfImageNamePath(pathInChart.getObjectPath());
        boolean $i$f$doIf = false;
        if (condition$iv) {
            boolean bl = false;
            helmResolveTarget = WerfUtilKt.imageNameResolveTarget(pathInChart.getChart(), (String)CollectionsKt.last(pathInChart.getObjectPath().getFullPath()));
        } else {
            helmResolveTarget = null;
        }
        return helmResolveTarget;
    }

    private final Map<String, Definition> getWerfSchemas() {
        Lazy lazy = this.werfSchemas$delegate;
        return (Map)lazy.getValue();
    }

    private final YamlMetaTypeProvider getWerfYamlProvider() {
        Lazy lazy = this.werfYamlProvider$delegate;
        return (YamlMetaTypeProvider)lazy.getValue();
    }

    private final String calculateWerfProjectName(VirtualFile werfFile, Project project2) {
        Object object;
        block5: {
            VirtualFile virtualFile;
            block4: {
                Object object2;
                object = werfFile;
                if (object == null || (object = YamlUtilKt.getYamlPsi(object, project2)) == null || (object = WerfUtilKt.findWerfProjectName((YAMLFile)object)) == null || (object = YamlUtilKt.getEffectiveText((YAMLValue)object)) == null) break block4;
                Object p0 = object2 = object;
                boolean bl = false;
                object = ((CharSequence)p0).length() > 0 ? object2 : null;
                if (object != null) break block5;
            }
            if (((virtualFile = werfFile) != null && (virtualFile = virtualFile.getParent()) != null ? virtualFile.getName() : (object = null)) == null) {
                object = "werf";
            }
        }
        return object;
    }

    private static final Chart.Info getCustomChartInfo$lambda$1$lambda$0(WerfChartSupport this$0, VirtualFile $chartDirCandidate, Project it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$chartDirCandidate, (String)"$chartDirCandidate");
        VirtualFile virtualFile = $chartDirCandidate.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
        VirtualFile virtualFile2 = YamlUtilKt.findYamlWithName(virtualFile, "werf");
        Intrinsics.checkNotNull((Object)it);
        return new Chart.Info(this$0.calculateWerfProjectName(virtualFile2, it), "v2", "1.0.0", null, false);
    }

    public static final /* synthetic */ Map access$getWerfSchemas(WerfChartSupport $this) {
        return $this.getWerfSchemas();
    }
}

