/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.helm.model.HelmValuePomTarget;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.kubernetes.helm.model.SimpleHelmObject;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0014R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kubernetes/helm/model/SimpleSearchableObject;", "Lcom/intellij/kubernetes/helm/model/SimpleHelmObject;", "position", "Lcom/intellij/kubernetes/helm/model/PathInChart;", "(Lcom/intellij/kubernetes/helm/model/PathInChart;)V", "declarationElements", "", "Lcom/intellij/psi/PsiElement;", "getDeclarationElements", "()Ljava/util/Collection;", "getPosition", "()Lcom/intellij/kubernetes/helm/model/PathInChart;", "createPomTarget", "Lcom/intellij/kubernetes/helm/model/HelmValuePomTarget;", "intellij.clouds.kubernetes"})
public class SimpleSearchableObject
extends SimpleHelmObject {
    @NotNull
    private final PathInChart position;

    public SimpleSearchableObject(@NotNull PathInChart position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        String string = (String)CollectionsKt.lastOrNull(position.getObjectPath().getFullPath());
        if (string == null) {
            string = "<root>";
        }
        super(string);
        this.position = position;
    }

    @NotNull
    protected final PathInChart getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getDeclarationElements() {
        PsiElement psiElement = PomService.convertToPsi((Project)this.position.getChart().getProject(), (PomTarget)((PomTarget)this.createPomTarget()));
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"convertToPsi(...)");
        return CollectionsKt.listOf((Object)psiElement);
    }

    @NotNull
    protected HelmValuePomTarget createPomTarget() {
        return new HelmValuePomTarget(this.getName(), this.position, this.isRenameable());
    }
}

