/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.helm.model.DependenciesMetaClass;
import com.intellij.kubernetes.helm.model.DependenciesV1MetaClass;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/helm/model/DependenciesV1MetaClass;", "Lcom/intellij/kubernetes/helm/model/DependenciesMetaClass;", "def", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "(Lcom/intellij/kubernetes/helm/model/spec/Definition;)V", "validateKey", "", "keyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmMetaClassDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/DependenciesV1MetaClass\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,585:1\n31#2,2:586\n*S KotlinDebug\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/DependenciesV1MetaClass\n*L\n105#1:586,2\n*E\n"})
public final class DependenciesV1MetaClass
extends DependenciesMetaClass {
    public DependenciesV1MetaClass(@NotNull Definition def) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        super(def);
    }

    public void validateKey(@NotNull YAMLKeyValue keyValue, @NotNull ProblemsHolder problemsHolder) {
        Intrinsics.checkNotNullParameter((Object)keyValue, (String)"keyValue");
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        Project project2 = keyValue.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)keyValue);
        if (virtualFile == null) {
            return;
        }
        Chart chart2 = ((ChartManager)object).findChartByRelatedFile(virtualFile);
        if (chart2 == null) {
            return;
        }
        Chart chart3 = chart2;
        if (!Intrinsics.areEqual((Object)chart3.getModel().getApiVersion(), (Object)"v1")) {
            PsiElement psiElement = keyValue.getKey();
            Intrinsics.checkNotNull((Object)psiElement);
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new IntentionAndQuickFixAction(){

                @NotNull
                public String getName() {
                    String string = KubernetesBundle.message("HelmChartUnknownValuesInspection.move.dependencies.to.chart.yaml.quickfix.name", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    return this.getName();
                }

                @NotNull
                public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
                    return intentionPreviewInfo;
                }

                public void applyFix(@NotNull Project project2, @Nullable PsiFile file2, @Nullable Editor editor) {
                    block11: {
                        YAMLMapping targetTopLevelMapping;
                        VirtualFile virtualFile;
                        YAMLSequence dependencySequence;
                        YAMLMapping sourceDependenciesKeyVal;
                        YAMLFile reqYaml;
                        block10: {
                            block9: {
                                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                                ComponentManager $this$service$iv = (ComponentManager)project2;
                                boolean $i$f$service = false;
                                Class<ChartManager> serviceClass$iv = ChartManager.class;
                                Object object = $this$service$iv.getService(serviceClass$iv);
                                if (object == null) {
                                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                }
                                PsiFile psiFile = file2;
                                if (psiFile == null || (psiFile = YamlUtilKt.getVfsFile((PsiElement)psiFile)) == null) {
                                    return;
                                }
                                Chart chart2 = ((ChartManager)object).findChartByRelatedFile((VirtualFile)psiFile);
                                if (chart2 == null) {
                                    return;
                                }
                                Chart actualChart = chart2;
                                YAMLFile yAMLFile = file2 instanceof YAMLFile ? (YAMLFile)file2 : null;
                                if (yAMLFile == null) {
                                    return;
                                }
                                reqYaml = yAMLFile;
                                YAMLMapping yAMLMapping = YamlUtilKt.getTopLevelMapping(reqYaml);
                                if (yAMLMapping == null || (yAMLMapping = YamlUtilKt.getKeyValueByKeyIgnoreSpaces(yAMLMapping, "dependencies")) == null) {
                                    return;
                                }
                                sourceDependenciesKeyVal = yAMLMapping;
                                YAMLValue yAMLValue = sourceDependenciesKeyVal.getValue();
                                YAMLSequence yAMLSequence = yAMLValue instanceof YAMLSequence ? (YAMLSequence)yAMLValue : null;
                                if (yAMLSequence == null) {
                                    return;
                                }
                                dependencySequence = yAMLSequence;
                                virtualFile = actualChart.getChartFile();
                                if (virtualFile == null) break block9;
                                VirtualFile it = virtualFile;
                                boolean bl = false;
                                PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(it);
                                YAMLFile yAMLFile2 = psiFile2 instanceof YAMLFile ? (YAMLFile)psiFile2 : null;
                                virtualFile = yAMLFile2;
                                if (yAMLFile2 != null) break block10;
                            }
                            return;
                        }
                        VirtualFile chartYaml = virtualFile;
                        YAMLMapping yAMLMapping = targetTopLevelMapping = YamlUtilKt.getTopLevelMapping((YAMLFile)chartYaml);
                        YAMLKeyValue targetDependenciesKeyVal = yAMLMapping != null ? YamlUtilKt.getKeyValueByKeyIgnoreSpaces(yAMLMapping, "dependencies") : null;
                        YAMLElementGenerator generator = YAMLElementGenerator.getInstance((Project)project2);
                        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
                        WriteCommandAction.writeCommandAction((Project)project2).withName(this.getName()).compute(() -> validateKey.1.applyFix$lambda$8(codeStyleManager, targetDependenciesKeyVal, targetTopLevelMapping, (YAMLFile)chartYaml, dependencySequence, generator, (YAMLKeyValue)sourceDependenciesKeyVal, reqYaml));
                        YAMLMapping yAMLMapping2 = YamlUtilKt.getTopLevelMapping((YAMLFile)chartYaml);
                        if (yAMLMapping2 == null || (yAMLMapping2 = YamlUtilKt.getKeyValueByKeyIgnoreSpaces(yAMLMapping2, "dependencies")) == null) break block11;
                        PsiElement p0 = (PsiElement)yAMLMapping2;
                        boolean bl = false;
                        MiscUtilKt.openInEditor(p0);
                    }
                }

                private static final void applyFix$addEolIfNeeded(PsiElement $this$applyFix_u24addEolIfNeeded, YAMLElementGenerator generator) {
                    PsiElement it = $this$applyFix_u24addEolIfNeeded.getLastChild();
                    boolean bl = false;
                    boolean bl2 = it != null && !Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)YAMLTokenTypes.EOL);
                    if (bl2) {
                        $this$applyFix_u24addEolIfNeeded.add(generator.createEol());
                    }
                }

                private static final PsiElement applyFix$lambda$8$lambda$5(YAMLKeyValue $targetDependenciesKeyVal, YAMLMapping $targetTopLevelMapping, YAMLFile $chartYaml, YAMLSequence $dependencySequence, YAMLElementGenerator $generator, YAMLKeyValue $sourceDependenciesKeyVal) {
                    PsiElement psiElement;
                    Intrinsics.checkNotNullParameter((Object)$chartYaml, (String)"$chartYaml");
                    Intrinsics.checkNotNullParameter((Object)$dependencySequence, (String)"$dependencySequence");
                    Intrinsics.checkNotNullParameter((Object)$sourceDependenciesKeyVal, (String)"$sourceDependenciesKeyVal");
                    YAMLKeyValue yAMLKeyValue = $targetDependenciesKeyVal;
                    if (yAMLKeyValue != null) {
                        YAMLKeyValue $this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u242 = yAMLKeyValue;
                        boolean bl = false;
                        validateKey.1.applyFix$addEolIfNeeded((PsiElement)$this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u242, $generator);
                        psiElement = $this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u242.add((PsiElement)$dependencySequence);
                    } else {
                        YAMLMapping yAMLMapping = $targetTopLevelMapping;
                        if (yAMLMapping != null) {
                            YAMLMapping $this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u243 = yAMLMapping;
                            boolean bl = false;
                            validateKey.1.applyFix$addEolIfNeeded((PsiElement)$this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u243, $generator);
                            psiElement = $this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u243.add((PsiElement)$sourceDependenciesKeyVal);
                        } else {
                            YAMLDocument yAMLDocument;
                            List list2 = $chartYaml.getDocuments();
                            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDocuments(...)");
                            YAMLDocument yAMLDocument2 = (YAMLDocument)CollectionsKt.firstOrNull((List)list2);
                            if (yAMLDocument2 != null) {
                                YAMLDocument yAMLDocument3;
                                YAMLDocument $this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u244 = yAMLDocument3 = yAMLDocument2;
                                boolean bl = false;
                                validateKey.1.applyFix$addEolIfNeeded((PsiElement)$this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u244, $generator);
                                $this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u244.add((PsiElement)$sourceDependenciesKeyVal);
                                yAMLDocument = yAMLDocument3;
                            } else {
                                yAMLDocument = null;
                            }
                            psiElement = (PsiElement)yAMLDocument;
                        }
                    }
                    return psiElement;
                }

                private static final PsiElement applyFix$lambda$8(CodeStyleManager $codeStyleManager, YAMLKeyValue $targetDependenciesKeyVal, YAMLMapping $targetTopLevelMapping, YAMLFile $chartYaml, YAMLSequence $dependencySequence, YAMLElementGenerator $generator, YAMLKeyValue $sourceDependenciesKeyVal, YAMLFile $reqYaml) {
                    Intrinsics.checkNotNullParameter((Object)$chartYaml, (String)"$chartYaml");
                    Intrinsics.checkNotNullParameter((Object)$dependencySequence, (String)"$dependencySequence");
                    Intrinsics.checkNotNullParameter((Object)$sourceDependenciesKeyVal, (String)"$sourceDependenciesKeyVal");
                    Intrinsics.checkNotNullParameter((Object)$reqYaml, (String)"$reqYaml");
                    Object object = $codeStyleManager.performActionWithFormatterDisabled(() -> validateKey.1.applyFix$lambda$8$lambda$5($targetDependenciesKeyVal, $targetTopLevelMapping, $chartYaml, $dependencySequence, $generator, $sourceDependenciesKeyVal));
                    PsiElement addedElement = (PsiElement)object;
                    boolean bl = false;
                    if (addedElement != null) {
                        YAMLKeyValue yAMLKeyValue = YamlUtilKt.getTypedAncestorOrSelf(addedElement, YAMLKeyValue.class);
                        if (yAMLKeyValue != null) {
                            YAMLKeyValue it = yAMLKeyValue;
                            boolean bl2 = false;
                            $codeStyleManager.reformat((PsiElement)it, true);
                        }
                    }
                    $reqYaml.delete();
                    return (PsiElement)object;
                }
            }};
            problemsHolder.registerProblem(psiElement, KubernetesBundle.message("HelmChartUnknownValuesInspection.requirements.no.longer.used.message", new Object[0]), ProblemHighlightType.WARNING, localQuickFixArray);
        }
    }
}

