/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.model.ChartPointingObject;
import com.intellij.kubernetes.helm.model.ChartPomTarget;
import com.intellij.kubernetes.helm.model.HelmObject;
import com.intellij.kubernetes.helm.model.HelmResolveUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001a\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b#\u0010\f\u00a8\u0006)"}, d2={"Lcom/intellij/kubernetes/helm/model/ChartObject;", "Lcom/intellij/kubernetes/helm/model/HelmObject;", "Lcom/intellij/kubernetes/helm/model/ChartPointingObject;", "chart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "(Lcom/intellij/kubernetes/helm/chart/Chart;)V", "getChart", "()Lcom/intellij/kubernetes/helm/chart/Chart;", "declarationElements", "", "Lcom/intellij/psi/PsiElement;", "getDeclarationElements", "()Ljava/util/Collection;", "description", "", "getDescription", "()Ljava/lang/String;", "isDeprecated", "", "()Z", "isFunction", "isOverridable", "isRenameable", "isRequired", "mustHaveValueDefinition", "getMustHaveValueDefinition", "name", "getName", "names", "", "getNames", "()Ljava/util/Set;", "project", "Lcom/intellij/openapi/project/Project;", "secondaryElements", "getSecondaryElements", "secondaryElements$delegate", "Lkotlin/Lazy;", "findChartNameKeyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "findChildObject", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nChartObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartObject.kt\ncom/intellij/kubernetes/helm/model/ChartObject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1#2:60\n288#3,2:61\n*S KotlinDebug\n*F\n+ 1 ChartObject.kt\ncom/intellij/kubernetes/helm/model/ChartObject\n*L\n54#1:61,2\n*E\n"})
public final class ChartObject
implements HelmObject,
ChartPointingObject {
    @NotNull
    private final Chart chart;
    private final boolean isFunction;
    private final boolean isDeprecated;
    private final boolean isOverridable;
    private final boolean isRequired;
    private final boolean mustHaveValueDefinition;
    @NotNull
    private final Project project;
    @NotNull
    private final Collection<PsiElement> declarationElements;
    @NotNull
    private final Lazy secondaryElements$delegate;
    private final boolean isRenameable;
    @NotNull
    private final Set<String> names;

    public ChartObject(@NotNull Chart chart2) {
        Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
        this.chart = chart2;
        this.project = this.getChart().getProject();
        PsiElement psiElement = PomService.convertToPsi((Project)this.project, (PomTarget)((PomTarget)new ChartPomTarget(this.getChart().getName(), HelmResolveUtilKt.getRootPathInChart(this.getChart()), this.getChart())));
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"convertToPsi(...)");
        this.declarationElements = CollectionsKt.listOf((Object)psiElement);
        this.secondaryElements$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends NavigatablePsiElement>>(this){
            final /* synthetic */ ChartObject this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final List<NavigatablePsiElement> invoke() {
                Object object;
                List list2;
                Object object2;
                YAMLValue chartNameElement;
                block5: {
                    Iterator<T> iterator;
                    Collection destination$iv$iv;
                    block4: {
                        block3: {
                            void $this$mapNotNullTo$iv$iv;
                            void $this$mapNotNull$iv;
                            YAMLKeyValue yAMLKeyValue = ChartObject.access$findChartNameKeyValue(this.this$0, ChartObject.access$getProject$p(this.this$0), this.this$0.getChart());
                            chartNameElement = yAMLKeyValue != null ? yAMLKeyValue.getValue() : null;
                            Chart chart2 = this.this$0.getChart().getSuperChart();
                            if (chart2 == null) break block3;
                            Chart.Info info2 = this.this$0.getChart().getInfo();
                            Collection<Chart.Dependency> collection = chart2.getDependenciesByChartNameAndVersion(this.this$0.getChart().getName(), info2 != null ? info2.getVersion() : null);
                            if (collection == null) break block3;
                            object2 = collection;
                            boolean bl = false;
                            void var8_8 = $this$mapNotNull$iv;
                            destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            iterator = $this$forEach$iv$iv$iv.iterator();
                            break block4;
                        }
                        list2 = CollectionsKt.emptyList();
                        break block5;
                    }
                    while (iterator.hasNext()) {
                        YAMLValue it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        Chart.Dependency it = (Chart.Dependency)element$iv$iv;
                        boolean bl2 = false;
                        YAMLMapping yAMLMapping = it.getElement();
                        if ((yAMLMapping != null ? YamlUtilKt.get(yAMLMapping, "name") : null) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list2 = (List)destination$iv$iv;
                }
                List dependencyNameElements = list2;
                PsiDirectory psiDirectory = PsiManager.getInstance((Project)ChartObject.access$getProject$p(this.this$0)).findDirectory(this.this$0.getChart().getBaseDir());
                if (psiDirectory != null) {
                    PsiDirectory psiDirectory2 = psiDirectory;
                    object2 = this.this$0;
                    PsiDirectory psiDirectory3 = psiDirectory2;
                    boolean bl = false;
                    object = Comparing.equal((CharSequence)((ChartObject)object2).getChart().getBaseDir().getNameSequence(), (CharSequence)((ChartObject)object2).getChart().getName()) ? psiDirectory2 : null;
                } else {
                    object = null;
                }
                PsiDirectory chartDirectoryElement = object;
                return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)chartNameElement), (Iterable)dependencyNameElements), (Iterable)CollectionsKt.listOfNotNull(chartDirectoryElement));
            }
        }));
        this.isRenameable = !this.getChart().isDownloaded();
        this.names = this.getChart().getDependencies().keySet();
    }

    @Override
    @NotNull
    public Chart getChart() {
        return this.chart;
    }

    @Override
    @NotNull
    public String getName() {
        return this.getChart().getName();
    }

    @Override
    public boolean isFunction() {
        return this.isFunction;
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    @Override
    public boolean isOverridable() {
        return this.isOverridable;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public boolean getMustHaveValueDefinition() {
        return this.mustHaveValueDefinition;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getDeclarationElements() {
        return this.declarationElements;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getSecondaryElements() {
        Lazy lazy = this.secondaryElements$delegate;
        return (Collection)lazy.getValue();
    }

    @Override
    public boolean isRenameable() {
        return this.isRenameable;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Chart \"" + this.getName() + "\"";
    }

    @Override
    @NotNull
    public Set<String> getNames() {
        return this.names;
    }

    @Override
    @Nullable
    public ChartObject findChildObject(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return null;
    }

    private final YAMLKeyValue findChartNameKeyValue(Project project2, Chart chart2) {
        Object v3;
        block4: {
            VirtualFile virtualFile;
            block6: {
                block5: {
                    virtualFile = chart2.getChartFile();
                    if (virtualFile == null) break block5;
                    VirtualFile it = virtualFile;
                    boolean bl = false;
                    PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(it);
                    YAMLFile yAMLFile = psiFile instanceof YAMLFile ? (YAMLFile)psiFile : null;
                    virtualFile = yAMLFile;
                    if (yAMLFile != null) break block6;
                }
                return null;
            }
            VirtualFile chartYamlFile = virtualFile;
            Collection collection = YAMLUtil.getTopLevelKeys((YAMLFile)chartYamlFile);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getTopLevelKeys(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                YAMLKeyValue it = (YAMLKeyValue)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Intrinsics.areEqual((Object)YamlUtilKt.getEffectiveKeyText(it), (Object)"name")) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        return v3;
    }

    public static final /* synthetic */ YAMLKeyValue access$findChartNameKeyValue(ChartObject $this, Project project2, Chart chart2) {
        return $this.findChartNameKeyValue(project2, chart2);
    }

    public static final /* synthetic */ Project access$getProject$p(ChartObject $this) {
        return $this.project;
    }
}

