/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.gotpl.model;

import com.goide.template.GoTemplateLanguage;
import com.goide.template.GoTemplateTypes;
import com.goide.template.psi.GoTemplateDefineStatement;
import com.goide.template.psi.GoTemplateFieldChainExpr;
import com.goide.template.psi.GoTemplateFile;
import com.goide.template.psi.GoTemplateLiteral;
import com.goide.template.psi.GoTemplateStringLiteral;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.helm.gotpl.GoTemplateUtilKt;
import com.intellij.kubernetes.helm.gotpl.model.HelmGoTemplateResolver;
import com.intellij.kubernetes.helm.gotpl.model.ObjectPathUtilKt;
import com.intellij.kubernetes.helm.model.HelmObject;
import com.intellij.kubernetes.helm.model.HelmResolver;
import com.intellij.kubernetes.helm.model.ObjectPath;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.kubernetes.helm.model.SchemaBasedObject;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.model.search.LeafOccurrence;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 +2\u00020\u0001:\u0002+,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\tJ\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\tJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\b2\u0006\u0010\u001b\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020\u001dJ.\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\b2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001dH\u0002J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020$0\b2\u0006\u0010\u001b\u001a\u00020\tJ\u0010\u0010)\u001a\u0004\u0018\u00010\u00152\u0006\u0010*\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/kubernetes/helm/gotpl/model/HelmGoTemplateResolver;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "resolver", "Lcom/intellij/kubernetes/helm/model/HelmResolver;", "collectUsages", "", "Lcom/intellij/psi/PsiElement;", "pathInChart", "Lcom/intellij/kubernetes/helm/model/PathInChart;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "dispose", "", "extractIdentifier", "element", "findTemplateUsages", "Lcom/goide/template/psi/GoTemplateStringLiteral;", "definition", "Lcom/goide/template/psi/GoTemplateDefineStatement;", "scope", "getAllTemplateDefinitions", "chart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "getPathInChartByGoTemplateReference", "refElement", "isInScope", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "renameUsage", "newName", "", "resolveObjectsByReference", "Lcom/intellij/kubernetes/helm/model/HelmObject;", "onlyNavigatable", "takeParent", "stopOnFirst", "resolveParentObjectsByReference", "resolveTemplateDefinitionByReference", "ref", "Companion", "UsageHandler", "intellij.clouds.kubernetes.charts.gotpl"})
@SourceDebugExtension(value={"SMAP\nHelmGoTemplateResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmGoTemplateResolver.kt\ncom/intellij/kubernetes/helm/gotpl/model/HelmGoTemplateResolver\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n*L\n1#1,219:1\n31#2,2:220\n31#2,2:224\n31#2,2:226\n1#3:222\n53#4:223\n*S KotlinDebug\n*F\n+ 1 HelmGoTemplateResolver.kt\ncom/intellij/kubernetes/helm/gotpl/model/HelmGoTemplateResolver\n*L\n29#1:220,2\n87#1:224,2\n132#1:226,2\n66#1:223\n*E\n"})
public final class HelmGoTemplateResolver
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final HelmResolver resolver;

    public HelmGoTemplateResolver(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<HelmResolver> serviceClass$iv = HelmResolver.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.resolver = (HelmResolver)object;
    }

    @NotNull
    public final Collection<HelmObject> resolveParentObjectsByReference(@NotNull PsiElement refElement) {
        Intrinsics.checkNotNullParameter((Object)refElement, (String)"refElement");
        return this.resolveObjectsByReference(refElement, true, false, false);
    }

    @NotNull
    public final Collection<HelmObject> resolveObjectsByReference(@NotNull PsiElement refElement, boolean onlyNavigatable) {
        Intrinsics.checkNotNullParameter((Object)refElement, (String)"refElement");
        return this.resolveObjectsByReference(refElement, false, true, onlyNavigatable);
    }

    public static /* synthetic */ Collection resolveObjectsByReference$default(HelmGoTemplateResolver helmGoTemplateResolver, PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return helmGoTemplateResolver.resolveObjectsByReference(psiElement, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Collection<HelmObject> resolveObjectsByReference(PsiElement refElement, boolean takeParent, boolean stopOnFirst, boolean onlyNavigatable) {
        ObjectPath objectPath;
        if (!Intrinsics.areEqual((Object)refElement.getProject(), (Object)this.project)) {
            return CollectionsKt.emptyList();
        }
        Chart chart2 = Chart.Companion.getChartByTemplateElement(refElement);
        if (chart2 == null) {
            return CollectionsKt.emptyList();
        }
        Chart chart3 = chart2;
        if (GoTemplateUtilKt.isFunctionReference(refElement)) {
            Collection collection;
            HelmObject functionsRoot2 = HelmGoTemplateResolver.Companion.getFunctionsRoot(chart3);
            if (takeParent) {
                collection = CollectionsKt.listOf((Object)functionsRoot2);
                return collection;
            }
            Object object = this.extractIdentifier(refElement);
            if (object != null) {
                PsiElement it = object;
                boolean bl = false;
                String string = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                List list2 = CollectionsKt.listOfNotNull((Object)functionsRoot2.findChildObject(string));
                object = list2;
                if (list2 != null) {
                    collection = (Collection)object;
                    return collection;
                }
            }
            collection = CollectionsKt.emptyList();
            return collection;
        }
        GoTemplateFieldChainExpr goTemplateFieldChainExpr = GoTemplateUtilKt.getOwnerFieldChain(refElement);
        if (goTemplateFieldChainExpr == null) {
            return CollectionsKt.emptyList();
        }
        GoTemplateFieldChainExpr ownerFieldChain = goTemplateFieldChainExpr;
        ObjectPath $this$transformIf$iv = ObjectPathUtilKt.fromReference(ObjectPath.Companion, ownerFieldChain);
        boolean $i$f$transformIf = false;
        if (takeParent) {
            ObjectPath it = $this$transformIf$iv;
            boolean bl = false;
            objectPath = it.getParent();
            if (objectPath == null) {
                return CollectionsKt.emptyList();
            }
        } else {
            objectPath = $this$transformIf$iv;
        }
        ObjectPath objectPath2 = objectPath;
        return this.resolver.resolveByObjectPath(new PathInChart(objectPath2, chart3), onlyNavigatable, stopOnFirst);
    }

    @Nullable
    public final PathInChart getPathInChartByGoTemplateReference(@NotNull PsiElement refElement) {
        Intrinsics.checkNotNullParameter((Object)refElement, (String)"refElement");
        if (GoTemplateUtilKt.isFunctionReference(refElement)) {
            return null;
        }
        Chart chart2 = Chart.Companion.getChartByTemplateElement(refElement);
        if (chart2 == null) {
            return null;
        }
        Chart chart3 = chart2;
        GoTemplateFieldChainExpr goTemplateFieldChainExpr = GoTemplateUtilKt.getOwnerFieldChain(refElement);
        if (goTemplateFieldChainExpr == null) {
            return null;
        }
        GoTemplateFieldChainExpr ownerFieldChain = goTemplateFieldChainExpr;
        ObjectPath objectPath = ObjectPathUtilKt.fromReference(ObjectPath.Companion, ownerFieldChain);
        return new PathInChart(objectPath, chart3);
    }

    @Nullable
    public final GoTemplateDefineStatement resolveTemplateDefinitionByReference(@NotNull GoTemplateStringLiteral ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        if (!Intrinsics.areEqual((Object)ref.getProject(), (Object)this.project)) {
            return null;
        }
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Chart chart2 = ((ChartManager)object).findChartByTemplateElement((PsiElement)ref);
        if (chart2 == null) {
            return null;
        }
        Chart topChart = chart2.getTopmostChart();
        String templateName = GoTemplateUtilKt.getStringFromStringLiteral(ref);
        PsiManager psiManager = ref.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getManager(...)");
        PsiManager manager2 = psiManager;
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        Chart.Companion.forAllCharts(topChart, (Function1<? super Chart, Boolean>)((Function1)new Function1<Chart, Boolean>(manager2, (Ref.ObjectRef<GoTemplateDefineStatement>)result2, templateName){
            final /* synthetic */ PsiManager $manager;
            final /* synthetic */ Ref.ObjectRef<GoTemplateDefineStatement> $result;
            final /* synthetic */ String $templateName;
            {
                this.$manager = $manager;
                this.$result = $result;
                this.$templateName = $templateName;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull Chart chart2) {
                void $this$forEach$iv;
                Object object;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
                Iterable iterable = chart2.getAllTemplateFiles();
                Ref.ObjectRef<GoTemplateDefineStatement> objectRef = this.$manager;
                boolean $i$f$mapNotNull = false;
                void var5_6 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Object object2 = $this$forEach$iv$iv$iv.iterator();
                while (object2.hasNext()) {
                    GoTemplateFile it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = object2.next();
                    boolean bl = false;
                    VirtualFile it = (VirtualFile)element$iv$iv;
                    boolean bl2 = false;
                    object = objectRef.findFile(it);
                    if ((object instanceof GoTemplateFile ? (GoTemplateFile)object : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                objectRef = this.$result;
                String string = this.$templateName;
                boolean $i$f$forEach2 = false;
                for (T element$iv : $this$forEach$iv) {
                    GoTemplateDefineStatement definition;
                    Object v3;
                    block5: {
                        GoTemplateFile file2 = (GoTemplateFile)element$iv;
                        boolean bl = false;
                        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)file2), GoTemplateDefineStatement.class);
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
                        object2 = collection;
                        Iterator<T> iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            String string2;
                            T t = iterator.next();
                            GoTemplateDefineStatement statement = (GoTemplateDefineStatement)t;
                            boolean bl4 = false;
                            String string3 = string;
                            if (statement.getStringLiteral() != null) {
                                void it;
                                object = string3;
                                boolean bl5 = false;
                                Intrinsics.checkNotNull((Object)it);
                                string2 = GoTemplateUtilKt.getStringFromStringLiteral((GoTemplateStringLiteral)it);
                                string3 = object;
                            } else {
                                string2 = null;
                            }
                            if (!Intrinsics.areEqual((Object)string3, string2)) continue;
                            v3 = t;
                            break block5;
                        }
                        v3 = null;
                    }
                    if ((definition = (GoTemplateDefineStatement)v3) == null) continue;
                    objectRef.element = definition;
                    return false;
                }
                return true;
            }
        }));
        return (GoTemplateDefineStatement)result2.element;
    }

    @NotNull
    public final Collection<GoTemplateDefineStatement> getAllTemplateDefinitions(@NotNull Chart chart2) {
        Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
        ArrayList<GoTemplateDefineStatement> result2 = new ArrayList<GoTemplateDefineStatement>();
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        Chart.Companion.forAllCharts(chart2.getTopmostChart(), (Function1<? super Chart, Boolean>)((Function1)new Function1<Chart, Boolean>(psiManager2, result2){
            final /* synthetic */ PsiManager $psiManager;
            final /* synthetic */ ArrayList<GoTemplateDefineStatement> $result;
            {
                this.$psiManager = $psiManager;
                this.$result = $result;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull Chart currentChart) {
                void $this$forEach$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter((Object)currentChart, (String)"currentChart");
                Iterable iterable = currentChart.getAllTemplateFiles();
                Object object = this.$psiManager;
                boolean $i$f$mapNotNull = false;
                Iterator<T> iterator = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    GoTemplateFile it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    VirtualFile it = (VirtualFile)element$iv$iv;
                    boolean bl2 = false;
                    PsiFile psiFile = object.findFile(it);
                    if ((psiFile instanceof GoTemplateFile ? (GoTemplateFile)psiFile : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                object = this.$result;
                boolean $i$f$forEach2 = false;
                for (T element$iv : $this$forEach$iv) {
                    GoTemplateFile it = (GoTemplateFile)element$iv;
                    boolean bl = false;
                    Class[] classArray = new Class[]{GoTemplateDefineStatement.class};
                    ((ArrayList)object).addAll(PsiTreeUtil.collectElementsOfType((PsiElement)((PsiElement)it), (Class[])classArray));
                }
                return true;
            }
        }));
        return result2;
    }

    @NotNull
    public final Collection<GoTemplateStringLiteral> findTemplateUsages(@NotNull GoTemplateDefineStatement definition, @NotNull SearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        if (!Intrinsics.areEqual((Object)definition.getProject(), (Object)this.project)) {
            return CollectionsKt.emptyList();
        }
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Chart chart2 = ((ChartManager)object).findChartByTemplateElement((PsiElement)definition);
        if (chart2 == null) {
            return CollectionsKt.emptyList();
        }
        Chart topChart = chart2.getTopmostChart();
        GoTemplateStringLiteral goTemplateStringLiteral = definition.getStringLiteral();
        if (goTemplateStringLiteral == null) {
            return CollectionsKt.emptyList();
        }
        String templateName = GoTemplateUtilKt.getStringFromStringLiteral(goTemplateStringLiteral);
        ArrayList<GoTemplateStringLiteral> result2 = new ArrayList<GoTemplateStringLiteral>();
        Chart.Companion.forAllCharts(topChart, (Function1<? super Chart, Boolean>)((Function1)new Function1<Chart, Boolean>(this, scope2, definition, result2, templateName){
            final /* synthetic */ HelmGoTemplateResolver this$0;
            final /* synthetic */ SearchScope $scope;
            final /* synthetic */ GoTemplateDefineStatement $definition;
            final /* synthetic */ ArrayList<GoTemplateStringLiteral> $result;
            final /* synthetic */ String $templateName;
            {
                this.this$0 = $receiver;
                this.$scope = $scope;
                this.$definition = $definition;
                this.$result = $result;
                this.$templateName = $templateName;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull Chart chart2) {
                void $this$forEach$iv;
                Object element$iv$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Object element$iv$iv2;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
                Iterable iterable = chart2.getAllTemplateFiles();
                Object object = this.this$0;
                SearchScope searchScope = this.$scope;
                boolean $i$f$filter22 = false;
                Iterator<T> iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    VirtualFile it = (VirtualFile)element$iv$iv2;
                    boolean bl = false;
                    if (!HelmGoTemplateResolver.access$isInScope((HelmGoTemplateResolver)object, searchScope, it)) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                $this$filter$iv = (List)destination$iv$iv;
                object = this.$definition;
                boolean $i$f$mapNotNull = false;
                void $i$f$filter22 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                element$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
                while (element$iv$iv2.hasNext()) {
                    GoTemplateFile it$iv$iv;
                    E element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
                    boolean bl4 = false;
                    VirtualFile it = (VirtualFile)element$iv$iv3;
                    boolean bl2 = false;
                    PsiFile psiFile = object.getManager().findFile(it);
                    if ((psiFile instanceof GoTemplateFile ? (GoTemplateFile)psiFile : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv2;
                object = this.$result;
                String string = this.$templateName;
                boolean $i$f$forEach2 = false;
                for (T element$iv : $this$forEach$iv) {
                    void $this$filterTo$iv$iv2;
                    void $this$filter$iv2;
                    GoTemplateFile file2 = (GoTemplateFile)element$iv;
                    boolean bl = false;
                    Class[] element$iv$iv2 = new Class[]{GoTemplateStringLiteral.class};
                    Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)((PsiElement)file2), (Class[])element$iv$iv2);
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"collectElementsOfType(...)");
                    element$iv$iv$iv = collection;
                    Object object2 = object;
                    boolean $i$f$filter = false;
                    void bl4 = $this$filter$iv2;
                    Collection destination$iv$iv3 = new ArrayList<E>();
                    boolean $i$f$filterTo2 = false;
                    for (E element$iv$iv4 : $this$filterTo$iv$iv2) {
                        GoTemplateStringLiteral it = (GoTemplateStringLiteral)element$iv$iv4;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!(Intrinsics.areEqual((Object)string, (Object)GoTemplateUtilKt.getStringFromStringLiteral(it)) && GoTemplateUtilKt.isTemplateReference(it))) continue;
                        destination$iv$iv3.add(element$iv$iv4);
                    }
                    ((ArrayList)object2).addAll((List)destination$iv$iv3);
                }
                return true;
            }
        }));
        return result2;
    }

    @Nullable
    public final PsiElement extractIdentifier(@NotNull PsiElement element) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof GoTemplateLiteral) {
            object = ((GoTemplateLiteral)element).getIdentifier();
        } else if (psiElement instanceof GoTemplateFieldChainExpr) {
            object = ((GoTemplateFieldChainExpr)element).getIdentifier();
        } else {
            PsiElement psiElement2;
            PsiElement it = psiElement2 = element;
            boolean bl = false;
            object = GoTemplateUtilKt.isIdentifier(it) ? psiElement2 : null;
        }
        return object;
    }

    @NotNull
    public final Collection<PsiElement> collectUsages(@NotNull PathInChart pathInChart, @NotNull SearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)pathInChart, (String)"pathInChart");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Project project2 = pathInChart.getChart().getProject();
        SearchScope searchScope2 = GlobalSearchScope.filesScope((Project)project2, pathInChart.getChart().getAllTemplateFiles()).intersectWith(searchScope);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"intersectWith(...)");
        SearchScope effectiveScope = searchScope2;
        String string = (String)CollectionsKt.lastOrNull(pathInChart.getObjectPath().getFullPath());
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String word = string;
        Collection collection = SearchService.getInstance().searchWord(project2, word).inFilesWithLanguage(GoTemplateLanguage.INSTANCE).inScope(effectiveScope).inContexts(SearchContext.IN_CODE, new SearchContext[0]).caseSensitive(true).buildQuery(arg_0 -> HelmGoTemplateResolver.collectUsages$lambda$4(word, pathInChart, arg_0)).findAll();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findAll(...)");
        return collection;
    }

    public final void renameUsage(@NotNull PsiElement element, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        boolean bl = Intrinsics.areEqual((Object)element.getNode().getElementType(), (Object)GoTemplateTypes.IDENTIFIER);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Unknown element type: " + element;
            throw new AssertionError((Object)string);
        }
        element.replace(GoTemplateUtilKt.createGoTemplateIdentifier(this.project, newName));
    }

    private final boolean isInScope(SearchScope searchScope, VirtualFile file2) {
        return !(searchScope instanceof LocalSearchScope) || searchScope.contains(file2);
    }

    public void dispose() {
    }

    /*
     * Unable to fully structure code
     */
    private static final Collection collectUsages$lambda$4(String $word, PathInChart $pathInChart, LeafOccurrence leafOccurrence) {
        Intrinsics.checkNotNullParameter((Object)$word, (String)"$word");
        Intrinsics.checkNotNullParameter((Object)$pathInChart, (String)"$pathInChart");
        Intrinsics.checkNotNullParameter((Object)leafOccurrence, (String)"leafOccurrence");
        it = var3_3 = leafOccurrence.getStart();
        $i$a$-takeIf-HelmGoTemplateResolver$collectUsages$1$1 = false;
        if (!GoTemplateUtilKt.isIdentifier(it) || !(it.getParent() instanceof GoTemplateFieldChainExpr) || !StringUtil.equals((CharSequence)it.getText(), (CharSequence)$word)) ** GOTO lbl-1000
        v0 = $pathInChart.getObjectPath();
        v1 = it.getParent();
        Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type com.goide.template.psi.GoTemplateFieldChainExpr");
        if (v0.weaklyEquivalent(ObjectPathUtilKt.fromReference(ObjectPath.Companion, (GoTemplateFieldChainExpr)v1))) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        return CollectionsKt.listOfNotNull((Object)(v2 != false ? var3_3 : null));
    }

    public static final /* synthetic */ boolean access$isInScope(HelmGoTemplateResolver $this, SearchScope searchScope, VirtualFile file2) {
        return $this.isInScope(searchScope, file2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/helm/gotpl/model/HelmGoTemplateResolver$Companion;", "", "()V", "functionsRoot", "Lcom/intellij/kubernetes/helm/model/HelmObject;", "Lcom/intellij/kubernetes/helm/chart/Chart;", "getFunctionsRoot", "(Lcom/intellij/kubernetes/helm/chart/Chart;)Lcom/intellij/kubernetes/helm/model/HelmObject;", "getInstance", "Lcom/intellij/kubernetes/helm/gotpl/model/HelmGoTemplateResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.kubernetes.charts.gotpl"})
    @SourceDebugExtension(value={"SMAP\nHelmGoTemplateResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmGoTemplateResolver.kt\ncom/intellij/kubernetes/helm/gotpl/model/HelmGoTemplateResolver$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,219:1\n31#2,2:220\n*S KotlinDebug\n*F\n+ 1 HelmGoTemplateResolver.kt\ncom/intellij/kubernetes/helm/gotpl/model/HelmGoTemplateResolver$Companion\n*L\n197#1:220,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HelmGoTemplateResolver getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<HelmGoTemplateResolver> serviceClass$iv = HelmGoTemplateResolver.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (HelmGoTemplateResolver)object;
        }

        private final HelmObject getFunctionsRoot(Chart $this$functionsRoot) {
            return new HelmObject($this$functionsRoot){
                @NotNull
                private final String name;
                private final boolean isRequired;
                private final boolean isFunction;
                private final boolean isDeprecated;
                private final boolean isRenameable;
                private final boolean isOverridable;
                private final boolean mustHaveValueDefinition;
                @NotNull
                private final Map<String, HelmObject> functions;
                {
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    this.name = "<rootFunctions>";
                    Map<String, Definition> map2 = $receiver.getModel().getFunctions();
                    functionsRoot.1 var16_3 = this;
                    boolean $i$f$mapValues = false;
                    void var4_5 = $this$mapValues$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it;
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        Map map3 = destination$iv$iv;
                        boolean bl = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        K k = it$iv$iv.getKey();
                        Map map4 = map3;
                        boolean bl2 = false;
                        SchemaBasedObject schemaBasedObject = new SchemaBasedObject((Definition)it.getValue());
                        map4.put(k, schemaBasedObject);
                    }
                    var16_3.functions = destination$iv$iv;
                }

                @NotNull
                public String getName() {
                    return this.name;
                }

                public boolean isRequired() {
                    return this.isRequired;
                }

                public boolean isFunction() {
                    return this.isFunction;
                }

                public boolean isDeprecated() {
                    return this.isDeprecated;
                }

                public boolean isRenameable() {
                    return this.isRenameable;
                }

                public boolean isOverridable() {
                    return this.isOverridable;
                }

                public boolean getMustHaveValueDefinition() {
                    return this.mustHaveValueDefinition;
                }

                @NotNull
                public Set<String> getNames() {
                    return this.functions.keySet();
                }

                @Nullable
                public HelmObject findChildObject(@NotNull String name2) {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    return this.functions.get(name2);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/helm/gotpl/model/HelmGoTemplateResolver$UsageHandler;", "Lcom/intellij/kubernetes/helm/model/HelmResolver$UsagesHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "collectUsages", "", "Lcom/intellij/psi/PsiElement;", "pathInChart", "Lcom/intellij/kubernetes/helm/model/PathInChart;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "renameUsage", "", "element", "newName", "", "intellij.clouds.kubernetes.charts.gotpl"})
    @SourceDebugExtension(value={"SMAP\nHelmGoTemplateResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmGoTemplateResolver.kt\ncom/intellij/kubernetes/helm/gotpl/model/HelmGoTemplateResolver$UsageHandler\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,219:1\n31#2,2:220\n31#2,2:222\n*S KotlinDebug\n*F\n+ 1 HelmGoTemplateResolver.kt\ncom/intellij/kubernetes/helm/gotpl/model/HelmGoTemplateResolver$UsageHandler\n*L\n33#1:220,2\n37#1:222,2\n*E\n"})
    public static final class UsageHandler
    implements HelmResolver.UsagesHandler {
        @NotNull
        private final Project project;

        public UsageHandler(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }

        @Override
        @NotNull
        public Collection<PsiElement> collectUsages(@NotNull PathInChart pathInChart, @NotNull SearchScope searchScope) {
            Intrinsics.checkNotNullParameter((Object)pathInChart, (String)"pathInChart");
            Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<HelmGoTemplateResolver> serviceClass$iv = HelmGoTemplateResolver.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return ((HelmGoTemplateResolver)object).collectUsages(pathInChart, searchScope);
        }

        @Override
        public void renameUsage(@NotNull PsiElement element, @NotNull String newName) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<HelmGoTemplateResolver> serviceClass$iv = HelmGoTemplateResolver.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((HelmGoTemplateResolver)object).renameUsage(element, newName);
        }
    }
}

