/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.chart;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartLocator;
import com.intellij.kubernetes.helm.chart.ChartPresence;
import com.intellij.kubernetes.helm.tgz.TgzFileSystem;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\fJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\fJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\fJ\"\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c2\u0006\u0010\u001f\u001a\u00020\nH\u0002J\"\u0010 \u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\fJ\u0012\u0010!\u001a\u0004\u0018\u00010\f2\u0006\u0010\"\u001a\u00020\fH\u0002J\f\u0010#\u001a\u00020\n*\u00020$H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006%"}, d2={"Lcom/intellij/kubernetes/helm/chart/ChartManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myChartLocator", "Lcom/intellij/kubernetes/helm/chart/ChartLocator;", "getProject", "()Lcom/intellij/openapi/project/Project;", "findChartByBaseDir", "Lcom/intellij/kubernetes/helm/chart/Chart;", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "findChartByDefinitionElement", "element", "Lcom/intellij/psi/PsiElement;", "findChartByMetadataElement", "findChartByNonSpecialSubDir", "dir", "findChartByRelatedFile", "file", "findChartByTemplateElement", "findChartByTemplateFile", "templateFile", "findChartByValuesFile", "findChartFromDependency", "depFile", "getLogicalPaths", "Lkotlin/Pair;", "", "", "chart", "getLogicalPathsOfTemplateFile", "getTopDirFromTgz", "tgz", "toChart", "Lcom/intellij/kubernetes/helm/chart/ChartPresence;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nChartManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartManager.kt\ncom/intellij/kubernetes/helm/chart/ChartManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,105:1\n1#2:106\n1549#3:107\n1620#3,3:108\n1360#3:111\n1446#3,2:112\n1549#3:114\n1620#3,3:115\n1448#3,3:118\n1282#4,2:121\n*S KotlinDebug\n*F\n+ 1 ChartManager.kt\ncom/intellij/kubernetes/helm/chart/ChartManager\n*L\n86#1:107\n86#1:108,3\n92#1:111\n92#1:112,2\n93#1:114\n93#1:115,3\n92#1:118,3\n100#1:121,2\n*E\n"})
public final class ChartManager {
    @NotNull
    private final Project project;
    @NotNull
    private final ChartLocator myChartLocator;

    public ChartManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.myChartLocator = ChartLocator.Companion.instance();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Chart findChartByRelatedFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!file2.isValid()) {
            return null;
        }
        if (file2.isDirectory()) {
            return this.findChartByBaseDir(file2);
        }
        if (file2.getParent() == null) {
            return null;
        }
        Chart chart2 = this.findChartByTemplateFile(file2);
        if (chart2 == null) {
            VirtualFile virtualFile = file2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            chart2 = this.findChartByBaseDir(virtualFile);
        }
        return chart2;
    }

    @Nullable
    public final Chart findChartByBaseDir(@NotNull VirtualFile baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        ChartPresence chartPresence = this.myChartLocator.locateChartByChartDir(baseDir);
        return chartPresence != null ? this.toChart(chartPresence) : null;
    }

    @Nullable
    public final Chart findChartByDefinitionElement(@NotNull PsiElement element) {
        Chart chart2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VirtualFile virtualFile = YamlUtilKt.getVfsFile(element);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile containingFile = virtualFile;
        if (Chart.Companion.isChartFile(containingFile)) {
            VirtualFile virtualFile2 = containingFile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
            ChartPresence chartPresence = this.myChartLocator.locateChartByChartDir(virtualFile2);
            chart2 = chartPresence != null ? this.toChart(chartPresence) : null;
        } else {
            chart2 = this.findChartByValuesFile(containingFile);
        }
        return chart2;
    }

    @Nullable
    public final Chart findChartByMetadataElement(@NotNull PsiElement element) {
        Chart chart2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VirtualFile virtualFile = YamlUtilKt.getVfsFile(element);
        if (virtualFile != null && (virtualFile = virtualFile.getParent()) != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            chart2 = this.findChartByBaseDir(it);
        } else {
            chart2 = null;
        }
        return chart2;
    }

    @Nullable
    public final Chart findChartByTemplateElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VirtualFile virtualFile = YamlUtilKt.getVfsFile(element);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile templateFile = virtualFile;
        return this.findChartByTemplateFile(templateFile);
    }

    @Nullable
    public final Chart findChartByTemplateFile(@NotNull VirtualFile templateFile) {
        Intrinsics.checkNotNullParameter((Object)templateFile, (String)"templateFile");
        if (templateFile.isDirectory()) {
            return null;
        }
        ChartPresence chartPresence = this.myChartLocator.locateChartByTemplateFileOrDir(templateFile);
        return chartPresence != null ? this.toChart(chartPresence) : null;
    }

    @Nullable
    public final Chart findChartFromDependency(@NotNull VirtualFile depFile) {
        Intrinsics.checkNotNullParameter((Object)depFile, (String)"depFile");
        VirtualFile virtualFile = this.getTopDirFromTgz(depFile);
        if (virtualFile == null) {
            return null;
        }
        return this.findChartByBaseDir(virtualFile);
    }

    @Nullable
    public final Chart findChartByNonSpecialSubDir(@NotNull VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        ChartPresence chartPresence = this.myChartLocator.locateChartByNonSpecialSubDir(dir);
        return chartPresence != null ? this.toChart(chartPresence) : null;
    }

    @Nullable
    public final Chart findChartByValuesFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ChartPresence chartPresence = this.myChartLocator.locateChartByValuesFile(file2);
        return chartPresence != null ? this.toChart(chartPresence) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Pair<Chart, Collection<String>> getLogicalPathsOfTemplateFile(@NotNull VirtualFile templateFile) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)templateFile, (String)"templateFile");
        Chart chart2 = this.findChartByTemplateFile(templateFile);
        if (chart2 == null) {
            return null;
        }
        Chart chart3 = chart2;
        String string = FileUtil.getRelativePath((String)chart3.getBaseDir().getPath(), (String)templateFile.getPath(), (char)'/');
        Intrinsics.checkNotNull((Object)string);
        String relativePath = string;
        Pair<Chart, Collection<String>> it = this.getLogicalPaths(chart3);
        boolean bl = false;
        Iterable iterable = (Iterable)it.getSecond();
        Object object = it.getFirst();
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add((String)it2 + "/" + relativePath);
        }
        return TuplesKt.to((Object)object, (Object)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Chart, Collection<String>> getLogicalPaths(Chart chart2) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Chart chart3 = chart2.getSuperChart();
        if (chart3 == null) {
            return TuplesKt.to((Object)chart2, (Object)CollectionsKt.listOf((Object)chart2.getName()));
        }
        Chart superChart = chart3;
        Chart.Info info2 = chart2.getInfo();
        Collection<Chart.Dependency> dependencies2 = superChart.getDependenciesByChartNameAndVersion(chart2.getName(), info2 != null ? info2.getVersion() : null);
        Iterable iterable = dependencies2;
        Chart chart4 = superChart;
        boolean $i$f$flatMap = false;
        void var6_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Chart.Dependency dependency = (Chart.Dependency)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)this.getLogicalPaths(superChart).getSecond();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add((String)it + "/charts/" + dependency.getEffectiveName());
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return TuplesKt.to((Object)chart4, (Object)((List)destination$iv$iv));
    }

    private final VirtualFile getTopDirFromTgz(VirtualFile tgz) {
        Object object;
        block2: {
            VirtualFile virtualFile = TgzFileSystem.Companion.findRootByLocalArchive(tgz);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile archiveRoot = virtualFile;
            VirtualFile[] virtualFileArray = archiveRoot.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object[] $this$firstOrNull$iv = virtualFileArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (!it.isDirectory()) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        return (VirtualFile)object;
    }

    private final Chart toChart(ChartPresence $this$toChart) {
        return Chart.Companion.create$intellij_clouds_kubernetes(this, $this$toChart);
    }
}

