/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm;

import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.SchemaType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/helm/HelmValuesSchemaFileProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "chartManager", "Lcom/intellij/kubernetes/helm/chart/ChartManager;", "schemaFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/kubernetes/helm/chart/ChartManager;Lcom/intellij/openapi/vfs/VirtualFile;)V", "chartDir", "kotlin.jvm.PlatformType", "getName", "", "getSchemaFile", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "isAvailable", "", "file", "intellij.clouds.kubernetes"})
final class HelmValuesSchemaFileProvider
implements JsonSchemaFileProvider {
    @NotNull
    private final ChartManager chartManager;
    @NotNull
    private final VirtualFile schemaFile;
    private final VirtualFile chartDir;

    public HelmValuesSchemaFileProvider(@NotNull ChartManager chartManager, @NotNull VirtualFile schemaFile) {
        Intrinsics.checkNotNullParameter((Object)chartManager, (String)"chartManager");
        Intrinsics.checkNotNullParameter((Object)schemaFile, (String)"schemaFile");
        this.chartManager = chartManager;
        this.schemaFile = schemaFile;
        this.chartDir = this.schemaFile.getParent();
    }

    public boolean isAvailable(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Chart chart2 = this.chartManager.findChartByValuesFile(file2);
        return Intrinsics.areEqual((Object)(chart2 != null ? chart2.getBaseDir() : null), (Object)this.chartDir);
    }

    @NotNull
    public String getName() {
        String string = KubernetesBundle.message("HelmJsonSchemaService.schema.file.provider.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public VirtualFile getSchemaFile() {
        return this.schemaFile;
    }

    @NotNull
    public SchemaType getSchemaType() {
        return SchemaType.schema;
    }
}

