/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm;

import com.intellij.kubernetes.helm.HelmValuesSchemaFileProvider;
import com.intellij.kubernetes.helm.ValuesSchemaModificationListener;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kubernetes/helm/HelmJsonSchemaService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "lastRequestedWhenDumb", "Ljava/util/concurrent/atomic/AtomicBoolean;", "valuesSchemaModificationListener", "Lcom/intellij/kubernetes/helm/ValuesSchemaModificationListener;", "dispose", "", "getJsonSchemaFileProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmJsonSchemaService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmJsonSchemaService.kt\ncom/intellij/kubernetes/helm/HelmJsonSchemaService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,105:1\n31#2,2:106\n*S KotlinDebug\n*F\n+ 1 HelmJsonSchemaService.kt\ncom/intellij/kubernetes/helm/HelmJsonSchemaService\n*L\n49#1:106,2\n*E\n"})
public final class HelmJsonSchemaService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ValuesSchemaModificationListener valuesSchemaModificationListener;
    @NotNull
    private final AtomicBoolean lastRequestedWhenDumb;

    public HelmJsonSchemaService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.valuesSchemaModificationListener = new ValuesSchemaModificationListener(this.project);
        this.lastRequestedWhenDumb = new AtomicBoolean(false);
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        connection.subscribe(topic, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)this.valuesSchemaModificationListener));
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                block1: {
                    if (!lastRequestedWhenDumb.compareAndSet(true, false)) break block1;
                    ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
                    boolean $i$f$serviceIfCreated = false;
                    JsonSchemaService jsonSchemaService = (JsonSchemaService)$this$serviceIfCreated$iv.getServiceIfCreated(JsonSchemaService.class);
                    if (jsonSchemaService != null) {
                        jsonSchemaService.reset();
                    }
                }
            }
        });
    }

    @NotNull
    public final List<JsonSchemaFileProvider> getJsonSchemaFileProviders() {
        List list2;
        boolean isDumb = DumbService.Companion.isDumb(this.project);
        this.lastRequestedWhenDumb.set(isDumb);
        if (isDumb) {
            List list3 = Collections.emptyList();
            Intrinsics.checkNotNull(list3);
            list2 = list3;
        } else {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<ChartManager> serviceClass$iv = ChartManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ChartManager chartManager = (ChartManager)object;
            Collection collection = FilenameIndex.getVirtualFilesByName((String)"values.schema.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.project));
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
            list2 = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<VirtualFile, Boolean>(chartManager){
                final /* synthetic */ ChartManager $chartManager;
                {
                    this.$chartManager = $chartManager;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(VirtualFile it) {
                    VirtualFile virtualFile = it.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
                    return this.$chartManager.findChartByBaseDir(virtualFile) != null;
                }
            })), (Function1)((Function1)new Function1<VirtualFile, HelmValuesSchemaFileProvider>(chartManager){
                final /* synthetic */ ChartManager $chartManager;
                {
                    this.$chartManager = $chartManager;
                    super(1);
                }

                @NotNull
                public final HelmValuesSchemaFileProvider invoke(VirtualFile it) {
                    Intrinsics.checkNotNull((Object)it);
                    return new HelmValuesSchemaFileProvider(this.$chartManager, it);
                }
            })));
        }
        return list2;
    }

    public void dispose() {
    }
}

